/*
 * Decompiled with CFR 0.152.
 */
package io.lindstrom.m3u8.model;

import io.lindstrom.m3u8.model.AlternativeRendition;
import io.lindstrom.m3u8.model.ContentSteering;
import io.lindstrom.m3u8.model.IFrameVariant;
import io.lindstrom.m3u8.model.MultivariantPlaylist;
import io.lindstrom.m3u8.model.Playlist;
import io.lindstrom.m3u8.model.PlaylistVariable;
import io.lindstrom.m3u8.model.SegmentKey;
import io.lindstrom.m3u8.model.SessionData;
import io.lindstrom.m3u8.model.StartTimeOffset;
import io.lindstrom.m3u8.model.Variant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

class MultivariantPlaylistBuilder {
    private static final long OPT_BIT_INDEPENDENT_SEGMENTS = 1L;
    private long optBits;
    private List<AlternativeRendition> alternativeRenditions = new ArrayList<AlternativeRendition>();
    private List<Variant> variants = new ArrayList<Variant>();
    private List<IFrameVariant> iFrameVariants = new ArrayList<IFrameVariant>();
    private List<SessionData> sessionData = new ArrayList<SessionData>();
    private List<SegmentKey> sessionKeys = new ArrayList<SegmentKey>();
    private ContentSteering contentSteering;
    private Integer version;
    private boolean independentSegments;
    private StartTimeOffset startTimeOffset;
    private List<PlaylistVariable> variables = new ArrayList<PlaylistVariable>();
    private List<String> comments = new ArrayList<String>();

    MultivariantPlaylistBuilder() {
        if (!(this instanceof MultivariantPlaylist.Builder)) {
            throw new UnsupportedOperationException("Use: new MultivariantPlaylist.Builder()");
        }
    }

    public final MultivariantPlaylist.Builder from(Playlist instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder from(MultivariantPlaylist instance) {
        Objects.requireNonNull(instance, "instance");
        this.from((Object)instance);
        return (MultivariantPlaylist.Builder)this;
    }

    private void from(Object object) {
        Playlist instance;
        if (object instanceof Playlist) {
            Optional<Integer> versionOptional;
            instance = (Playlist)object;
            this.addAllVariables(instance.variables());
            this.addAllComments(instance.comments());
            this.independentSegments(instance.independentSegments());
            Optional<StartTimeOffset> startTimeOffsetOptional = instance.startTimeOffset();
            if (startTimeOffsetOptional.isPresent()) {
                this.startTimeOffset(startTimeOffsetOptional);
            }
            if ((versionOptional = instance.version()).isPresent()) {
                this.version(versionOptional);
            }
        }
        if (object instanceof MultivariantPlaylist) {
            instance = (MultivariantPlaylist)object;
            this.addAllAlternativeRenditions(instance.alternativeRenditions());
            this.addAllIFrameVariants(instance.iFrameVariants());
            this.addAllSessionData(instance.sessionData());
            this.addAllVariants(instance.variants());
            Optional<ContentSteering> contentSteeringOptional = instance.contentSteering();
            if (contentSteeringOptional.isPresent()) {
                this.contentSteering(contentSteeringOptional);
            }
            this.addAllSessionKeys(instance.sessionKeys());
        }
    }

    public final MultivariantPlaylist.Builder addAlternativeRenditions(AlternativeRendition element) {
        this.alternativeRenditions.add(Objects.requireNonNull(element, "alternativeRenditions element"));
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addAlternativeRenditions(AlternativeRendition ... elements) {
        for (AlternativeRendition element : elements) {
            this.alternativeRenditions.add(Objects.requireNonNull(element, "alternativeRenditions element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder alternativeRenditions(Iterable<? extends AlternativeRendition> elements) {
        this.alternativeRenditions.clear();
        return this.addAllAlternativeRenditions(elements);
    }

    public final MultivariantPlaylist.Builder addAllAlternativeRenditions(Iterable<? extends AlternativeRendition> elements) {
        for (AlternativeRendition alternativeRendition : elements) {
            this.alternativeRenditions.add(Objects.requireNonNull(alternativeRendition, "alternativeRenditions element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addVariants(Variant element) {
        this.variants.add(Objects.requireNonNull(element, "variants element"));
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addVariants(Variant ... elements) {
        for (Variant element : elements) {
            this.variants.add(Objects.requireNonNull(element, "variants element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder variants(Iterable<? extends Variant> elements) {
        this.variants.clear();
        return this.addAllVariants(elements);
    }

    public final MultivariantPlaylist.Builder addAllVariants(Iterable<? extends Variant> elements) {
        for (Variant variant : elements) {
            this.variants.add(Objects.requireNonNull(variant, "variants element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addIFrameVariants(IFrameVariant element) {
        this.iFrameVariants.add(Objects.requireNonNull(element, "iFrameVariants element"));
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addIFrameVariants(IFrameVariant ... elements) {
        for (IFrameVariant element : elements) {
            this.iFrameVariants.add(Objects.requireNonNull(element, "iFrameVariants element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder iFrameVariants(Iterable<? extends IFrameVariant> elements) {
        this.iFrameVariants.clear();
        return this.addAllIFrameVariants(elements);
    }

    public final MultivariantPlaylist.Builder addAllIFrameVariants(Iterable<? extends IFrameVariant> elements) {
        for (IFrameVariant iFrameVariant : elements) {
            this.iFrameVariants.add(Objects.requireNonNull(iFrameVariant, "iFrameVariants element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addSessionData(SessionData element) {
        this.sessionData.add(Objects.requireNonNull(element, "sessionData element"));
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addSessionData(SessionData ... elements) {
        for (SessionData element : elements) {
            this.sessionData.add(Objects.requireNonNull(element, "sessionData element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder sessionData(Iterable<? extends SessionData> elements) {
        this.sessionData.clear();
        return this.addAllSessionData(elements);
    }

    public final MultivariantPlaylist.Builder addAllSessionData(Iterable<? extends SessionData> elements) {
        for (SessionData sessionData : elements) {
            this.sessionData.add(Objects.requireNonNull(sessionData, "sessionData element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addSessionKeys(SegmentKey element) {
        this.sessionKeys.add(Objects.requireNonNull(element, "sessionKeys element"));
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addSessionKeys(SegmentKey ... elements) {
        for (SegmentKey element : elements) {
            this.sessionKeys.add(Objects.requireNonNull(element, "sessionKeys element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder sessionKeys(Iterable<? extends SegmentKey> elements) {
        this.sessionKeys.clear();
        return this.addAllSessionKeys(elements);
    }

    public final MultivariantPlaylist.Builder addAllSessionKeys(Iterable<? extends SegmentKey> elements) {
        for (SegmentKey segmentKey : elements) {
            this.sessionKeys.add(Objects.requireNonNull(segmentKey, "sessionKeys element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder contentSteering(ContentSteering contentSteering) {
        this.contentSteering = Objects.requireNonNull(contentSteering, "contentSteering");
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder contentSteering(Optional<? extends ContentSteering> contentSteering) {
        this.contentSteering = contentSteering.orElse(null);
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder version(int version) {
        this.version = version;
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder version(Optional<Integer> version) {
        this.version = version.orElse(null);
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder independentSegments(boolean independentSegments) {
        this.independentSegments = independentSegments;
        this.optBits |= 1L;
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder startTimeOffset(StartTimeOffset startTimeOffset) {
        this.startTimeOffset = Objects.requireNonNull(startTimeOffset, "startTimeOffset");
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder startTimeOffset(Optional<? extends StartTimeOffset> startTimeOffset) {
        this.startTimeOffset = startTimeOffset.orElse(null);
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addVariables(PlaylistVariable element) {
        this.variables.add(Objects.requireNonNull(element, "variables element"));
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addVariables(PlaylistVariable ... elements) {
        for (PlaylistVariable element : elements) {
            this.variables.add(Objects.requireNonNull(element, "variables element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder variables(Iterable<? extends PlaylistVariable> elements) {
        this.variables.clear();
        return this.addAllVariables(elements);
    }

    public final MultivariantPlaylist.Builder addAllVariables(Iterable<? extends PlaylistVariable> elements) {
        for (PlaylistVariable playlistVariable : elements) {
            this.variables.add(Objects.requireNonNull(playlistVariable, "variables element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addComments(String element) {
        this.comments.add(Objects.requireNonNull(element, "comments element"));
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder addComments(String ... elements) {
        for (String element : elements) {
            this.comments.add(Objects.requireNonNull(element, "comments element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public final MultivariantPlaylist.Builder comments(Iterable<String> elements) {
        this.comments.clear();
        return this.addAllComments(elements);
    }

    public final MultivariantPlaylist.Builder addAllComments(Iterable<String> elements) {
        for (String element : elements) {
            this.comments.add(Objects.requireNonNull(element, "comments element"));
        }
        return (MultivariantPlaylist.Builder)this;
    }

    public MultivariantPlaylist build() {
        return new ImmutableMultivariantPlaylist(this);
    }

    private boolean independentSegmentsIsSet() {
        return (this.optBits & 1L) != 0L;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static final class ImmutableMultivariantPlaylist
    implements MultivariantPlaylist {
        private final List<AlternativeRendition> alternativeRenditions;
        private final List<Variant> variants;
        private final List<IFrameVariant> iFrameVariants;
        private final List<SessionData> sessionData;
        private final List<SegmentKey> sessionKeys;
        private final ContentSteering contentSteering;
        private final Integer version;
        private final boolean independentSegments;
        private final StartTimeOffset startTimeOffset;
        private final List<PlaylistVariable> variables;
        private final List<String> comments;

        private ImmutableMultivariantPlaylist(MultivariantPlaylistBuilder builder) {
            this.alternativeRenditions = MultivariantPlaylistBuilder.createUnmodifiableList(true, builder.alternativeRenditions);
            this.variants = MultivariantPlaylistBuilder.createUnmodifiableList(true, builder.variants);
            this.iFrameVariants = MultivariantPlaylistBuilder.createUnmodifiableList(true, builder.iFrameVariants);
            this.sessionData = MultivariantPlaylistBuilder.createUnmodifiableList(true, builder.sessionData);
            this.sessionKeys = MultivariantPlaylistBuilder.createUnmodifiableList(true, builder.sessionKeys);
            this.contentSteering = builder.contentSteering;
            this.version = builder.version;
            this.startTimeOffset = builder.startTimeOffset;
            this.variables = MultivariantPlaylistBuilder.createUnmodifiableList(true, builder.variables);
            this.comments = MultivariantPlaylistBuilder.createUnmodifiableList(true, builder.comments);
            this.independentSegments = builder.independentSegmentsIsSet() ? builder.independentSegments : MultivariantPlaylist.super.independentSegments();
        }

        @Override
        public List<AlternativeRendition> alternativeRenditions() {
            return this.alternativeRenditions;
        }

        @Override
        public List<Variant> variants() {
            return this.variants;
        }

        @Override
        public List<IFrameVariant> iFrameVariants() {
            return this.iFrameVariants;
        }

        @Override
        public List<SessionData> sessionData() {
            return this.sessionData;
        }

        @Override
        public List<SegmentKey> sessionKeys() {
            return this.sessionKeys;
        }

        @Override
        public Optional<ContentSteering> contentSteering() {
            return Optional.ofNullable(this.contentSteering);
        }

        @Override
        public Optional<Integer> version() {
            return Optional.ofNullable(this.version);
        }

        @Override
        public boolean independentSegments() {
            return this.independentSegments;
        }

        @Override
        public Optional<StartTimeOffset> startTimeOffset() {
            return Optional.ofNullable(this.startTimeOffset);
        }

        @Override
        public List<PlaylistVariable> variables() {
            return this.variables;
        }

        @Override
        public List<String> comments() {
            return this.comments;
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof ImmutableMultivariantPlaylist && this.equalTo((ImmutableMultivariantPlaylist)another);
        }

        private boolean equalTo(ImmutableMultivariantPlaylist another) {
            return this.alternativeRenditions.equals(another.alternativeRenditions) && this.variants.equals(another.variants) && this.iFrameVariants.equals(another.iFrameVariants) && this.sessionData.equals(another.sessionData) && this.sessionKeys.equals(another.sessionKeys) && Objects.equals(this.contentSteering, another.contentSteering) && Objects.equals(this.version, another.version) && this.independentSegments == another.independentSegments && Objects.equals(this.startTimeOffset, another.startTimeOffset) && this.variables.equals(another.variables) && this.comments.equals(another.comments);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.alternativeRenditions.hashCode();
            h += (h << 5) + this.variants.hashCode();
            h += (h << 5) + this.iFrameVariants.hashCode();
            h += (h << 5) + this.sessionData.hashCode();
            h += (h << 5) + this.sessionKeys.hashCode();
            h += (h << 5) + Objects.hashCode(this.contentSteering);
            h += (h << 5) + Objects.hashCode(this.version);
            h += (h << 5) + Boolean.hashCode(this.independentSegments);
            h += (h << 5) + Objects.hashCode(this.startTimeOffset);
            h += (h << 5) + this.variables.hashCode();
            h += (h << 5) + this.comments.hashCode();
            return h;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("MultivariantPlaylist{");
            builder.append("alternativeRenditions=").append(this.alternativeRenditions);
            builder.append(", ");
            builder.append("variants=").append(this.variants);
            builder.append(", ");
            builder.append("iFrameVariants=").append(this.iFrameVariants);
            builder.append(", ");
            builder.append("sessionData=").append(this.sessionData);
            builder.append(", ");
            builder.append("sessionKeys=").append(this.sessionKeys);
            if (this.contentSteering != null) {
                builder.append(", ");
                builder.append("contentSteering=").append(this.contentSteering);
            }
            if (this.version != null) {
                builder.append(", ");
                builder.append("version=").append(this.version);
            }
            builder.append(", ");
            builder.append("independentSegments=").append(this.independentSegments);
            if (this.startTimeOffset != null) {
                builder.append(", ");
                builder.append("startTimeOffset=").append(this.startTimeOffset);
            }
            builder.append(", ");
            builder.append("variables=").append(this.variables);
            builder.append(", ");
            builder.append("comments=").append(this.comments);
            return builder.append("}").toString();
        }
    }
}

