/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;

public class SugAddArgs<K, V> {
    private boolean incr;
    private V payload;

    public SugAddArgs<K, V> incr() {
        this.incr = true;
        return this;
    }

    public SugAddArgs<K, V> payload(V payload) {
        this.payload = payload;
        return this;
    }

    public void build(CommandArgs<K, V> args) {
        if (this.incr) {
            args.add("INCR");
        }
        if (this.payload != null) {
            args.add("PAYLOAD").addValue(this.payload);
        }
    }

    public static class Builder {
        private Builder() {
        }

        public static <K, V> SugAddArgs<K, V> incr() {
            return new SugAddArgs().incr();
        }

        public static <K, V> SugAddArgs<K, V> payload(V payload) {
            return new SugAddArgs().payload(payload);
        }
    }
}

