/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.annotations.Experimental;
import io.lettuce.core.internal.LettuceAssert;
import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.search.arguments.ScoringFunction;
import java.util.Optional;

@Experimental
public class HybridSearchArgs<K, V> {
    private final V query;
    private final Scorer scorer;
    private final K scoreAlias;

    private HybridSearchArgs(Builder<K, V> builder) {
        this.query = ((Builder)builder).query;
        this.scorer = ((Builder)builder).scorer;
        this.scoreAlias = ((Builder)builder).scoreAlias;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public V getQuery() {
        return this.query;
    }

    public Optional<Scorer> getScorer() {
        return Optional.ofNullable(this.scorer);
    }

    public Optional<K> getScoreAlias() {
        return Optional.ofNullable(this.scoreAlias);
    }

    public void build(CommandArgs<K, V> args) {
        args.add(CommandKeyword.SEARCH);
        args.addValue(this.query);
        if (this.scorer != null) {
            this.scorer.build(args);
        }
        if (this.scoreAlias != null) {
            args.add(CommandKeyword.YIELD_SCORE_AS);
            args.addKey(this.scoreAlias);
        }
    }

    public static class Scorer {
        private final ScoringFunction algorithm;

        private Scorer(ScoringFunction algorithm) {
            this.algorithm = algorithm;
        }

        public static Scorer of(ScoringFunction algorithm) {
            LettuceAssert.notNull((Object)algorithm, "Algorithm must not be null");
            return new Scorer(algorithm);
        }

        public <K, V> void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.SCORER);
            args.add(this.algorithm.toString());
        }
    }

    public static class Builder<K, V> {
        private V query;
        private Scorer scorer;
        private K scoreAlias;

        public Builder<K, V> query(V query) {
            LettuceAssert.notNull(query, "Query must not be null");
            this.query = query;
            return this;
        }

        public Builder<K, V> scorer(Scorer scorer) {
            LettuceAssert.notNull((Object)scorer, "Scorer must not be null");
            this.scorer = scorer;
            return this;
        }

        public Builder<K, V> scoreAlias(K alias) {
            LettuceAssert.notNull(alias, "Score alias must not be null");
            this.scoreAlias = alias;
            return this;
        }

        public HybridSearchArgs<K, V> build() {
            LettuceAssert.notNull(this.query, "Query must not be null");
            return new HybridSearchArgs(this);
        }
    }
}

