/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class HighlightArgs<K, V> {
    private final List<K> fields = new ArrayList<K>();
    private Optional<Tags<V>> tags = Optional.empty();

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public void build(CommandArgs<K, V> args) {
        args.add(CommandKeyword.HIGHLIGHT);
        if (!this.fields.isEmpty()) {
            args.add(CommandKeyword.FIELDS);
            args.add(this.fields.size());
            args.addKeys((Iterable<K>)this.fields);
        }
        this.tags.ifPresent(tags -> {
            args.add(CommandKeyword.TAGS);
            args.addValue(((Tags)tags).startTag);
            args.addValue(((Tags)tags).endTag);
        });
    }

    static class Tags<V> {
        private final V startTag;
        private final V endTag;

        Tags(V startTag, V endTag) {
            this.startTag = startTag;
            this.endTag = endTag;
        }
    }

    public static class Builder<K, V> {
        private final HighlightArgs<K, V> highlightArgs = new HighlightArgs();

        public Builder<K, V> field(K field) {
            ((HighlightArgs)this.highlightArgs).fields.add(field);
            return this;
        }

        public Builder<K, V> tags(V startTag, V endTag) {
            ((HighlightArgs)this.highlightArgs).tags = Optional.of(new Tags<V>(startTag, endTag));
            return this;
        }

        public HighlightArgs<K, V> build() {
            return this.highlightArgs;
        }
    }
}

