/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.cluster;

import io.lettuce.core.ClientOptions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import io.lettuce.core.cluster.pubsub.RedisClusterPubSubAdapter;
import io.lettuce.core.cluster.pubsub.RedisClusterPubSubListener;
import io.lettuce.core.pubsub.PubSubEndpoint;
import io.lettuce.core.pubsub.PubSubOutput;
import io.lettuce.core.resource.ClientResources;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class PubSubClusterEndpoint<K, V>
extends PubSubEndpoint<K, V> {
    private final List<RedisClusterPubSubListener<K, V>> clusterListeners = new CopyOnWriteArrayList<RedisClusterPubSubListener<K, V>>();
    private final NotifyingMessageListener multicast = new NotifyingMessageListener();
    private final UpstreamMessageListener upstream = new UpstreamMessageListener();
    private volatile boolean nodeMessagePropagation = false;
    private volatile RedisClusterNode clusterNode;

    public PubSubClusterEndpoint(ClientOptions clientOptions, ClientResources clientResources) {
        super(clientOptions, clientResources);
    }

    @Override
    public void addListener(RedisClusterPubSubListener<K, V> listener) {
        this.clusterListeners.add(listener);
    }

    public RedisClusterPubSubListener<K, V> getUpstreamListener() {
        return this.upstream;
    }

    @Override
    public void removeListener(RedisClusterPubSubListener<K, V> listener) {
        this.clusterListeners.remove(listener);
    }

    public void setNodeMessagePropagation(boolean nodeMessagePropagation) {
        this.nodeMessagePropagation = nodeMessagePropagation;
    }

    void setClusterNode(RedisClusterNode clusterNode) {
        this.clusterNode = clusterNode;
    }

    @Override
    protected void notifyListeners(PubSubOutput<K, V, V> output) {
        switch (output.type()) {
            case message: {
                this.multicast.message(this.clusterNode, output.channel(), output.get());
                break;
            }
            case pmessage: {
                this.multicast.message(this.clusterNode, output.pattern(), output.channel(), output.get());
                break;
            }
            case psubscribe: {
                this.multicast.psubscribed(this.clusterNode, output.pattern(), output.count());
                break;
            }
            case punsubscribe: {
                this.multicast.punsubscribed(this.clusterNode, output.pattern(), output.count());
                break;
            }
            case subscribe: {
                this.multicast.subscribed(this.clusterNode, output.channel(), output.count());
                break;
            }
            case unsubscribe: {
                this.multicast.unsubscribed(this.clusterNode, output.channel(), output.count());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Operation " + (Object)((Object)output.type()) + " not supported");
            }
        }
    }

    private class NotifyingMessageListener
    extends RedisClusterPubSubAdapter<K, V> {
        private NotifyingMessageListener() {
        }

        @Override
        public void message(RedisClusterNode node, K channel, V message) {
            PubSubClusterEndpoint.this.getListeners().forEach(listener -> listener.message(channel, message));
            PubSubClusterEndpoint.this.clusterListeners.forEach(listener -> listener.message(node, channel, message));
        }

        @Override
        public void message(RedisClusterNode node, K pattern, K channel, V message) {
            PubSubClusterEndpoint.this.getListeners().forEach(listener -> listener.message(pattern, channel, message));
            PubSubClusterEndpoint.this.clusterListeners.forEach(listener -> listener.message(node, pattern, channel, message));
        }

        @Override
        public void subscribed(RedisClusterNode node, K channel, long count) {
            PubSubClusterEndpoint.this.getListeners().forEach(listener -> listener.subscribed(channel, count));
            PubSubClusterEndpoint.this.clusterListeners.forEach(listener -> listener.subscribed(node, channel, count));
        }

        @Override
        public void psubscribed(RedisClusterNode node, K pattern, long count) {
            PubSubClusterEndpoint.this.getListeners().forEach(listener -> listener.psubscribed(pattern, count));
            PubSubClusterEndpoint.this.clusterListeners.forEach(listener -> listener.psubscribed(node, pattern, count));
        }

        @Override
        public void unsubscribed(RedisClusterNode node, K channel, long count) {
            PubSubClusterEndpoint.this.getListeners().forEach(listener -> listener.unsubscribed(channel, count));
            PubSubClusterEndpoint.this.clusterListeners.forEach(listener -> listener.unsubscribed(node, channel, count));
        }

        @Override
        public void punsubscribed(RedisClusterNode node, K pattern, long count) {
            PubSubClusterEndpoint.this.getListeners().forEach(listener -> listener.punsubscribed(pattern, count));
            PubSubClusterEndpoint.this.clusterListeners.forEach(listener -> listener.punsubscribed(node, pattern, count));
        }
    }

    private class UpstreamMessageListener
    extends NotifyingMessageListener {
        private UpstreamMessageListener() {
        }

        @Override
        public void message(RedisClusterNode node, K channel, V message) {
            if (PubSubClusterEndpoint.this.nodeMessagePropagation) {
                super.message(node, channel, message);
            }
        }

        @Override
        public void message(RedisClusterNode node, K pattern, K channel, V message) {
            if (PubSubClusterEndpoint.this.nodeMessagePropagation) {
                super.message(node, pattern, channel, message);
            }
        }

        @Override
        public void subscribed(RedisClusterNode node, K channel, long count) {
            if (PubSubClusterEndpoint.this.nodeMessagePropagation) {
                super.subscribed(node, channel, count);
            }
        }

        @Override
        public void psubscribed(RedisClusterNode node, K pattern, long count) {
            if (PubSubClusterEndpoint.this.nodeMessagePropagation) {
                super.psubscribed(node, pattern, count);
            }
        }

        @Override
        public void unsubscribed(RedisClusterNode node, K channel, long count) {
            if (PubSubClusterEndpoint.this.nodeMessagePropagation) {
                super.unsubscribed(node, channel, count);
            }
        }

        @Override
        public void punsubscribed(RedisClusterNode node, K pattern, long count) {
            if (PubSubClusterEndpoint.this.nodeMessagePropagation) {
                super.punsubscribed(node, pattern, count);
            }
        }
    }
}

