/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.json.serialize;

import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;

public abstract class ContextualJsonSerializer<A extends Annotation>
extends JsonSerializer<Object>
implements ContextualSerializer {
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        if (beanProperty != null) {
            Class<A> clazz = this.annotation();
            Annotation anno = beanProperty.getAnnotation(clazz);
            if (anno == null) {
                anno = beanProperty.getContextAnnotation(clazz);
            }
            if (anno != null) {
                try {
                    return this.create(clazz, anno, beanProperty);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
            return serializerProvider.findValueSerializer(beanProperty.getType(), beanProperty);
        }
        return serializerProvider.findNullValueSerializer(beanProperty);
    }

    public JsonSerializer<?> create(Class<A> annoClazz, A anno, BeanProperty beanProperty) throws Exception {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        Constructor<?> constructor = clazz.getConstructor(BeanProperty.class, annoClazz);
        return (JsonSerializer)constructor.newInstance(beanProperty, anno);
    }

    public Class<A> annotation() {
        ParameterizedType type = (ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass();
        Class clazz = (Class)type.getActualTypeArguments()[0];
        return clazz;
    }
}

