/*
 * Decompiled with CFR 0.152.
 */
package io.leopard.json;

import io.leopard.json.IJson;
import io.leopard.json.JsonFastJsonImpl;
import io.leopard.json.JsonJacksonImpl;
import java.util.List;
import java.util.Map;

public class Json {
    private static final Class<?>[] classes = new Class[]{JsonJacksonImpl.class, JsonFastJsonImpl.class};
    private static final IJson instance = Json.newInstance();

    public static IJson getInstance() {
        return instance;
    }

    private static IJson newInstance() {
        for (Class<?> clazz : classes) {
            try {
                return (IJson)clazz.newInstance();
            }
            catch (NoClassDefFoundError e) {
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        throw new NoClassDefFoundError("jackson\u6216fastjson\u5305\u627e\u4e0d\u5230.");
    }

    public static String toFormatJson(Object obj) {
        return instance.toFormatJson(obj);
    }

    public static String toJson(Object obj) {
        return instance.toJson(obj);
    }

    public static <T> T toObject(String json, Class<T> clazz) {
        return instance.toObject(json, clazz);
    }

    public static <T> T toObject(String json, Class<T> clazz, boolean ignoreUnknownField) {
        return instance.toObject(json, clazz, ignoreUnknownField);
    }

    public static Map<String, Object> toMap(String json) {
        return instance.toMap(json);
    }

    public static <T> List<T> toListObject(String content, Class<T> clazz) {
        return instance.toListObject(content, clazz);
    }

    public static <T> List<T> toListObject(String content, Class<T> clazz, boolean ignoreUnknownField) {
        return instance.toListObject(content, clazz, ignoreUnknownField);
    }

    public static <T> List<T> toListObject(List<String> jsonList, Class<T> clazz) {
        return instance.toListObject(jsonList, clazz);
    }

    public static <T> List<T> toListObject(List<String> jsonList, Class<T> clazz, boolean ignoreUnknownField) {
        return instance.toListObject(jsonList, clazz, ignoreUnknownField);
    }

    private static String getTargetClassSimpleName() {
        StackTraceElement element = Thread.currentThread().getStackTrace()[3];
        String className = element.getClassName();
        int index = className.lastIndexOf(".");
        if (index == -1) {
            return className;
        }
        return className.substring(index + 1);
    }

    public static void print(Object obj) {
        String json = Json.toJson(obj);
        String targetClassSimpleName = Json.getTargetClassSimpleName();
        System.out.println("json[" + targetClassSimpleName + "]:" + json);
    }

    public static void print(Object obj, String name) {
        String json = Json.toJson(obj);
        String targetClassSimpleName = Json.getTargetClassSimpleName();
        System.out.println("json[" + targetClassSimpleName + "] info " + name + "::" + json);
    }

    public static void printFormat(Object obj, String name) {
        String json = Json.toFormatJson(obj);
        String targetClassSimpleName = Json.getTargetClassSimpleName();
        System.out.println("json[" + targetClassSimpleName + "] info " + name + "::" + json);
    }

    public static void printMap(Map map, String name) {
        if (map == null) {
            System.out.println("json info " + name + "::null");
            return;
        }
        if (map.size() == 0) {
            System.out.println("json info " + name + "::");
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            System.out.println(name + " key:" + key + " json:" + Json.toJson(value));
        }
    }

    public static void printList(List list, String name) {
        if (list == null) {
            System.out.println("json info " + name + "::null");
            return;
        }
        if (list.size() == 0) {
            System.out.println("json info " + name + "::");
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object element = list.get(i);
            System.out.println("json info(" + i + ") " + name + "::" + Json.toJson(element));
        }
    }
}

