/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer.cache;

import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.cache.DeltaFIFO;
import io.kubernetes.client.informer.exception.BadNotificationException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessorListener<ApiType>
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ProcessorListener.class);
    private static final int DEFAULT_QUEUE_CAPACITY = 1000;
    private long resyncPeriod;
    private DateTime nextResync;
    private BlockingQueue<Notification> queue;
    private ResourceEventHandler<ApiType> handler;

    public ProcessorListener(ResourceEventHandler<ApiType> handler, long resyncPeriod) {
        this.resyncPeriod = resyncPeriod;
        this.handler = handler;
        this.queue = new ArrayBlockingQueue<Notification>(1000);
        this.determineNextResync(DateTime.now());
    }

    @Override
    public void run() {
        try {
            while (true) {
                Notification notification;
                Notification obj;
                if ((obj = this.queue.take()) instanceof UpdateNotification) {
                    notification = (UpdateNotification)obj;
                    this.handler.onUpdate(((UpdateNotification)notification).getOldObj(), ((UpdateNotification)notification).getNewObj());
                    continue;
                }
                if (obj instanceof AddNotification) {
                    notification = (AddNotification)obj;
                    this.handler.onAdd(((AddNotification)notification).getNewObj());
                    continue;
                }
                if (!(obj instanceof DeleteNotification)) break;
                Object deletedObj = ((DeleteNotification)obj).getOldObj();
                if (deletedObj instanceof DeltaFIFO.DeletedFinalStateUnknown) {
                    this.handler.onDelete(((DeltaFIFO.DeletedFinalStateUnknown)deletedObj).getObj(), true);
                    continue;
                }
                this.handler.onDelete(deletedObj, false);
            }
            throw new BadNotificationException("unrecognized notification");
        }
        catch (InterruptedException e) {
            log.error("processor interrupted: {}", (Object)e.getMessage());
            return;
        }
    }

    public void add(Notification<ApiType> obj) {
        if (obj == null) {
            return;
        }
        this.queue.add(obj);
    }

    public void determineNextResync(DateTime now) {
        this.nextResync = now.plus(this.resyncPeriod);
    }

    public boolean shouldResync(DateTime now) {
        return this.resyncPeriod != 0L && (now.isAfter((ReadableInstant)this.nextResync) || now.equals((Object)this.nextResync));
    }

    public static final class DeleteNotification<ApiType>
    extends Notification<ApiType> {
        private ApiType oldObj;

        public DeleteNotification(ApiType oldObj) {
            this.oldObj = oldObj;
        }

        ApiType getOldObj() {
            return this.oldObj;
        }
    }

    public static final class AddNotification<ApiType>
    extends Notification<ApiType> {
        private ApiType newObj;

        public AddNotification(ApiType newObj) {
            this.newObj = newObj;
        }

        ApiType getNewObj() {
            return this.newObj;
        }
    }

    public static final class UpdateNotification<ApiType>
    extends Notification<ApiType> {
        private ApiType oldObj;
        private ApiType newObj;

        public UpdateNotification(ApiType oldObj, ApiType newObj) {
            this.oldObj = oldObj;
            this.newObj = newObj;
        }

        ApiType getOldObj() {
            return this.oldObj;
        }

        ApiType getNewObj() {
            return this.newObj;
        }
    }

    public static class Notification<ApiType> {
    }
}

