/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import com.squareup.okhttp.Call;
import com.squareup.okhttp.Response;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.apis.CoreV1Api;
import io.kubernetes.client.models.V1Container;
import io.kubernetes.client.models.V1Pod;
import java.io.IOException;
import java.io.InputStream;

public class PodLogs {
    private ApiClient apiClient;
    private CoreV1Api coreClient;

    public PodLogs() {
        this(Configuration.getDefaultApiClient());
    }

    public PodLogs(ApiClient apiClient) {
        this.apiClient = apiClient;
        this.coreClient = new CoreV1Api(apiClient);
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public InputStream streamNamespacedPodLog(V1Pod pod) throws ApiException, IOException {
        return this.streamNamespacedPodLog(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), ((V1Container)pod.getSpec().getContainers().get(0)).getName());
    }

    public InputStream streamNamespacedPodLog(String namespace, String name, String container) throws ApiException, IOException {
        return this.streamNamespacedPodLog(namespace, name, container, null, null, false);
    }

    public InputStream streamNamespacedPodLog(String namespace, String name, String container, Integer sinceSeconds, Integer tailLines, boolean timestamps) throws ApiException, IOException {
        Call call = this.coreClient.readNamespacedPodLogCall(name, namespace, container, Boolean.valueOf(true), null, "false", Boolean.valueOf(false), sinceSeconds, tailLines, Boolean.valueOf(timestamps), null, null);
        Response response = call.execute();
        if (!response.isSuccessful()) {
            throw new ApiException("Logs request failed: " + response.code());
        }
        return response.body().byteStream();
    }
}

