/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import io.kubernetes.client.Exec;
import io.kubernetes.client.TreeNode;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.util.Streams;
import io.kubernetes.client.util.exception.CopyNotSupportedException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Copy
extends Exec {
    private static final Logger log = LoggerFactory.getLogger(Copy.class);

    public Copy() {
        super(Configuration.getDefaultApiClient());
    }

    public Copy(ApiClient apiClient) {
        super(apiClient);
    }

    public InputStream copyFileFromPod(String namespace, String pod, String srcPath) throws ApiException, IOException {
        return this.copyFileFromPod(namespace, pod, null, srcPath);
    }

    public InputStream copyFileFromPod(V1Pod pod, String srcPath) throws ApiException, IOException {
        return this.copyFileFromPod(pod, null, srcPath);
    }

    public InputStream copyFileFromPod(V1Pod pod, String container, String srcPath) throws ApiException, IOException {
        return this.copyFileFromPod(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), container, srcPath);
    }

    public InputStream copyFileFromPod(String namespace, String pod, String container, String srcPath) throws ApiException, IOException {
        Process proc = this.exec(namespace, pod, new String[]{"sh", "-c", "cat " + srcPath + " | base64"}, container, false, false);
        return new Base64InputStream(proc.getInputStream());
    }

    public void copyFileFromPod(String namespace, String name, String container, String srcPath, Path destination) throws ApiException, IOException {
        try (InputStream is = this.copyFileFromPod(namespace, name, container, srcPath);
             FileOutputStream fos = new FileOutputStream(destination.toFile());){
            Streams.copy(is, fos);
            fos.flush();
        }
    }

    public void copyDirectoryFromPod(V1Pod pod, String srcPath, Path destination) throws ApiException, IOException, CopyNotSupportedException {
        this.copyDirectoryFromPod(pod, null, srcPath, destination);
    }

    public void copyDirectoryFromPod(V1Pod pod, String container, String srcPath, Path destination) throws ApiException, IOException, CopyNotSupportedException {
        this.copyDirectoryFromPod(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), container, srcPath, destination);
    }

    public void copyDirectoryFromPod(String namespace, String pod, String srcPath, Path destination) throws ApiException, IOException, CopyNotSupportedException {
        this.copyDirectoryFromPod(namespace, pod, null, srcPath, destination);
    }

    public void copyDirectoryFromPod(String namespace, String pod, String container, String srcPath, Path destination) throws ApiException, IOException, CopyNotSupportedException {
        if (!this.isTarPresentInContainer(namespace, pod, container)) {
            throw new CopyNotSupportedException("Tar is not present in the target container");
        }
        this.copyDirectoryFromPod(namespace, pod, container, srcPath, destination, true);
    }

    public void copyDirectoryFromPod(String namespace, String pod, String container, String srcPath, Path destination, boolean enableTarCompressing) throws IOException, ApiException {
        if (!enableTarCompressing) {
            TreeNode tree = new TreeNode(true, srcPath, true);
            this.createDirectoryTree(tree, namespace, pod, container, srcPath);
            this.createDirectoryStructureFromTree(tree, namespace, pod, container, srcPath, destination);
            return;
        }
        Future<Integer> future = this.copyDirectoryFromPodAsync(namespace, pod, container, srcPath, destination);
        try {
            int code = future.get();
            if (code != 0) {
                throw new IOException("Copy failed (" + code + ")");
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IOException(ex);
        }
    }

    public Future<Integer> copyDirectoryFromPodAsync(String namespace, String pod, String container, String srcPath, Path destination) throws IOException, ApiException {
        Process proc = this.exec(namespace, pod, new String[]{"sh", "-c", "tar cz - " + srcPath + " | base64"}, container, false, false);
        try (Base64InputStream is = new Base64InputStream((InputStream)new BufferedInputStream(proc.getInputStream()));
             TarArchiveInputStream archive = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)is));){
            ArchiveEntry entry = archive.getNextEntry();
            while (entry != null) {
                if (!archive.canReadEntryData(entry)) {
                    log.error("Can't read: " + entry);
                } else {
                    String normalName = FilenameUtils.normalize((String)entry.getName());
                    if (normalName == null) {
                        throw new IOException("Invalid entry: " + entry.getName());
                    }
                    File f = new File(destination.toFile(), normalName);
                    if (entry.isDirectory()) {
                        if (!f.isDirectory() && !f.mkdirs()) {
                            throw new IOException("create directory failed: " + f);
                        }
                    } else {
                        File parent = f.getParentFile();
                        if (!parent.isDirectory() && !parent.mkdirs()) {
                            throw new IOException("create directory failed: " + parent);
                        }
                        try (FileOutputStream fs = new FileOutputStream(f);){
                            Streams.copy((InputStream)archive, fs);
                            fs.flush();
                        }
                    }
                }
                entry = archive.getNextEntry();
            }
        }
        return new ProcessFuture(proc);
    }

    private void createDirectoryStructureFromTree(TreeNode tree, String namespace, String pod, String container, String srcPath, Path destination) throws IOException, ApiException {
        this.createDirectory(tree, destination);
        this.createFiles(tree, namespace, pod, container, srcPath, destination);
    }

    private void createFiles(TreeNode node, String namespace, String pod, String container, String srcPath, Path destination) throws IOException, ApiException {
        if (node == null) {
            return;
        }
        for (TreeNode childNode : node.getChildren()) {
            if (!childNode.isDir) {
                String filePath = this.genericPathBuilder(destination.toString(), childNode.name);
                File f = new File(filePath);
                if (!f.createNewFile()) {
                    throw new IOException("Failed to create file: " + f);
                }
                String modifiedSrcPath = this.genericPathBuilder(srcPath, childNode.name);
                InputStream is = this.copyFileFromPod(namespace, pod, modifiedSrcPath);
                Throwable throwable = null;
                try {
                    FileOutputStream fs = new FileOutputStream(f);
                    Throwable throwable2 = null;
                    try {
                        Streams.copy(is, fs);
                        fs.flush();
                        continue;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (fs == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)fs).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((OutputStream)fs).close();
                        continue;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    is.close();
                    continue;
                }
            }
            String newSrcPath = this.genericPathBuilder(srcPath, childNode.name);
            Path newDestination = Paths.get(destination.toString(), childNode.name);
            this.createFiles(childNode, namespace, pod, container, newSrcPath, newDestination);
        }
    }

    private void createDirectory(TreeNode node, Path destination) throws IOException {
        File f;
        if (node == null) {
            return;
        }
        if (!node.isRoot && !(f = new File(destination.toString())).mkdirs()) {
            throw new IOException("Failed to create directory: " + f);
        }
        for (TreeNode childNode : node.getChildren()) {
            if (!childNode.isDir) continue;
            String path = this.genericPathBuilder(destination.toString(), childNode.name);
            Path newPath = Paths.get(path, new String[0]);
            this.createDirectory(childNode, newPath);
        }
    }

    private void createDirectoryTree(TreeNode node, String namespace, String pod, String container, String srcPath) throws IOException, ApiException {
        if (node.isDir) {
            Process proc = this.exec(namespace, pod, new String[]{"sh", "-c", "ls -F " + srcPath}, container, false, false);
            try (InputStream is = proc.getInputStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line = "";
                while ((line = reader.readLine()) != null) {
                    int len = line.length();
                    if (line.charAt(line.length() - 1) == '/') {
                        TreeNode subDirTree = new TreeNode(true, line.substring(0, len - 1), false);
                        String path = this.genericPathBuilder(srcPath, subDirTree.name);
                        this.createDirectoryTree(subDirTree, namespace, pod, container, path);
                        node.getChildren().add(subDirTree);
                        continue;
                    }
                    node.getChildren().add(new TreeNode(false, line, false));
                }
            }
        }
    }

    private String genericPathBuilder(String first, String second) {
        StringBuilder pathBuilder = new StringBuilder(first);
        pathBuilder.append(File.separator);
        pathBuilder.append(second);
        return pathBuilder.toString();
    }

    public static void copyFileFromPod(String namespace, String pod, String srcPath, Path dest) throws ApiException, IOException {
        Copy c = new Copy();
        try (InputStream is = c.copyFileFromPod(namespace, pod, null, srcPath);
             FileOutputStream os = new FileOutputStream(dest.toFile());){
            Streams.copy(is, os);
            os.flush();
        }
    }

    public void copyFileToPod(String namespace, String pod, String container, Path srcPath, Path destPath) throws ApiException, IOException {
        try {
            int exit = this.copyFileToPodAsync(namespace, pod, container, srcPath, destPath).get();
            if (exit != 0) {
                throw new IOException("Failed to copy: " + exit);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    public Future<Integer> copyFileToPodAsync(String namespace, String pod, String container, Path srcPath, Path destPath) throws ApiException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void copyFileToPod(String namespace, String pod, String container, byte[] src, Path destPath) throws ApiException, IOException {
        try {
            int exit = this.copyFileToPodAsync(namespace, pod, container, src, destPath).get();
            if (exit != 0) {
                throw new IOException("Copy failed: " + exit);
            }
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IOException(ex);
        }
    }

    public Future<Integer> copyFileToPodAsync(String namespace, String pod, String container, byte[] src, Path destPath) throws ApiException, IOException {
        Process proc = this.execCopyToPod(namespace, pod, container, destPath);
        try (TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream((OutputStream)new Base64OutputStream(proc.getOutputStream(), true, 0, null));){
            TarArchiveEntry tarEntry = new TarArchiveEntry(new File(destPath.getFileName().toString()));
            tarEntry.setSize((long)src.length);
            archiveOutputStream.putArchiveEntry((ArchiveEntry)tarEntry);
            Streams.copy(new ByteArrayInputStream(src), (OutputStream)archiveOutputStream);
            archiveOutputStream.closeArchiveEntry();
            ProcessFuture processFuture = new ProcessFuture(proc);
            return processFuture;
        }
    }

    private Process execCopyToPod(String namespace, String pod, String container, Path destPath) throws ApiException, IOException {
        String parentPath = destPath.getParent() != null ? destPath.getParent().toString() : ".";
        return this.exec(namespace, pod, new String[]{"sh", "-c", "base64 -d | tar -xmf - -C " + parentPath}, container, true, false);
    }

    private boolean isTarPresentInContainer(String namespace, String pod, String container) throws ApiException, IOException {
        Process proc = this.exec(namespace, pod, new String[]{"sh", "-c", "tar --version"}, container, false, false);
        try {
            int status = proc.waitFor();
            boolean bl = status != 127;
            return bl;
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
        finally {
            proc.destroy();
        }
    }

    private static class ProcessFuture
    implements Future<Integer> {
        private Process proc;

        ProcessFuture(Process proc) {
            this.proc = proc;
        }

        @Override
        public boolean cancel(boolean interupt) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public Integer get() throws InterruptedException {
            this.proc.waitFor();
            this.proc.destroy();
            return this.proc.exitValue();
        }

        @Override
        public Integer get(long timeout, TimeUnit unit) throws InterruptedException {
            this.proc.waitFor(timeout, unit);
            this.proc.destroy();
            return this.proc.exitValue();
        }

        @Override
        public boolean isDone() {
            return this.proc.isAlive();
        }
    }
}

