/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.informer;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.informer.ListerWatcher;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.impl.DefaultSharedIndexInformer;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.util.CallGenerator;
import io.kubernetes.client.util.CallGeneratorParams;
import io.kubernetes.client.util.Watch;
import io.kubernetes.client.util.Watchable;
import io.kubernetes.client.util.generic.GenericKubernetesApi;
import io.kubernetes.client.util.generic.options.ListOptions;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import okhttp3.Call;
import org.apache.commons.collections4.MapUtils;

public class SharedInformerFactory {
    protected Map<Type, SharedIndexInformer> informers;
    private Map<Type, Future> startedInformers;
    private ExecutorService informerExecutor;
    private ApiClient apiClient;

    public SharedInformerFactory() {
        this(Configuration.getDefaultApiClient().setReadTimeout(0), Executors.newCachedThreadPool());
    }

    public SharedInformerFactory(ApiClient apiClient) {
        this(apiClient, Executors.newCachedThreadPool());
    }

    public SharedInformerFactory(ExecutorService threadPool) {
        this(Configuration.getDefaultApiClient().setReadTimeout(0), threadPool);
    }

    public SharedInformerFactory(ApiClient client, ExecutorService threadPool) {
        if (client.getReadTimeout() != 0) {
            throw new IllegalArgumentException("read timeout of ApiClient must be zero");
        }
        this.apiClient = client;
        this.informerExecutor = threadPool;
        this.informers = new HashMap<Type, SharedIndexInformer>();
        this.startedInformers = new HashMap<Type, Future>();
    }

    public synchronized <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> SharedIndexInformer<ApiType> sharedIndexInformerFor(CallGenerator callGenerator, Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass) {
        return this.sharedIndexInformerFor(callGenerator, apiTypeClass, apiListTypeClass, 0L);
    }

    public synchronized <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> SharedIndexInformer<ApiType> sharedIndexInformerFor(CallGenerator callGenerator, Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass, long resyncPeriodInMillis) {
        ListerWatcher<ApiType, ApiListType> listerWatcher = this.listerWatcherFor(callGenerator, apiTypeClass, apiListTypeClass);
        return this.sharedIndexInformerFor(listerWatcher, apiTypeClass, resyncPeriodInMillis);
    }

    public synchronized <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> SharedIndexInformer<ApiType> sharedIndexInformerFor(ListerWatcher<ApiType, ApiListType> listerWatcher, Class<ApiType> apiTypeClass, long resyncPeriodInMillis) {
        DefaultSharedIndexInformer<ApiType, ApiListType> informer = new DefaultSharedIndexInformer<ApiType, ApiListType>(apiTypeClass, listerWatcher, resyncPeriodInMillis);
        this.informers.putIfAbsent(TypeToken.get(apiTypeClass).getType(), informer);
        return informer;
    }

    public synchronized <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> SharedIndexInformer<ApiType> sharedIndexInformerFor(GenericKubernetesApi<ApiType, ApiListType> genericKubernetesApi, Class<ApiType> apiTypeClass, long resyncPeriodInMillis) {
        return this.sharedIndexInformerFor(genericKubernetesApi, apiTypeClass, resyncPeriodInMillis, "");
    }

    public synchronized <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> SharedIndexInformer<ApiType> sharedIndexInformerFor(GenericKubernetesApi<ApiType, ApiListType> genericKubernetesApi, Class<ApiType> apiTypeClass, long resyncPeriodInMillis, String namespace) {
        ListerWatcher<ApiType, ApiListType> listerWatcher = this.listerWatcherFor(genericKubernetesApi, namespace);
        return this.sharedIndexInformerFor(listerWatcher, apiTypeClass, resyncPeriodInMillis);
    }

    private <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> ListerWatcher<ApiType, ApiListType> listerWatcherFor(final CallGenerator callGenerator, final Class<ApiType> apiTypeClass, final Class<ApiListType> apiListTypeClass) {
        if (this.apiClient.getReadTimeout() > 0) {
            this.apiClient.setReadTimeout(0);
        }
        return new ListerWatcher<ApiType, ApiListType>(){

            @Override
            public ApiListType list(CallGeneratorParams params) throws ApiException {
                Call call = callGenerator.generate(params);
                return (KubernetesListObject)SharedInformerFactory.this.apiClient.execute(call, (Type)apiListTypeClass).getData();
            }

            @Override
            public Watch<ApiType> watch(CallGeneratorParams params) throws ApiException {
                Call call = callGenerator.generate(params);
                call = SharedInformerFactory.this.apiClient.getHttpClient().newCall(call.request());
                return Watch.createWatch(SharedInformerFactory.this.apiClient, call, TypeToken.getParameterized(Watch.Response.class, (Type[])new Type[]{apiTypeClass}).getType());
            }
        };
    }

    private <ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> ListerWatcher<ApiType, ApiListType> listerWatcherFor(final GenericKubernetesApi<ApiType, ApiListType> genericKubernetesApi, final String namespace) {
        if (this.apiClient.getReadTimeout() > 0) {
            this.apiClient.setReadTimeout(0);
        }
        return new ListerWatcher<ApiType, ApiListType>(){

            @Override
            public ApiListType list(final CallGeneratorParams params) throws ApiException {
                if ("".equals(namespace)) {
                    return (KubernetesListObject)genericKubernetesApi.list(new ListOptions(){
                        {
                            this.setResourceVersion(params.resourceVersion);
                            this.setTimeoutSeconds(params.timeoutSeconds);
                        }
                    }).throwsApiException().getObject();
                }
                return (KubernetesListObject)genericKubernetesApi.list(namespace, new ListOptions(){
                    {
                        this.setResourceVersion(params.resourceVersion);
                        this.setTimeoutSeconds(params.timeoutSeconds);
                    }
                }).throwsApiException().getObject();
            }

            @Override
            public Watchable<ApiType> watch(CallGeneratorParams params) throws ApiException {
                if ("".equals(namespace)) {
                    return genericKubernetesApi.watch();
                }
                return genericKubernetesApi.watch(namespace);
            }
        };
    }

    public synchronized <ApiType extends KubernetesObject> SharedIndexInformer<ApiType> getExistingSharedIndexInformer(Class<ApiType> apiTypeClass) {
        return this.informers.get(TypeToken.get(apiTypeClass).getType());
    }

    public synchronized void startAllRegisteredInformers() {
        if (MapUtils.isEmpty(this.informers)) {
            return;
        }
        this.informers.forEach((informerType, informer) -> this.startedInformers.computeIfAbsent((Type)informerType, key -> this.informerExecutor.submit(informer::run)));
    }

    public synchronized void stopAllRegisteredInformers() {
        this.stopAllRegisteredInformers(true);
    }

    public synchronized void stopAllRegisteredInformers(boolean shutdownThreadPool) {
        if (MapUtils.isEmpty(this.informers)) {
            return;
        }
        this.informers.forEach((informerType, informer) -> {
            if (this.startedInformers.remove(informerType) != null) {
                informer.stop();
            }
        });
        if (shutdownThreadPool) {
            this.informerExecutor.shutdown();
        }
    }
}

