/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.generic;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.common.KubernetesListObject;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.common.KubernetesType;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CustomObjectsApi;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.util.PatchUtils;
import io.kubernetes.client.util.Watch;
import io.kubernetes.client.util.Watchable;
import io.kubernetes.client.util.generic.KubernetesApiResponse;
import io.kubernetes.client.util.generic.options.CreateOptions;
import io.kubernetes.client.util.generic.options.DeleteOptions;
import io.kubernetes.client.util.generic.options.GetOptions;
import io.kubernetes.client.util.generic.options.ListOptions;
import io.kubernetes.client.util.generic.options.PatchOptions;
import io.kubernetes.client.util.generic.options.UpdateOptions;
import java.io.IOException;
import java.lang.reflect.Type;
import okhttp3.Call;
import okhttp3.HttpUrl;

public class GenericKubernetesApi<ApiType extends KubernetesObject, ApiListType extends KubernetesListObject> {
    private Class<ApiType> apiTypeClass;
    private Class<ApiListType> apiListTypeClass;
    private String apiGroup;
    private String apiVersion;
    private String resourcePlural;
    private CustomObjectsApi customObjectsApi;

    public GenericKubernetesApi(Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass, String apiGroup, String apiVersion, String resourcePlural) {
        this(apiTypeClass, apiListTypeClass, apiGroup, apiVersion, resourcePlural, new CustomObjectsApi(Configuration.getDefaultApiClient()));
    }

    public GenericKubernetesApi(Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass, String apiGroup, String apiVersion, String resourcePlural, ApiClient apiClient) {
        this(apiTypeClass, apiListTypeClass, apiGroup, apiVersion, resourcePlural, new CustomObjectsApi(apiClient));
    }

    public GenericKubernetesApi(Class<ApiType> apiTypeClass, Class<ApiListType> apiListTypeClass, String apiGroup, String apiVersion, String resourcePlural, CustomObjectsApi customObjectsApi) {
        this.apiGroup = apiGroup;
        this.apiVersion = apiVersion;
        this.resourcePlural = resourcePlural;
        this.apiTypeClass = apiTypeClass;
        this.apiListTypeClass = apiListTypeClass;
        this.customObjectsApi = customObjectsApi;
    }

    public KubernetesApiResponse<ApiType> get(String name) {
        return this.get(name, new GetOptions());
    }

    public KubernetesApiResponse<ApiType> get(String namespace, String name) {
        return this.get(namespace, name, new GetOptions());
    }

    public KubernetesApiResponse<ApiListType> list() {
        return this.list(new ListOptions());
    }

    public KubernetesApiResponse<ApiListType> list(String namespace) {
        return this.list(namespace, new ListOptions());
    }

    public KubernetesApiResponse<ApiType> create(ApiType object) {
        return this.create(object, new CreateOptions());
    }

    public KubernetesApiResponse<ApiType> update(ApiType object) {
        return this.update(object, new UpdateOptions());
    }

    public KubernetesApiResponse<ApiType> patch(String name, String patchType, V1Patch patch) {
        return this.patch(name, patchType, patch, new PatchOptions());
    }

    public KubernetesApiResponse<ApiType> patch(String namespace, String name, String patchType, V1Patch patch) {
        return this.patch(namespace, name, patchType, patch, new PatchOptions());
    }

    public KubernetesApiResponse<ApiType> delete(String name) {
        return this.delete(name, new DeleteOptions());
    }

    public KubernetesApiResponse<ApiType> delete(String namespace, String name) {
        return this.delete(namespace, name, new DeleteOptions());
    }

    public Watchable<ApiType> watch() throws ApiException {
        return this.watch(new ListOptions());
    }

    public Watchable<ApiType> watch(String namespace) throws ApiException {
        return this.watch(namespace, new ListOptions());
    }

    public KubernetesApiResponse<ApiType> get(String name, GetOptions getOptions) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, () -> this.customObjectsApi.getClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, name, null));
    }

    public KubernetesApiResponse<ApiType> get(String namespace, String name, GetOptions getOptions) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("invalid name");
        }
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, () -> this.customObjectsApi.getNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, name, null));
    }

    public KubernetesApiResponse<ApiListType> list(ListOptions listOptions) {
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiListTypeClass, () -> this.customObjectsApi.listClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, null, listOptions.getContinue(), listOptions.getFieldSelector(), listOptions.getLabelSelector(), listOptions.getLimit(), listOptions.getResourceVersion(), listOptions.getTimeoutSeconds(), Boolean.valueOf(false), null));
    }

    public KubernetesApiResponse<ApiListType> list(String namespace, ListOptions listOptions) {
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiListTypeClass, () -> this.customObjectsApi.listNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, null, listOptions.getContinue(), listOptions.getFieldSelector(), listOptions.getLabelSelector(), listOptions.getLimit(), listOptions.getResourceVersion(), listOptions.getTimeoutSeconds(), null, null));
    }

    public KubernetesApiResponse<ApiType> create(ApiType object, CreateOptions createOptions) {
        boolean isNamespaced;
        V1ObjectMeta objectMeta = object.getMetadata();
        boolean bl = isNamespaced = !Strings.isNullOrEmpty((String)objectMeta.getNamespace());
        if (isNamespaced) {
            return this.create(objectMeta.getNamespace(), object, createOptions);
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, () -> this.customObjectsApi.createClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, (Object)object, null, createOptions.getDryRun(), createOptions.getFieldManager(), null));
    }

    public KubernetesApiResponse<ApiType> create(String namespace, ApiType object, CreateOptions createOptions) {
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, () -> this.customObjectsApi.createNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, (Object)object, null, createOptions.getDryRun(), createOptions.getFieldManager(), null));
    }

    public KubernetesApiResponse<ApiType> update(ApiType object, UpdateOptions updateOptions) {
        V1ObjectMeta objectMeta = object.getMetadata();
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, () -> {
            boolean isNamespaced;
            boolean bl = isNamespaced = !Strings.isNullOrEmpty((String)objectMeta.getNamespace());
            if (isNamespaced) {
                return this.customObjectsApi.replaceNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, objectMeta.getNamespace(), this.resourcePlural, objectMeta.getName(), (Object)object, updateOptions.getDryRun(), updateOptions.getFieldManager(), null);
            }
            return this.customObjectsApi.replaceClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, objectMeta.getName(), (Object)object, updateOptions.getDryRun(), updateOptions.getFieldManager(), null);
        });
    }

    public KubernetesApiResponse<ApiType> patch(String name, String patchType, V1Patch patch, PatchOptions patchOptions) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("invalid name");
        }
        try {
            KubernetesObject object = (KubernetesObject)PatchUtils.patch(this.apiTypeClass, () -> {
                Call call = this.customObjectsApi.patchClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, name, (Object)patch, patchOptions.getDryRun(), patchOptions.getFieldManager(), patchOptions.getForce(), null);
                return this.tweakCallForCoreV1Group(call);
            }, patchType, this.customObjectsApi.getApiClient());
            return new KubernetesApiResponse<KubernetesObject>(object);
        }
        catch (ApiException e) {
            V1Status status = (V1Status)this.customObjectsApi.getApiClient().getJSON().deserialize(e.getResponseBody(), V1Status.class);
            return new KubernetesApiResponse(status, e.getCode());
        }
    }

    public KubernetesApiResponse<ApiType> patch(String namespace, String name, String patchType, V1Patch patch, PatchOptions patchOptions) {
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("invalid name");
        }
        try {
            KubernetesObject object = (KubernetesObject)PatchUtils.patch(this.apiTypeClass, () -> {
                Call call = this.customObjectsApi.patchNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, name, (Object)patch, patchOptions.getDryRun(), patchOptions.getFieldManager(), patchOptions.getForce(), null);
                return this.tweakCallForCoreV1Group(call);
            }, patchType, this.customObjectsApi.getApiClient());
            return new KubernetesApiResponse<KubernetesObject>(object);
        }
        catch (ApiException e) {
            V1Status status = (V1Status)this.customObjectsApi.getApiClient().getJSON().deserialize(e.getResponseBody(), V1Status.class);
            return new KubernetesApiResponse(status, e.getCode());
        }
    }

    public KubernetesApiResponse<ApiType> delete(String name, DeleteOptions deleteOptions) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, () -> this.customObjectsApi.deleteClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, name, null, null, null, null, (V1DeleteOptions)deleteOptions, null));
    }

    public KubernetesApiResponse<ApiType> delete(String namespace, String name, DeleteOptions deleteOptions) {
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        if (Strings.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("invalid name");
        }
        return this.executeCall(this.customObjectsApi.getApiClient(), this.apiTypeClass, () -> this.customObjectsApi.deleteNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, name, null, null, null, null, (V1DeleteOptions)deleteOptions, null));
    }

    public Watchable<ApiType> watch(ListOptions listOptions) throws ApiException {
        Call call = this.customObjectsApi.listClusterCustomObjectCall(this.apiGroup, this.apiVersion, this.resourcePlural, null, listOptions.getContinue(), listOptions.getFieldSelector(), listOptions.getLabelSelector(), listOptions.getLimit(), listOptions.getResourceVersion(), listOptions.getTimeoutSeconds(), Boolean.valueOf(true), null);
        call = this.tweakCallForCoreV1Group(call);
        return Watch.createWatch(this.customObjectsApi.getApiClient(), call, TypeToken.getParameterized(Watch.Response.class, (Type[])new Type[]{this.apiTypeClass}).getType());
    }

    public Watchable<ApiType> watch(String namespace, ListOptions listOptions) throws ApiException {
        if (Strings.isNullOrEmpty((String)namespace)) {
            throw new IllegalArgumentException("invalid namespace");
        }
        Call call = this.customObjectsApi.listNamespacedCustomObjectCall(this.apiGroup, this.apiVersion, namespace, this.resourcePlural, null, listOptions.getContinue(), listOptions.getFieldSelector(), listOptions.getLabelSelector(), listOptions.getLimit(), listOptions.getResourceVersion(), listOptions.getTimeoutSeconds(), Boolean.valueOf(true), null);
        return Watch.createWatch(this.customObjectsApi.getApiClient(), call, TypeToken.getParameterized(Watch.Response.class, (Type[])new Type[]{this.apiTypeClass}).getType());
    }

    private static <DataType extends KubernetesType> KubernetesApiResponse<DataType> getKubernetesApiResponse(Class<DataType> dataClass, JsonElement element, Gson gson) {
        return GenericKubernetesApi.getKubernetesApiResponse(dataClass, element, gson, 200);
    }

    private static <DataType extends KubernetesType> KubernetesApiResponse<DataType> getKubernetesApiResponse(Class<DataType> dataClass, JsonElement element, Gson gson, int httpStatusCode) {
        boolean isStatus;
        JsonElement kindElement = element.getAsJsonObject().get("kind");
        boolean bl = isStatus = kindElement != null && "Status".equals(kindElement.getAsString());
        if (isStatus) {
            return new KubernetesApiResponse((V1Status)gson.fromJson(element, V1Status.class), httpStatusCode);
        }
        return new KubernetesApiResponse<KubernetesType>((KubernetesType)gson.fromJson(element, dataClass));
    }

    private <DataType extends KubernetesType> KubernetesApiResponse<DataType> executeCall(ApiClient apiClient, Class<DataType> dataClass, CallBuilder callBuilder) {
        try {
            Call call = callBuilder.build();
            call = this.tweakCallForCoreV1Group(call);
            JsonElement element = (JsonElement)apiClient.execute(call, JsonElement.class).getData();
            return GenericKubernetesApi.getKubernetesApiResponse(dataClass, element, apiClient.getJSON().getGson());
        }
        catch (ApiException e) {
            V1Status status;
            if (e.getCause() instanceof IOException) {
                throw new IllegalStateException(e.getCause());
            }
            try {
                status = (V1Status)apiClient.getJSON().deserialize(e.getResponseBody(), V1Status.class);
            }
            catch (JsonSyntaxException jsonEx) {
                throw new RuntimeException(jsonEx);
            }
            if (null == status) {
                throw new RuntimeException(e);
            }
            return new KubernetesApiResponse(status, e.getCode());
        }
    }

    private Call tweakCallForCoreV1Group(Call call) {
        if (!this.apiGroup.equals("")) {
            return call;
        }
        HttpUrl url = call.request().url();
        HttpUrl tweakedUrl = url.newBuilder().removePathSegment(1).setPathSegment(0, "api").build();
        return this.customObjectsApi.getApiClient().getHttpClient().newCall(call.request().newBuilder().url(tweakedUrl).build());
    }

    private static interface CallBuilder {
        public Call build() throws ApiException;
    }
}

