/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okio.Buffer;
import org.apache.log4j.Logger;

public class WebSockets {
    public static final String V4_STREAM_PROTOCOL = "v4.channel.k8s.io";
    public static final String V3_STREAM_PROTOCOL = "v3.channel.k8s.io";
    public static final String V2_STREAM_PROTOCOL = "v2.channel.k8s.io";
    public static final String V1_STREAM_PROTOCOL = "channel.k8s.io";
    public static final String STREAM_PROTOCOL_HEADER = "X-Stream-Protocol-Version";
    public static final String SPDY_3_1 = "SPDY/3.1";
    private static final Logger log = Logger.getLogger(WebSockets.class);

    public static void stream(String path, String method, ApiClient client, SocketListener listener) throws ApiException, IOException {
        WebSockets.stream(path, method, new ArrayList<Pair>(), client, listener);
    }

    public static void stream(String path, String method, List<Pair> queryParams, ApiClient client, SocketListener listener) throws ApiException, IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String allProtocols = String.format("%s,%s,%s,%s", V4_STREAM_PROTOCOL, V3_STREAM_PROTOCOL, V2_STREAM_PROTOCOL, V1_STREAM_PROTOCOL);
        headers.put(STREAM_PROTOCOL_HEADER, allProtocols);
        headers.put("Connection", "Upgrade");
        headers.put("Upgrade", SPDY_3_1);
        Request request = client.buildRequest(path, method, queryParams, new ArrayList(), null, headers, new HashMap(), new String[0], null);
        WebSockets.streamRequest(request, client, listener);
    }

    private static void streamRequest(Request request, ApiClient client, SocketListener listener) {
        WebSocketCall.create((OkHttpClient)client.getHttpClient(), (Request)request).enqueue((WebSocketListener)new Listener(listener));
    }

    public static class Listener
    implements WebSocketListener {
        private SocketListener listener;

        public Listener(SocketListener listener) {
            this.listener = listener;
        }

        public void onOpen(WebSocket webSocket, Response response) {
            String protocol = response.header(WebSockets.STREAM_PROTOCOL_HEADER, "missing");
            this.listener.open(protocol, webSocket);
        }

        public void onMessage(ResponseBody body) throws IOException {
            if (body.contentType() == WebSocket.TEXT) {
                this.listener.textMessage(body.charStream());
            } else if (body.contentType() == WebSocket.BINARY) {
                this.listener.bytesMessage(body.byteStream());
            }
            body.close();
        }

        public void onPong(Buffer payload) {
        }

        public void onClose(int code, String reason) {
            this.listener.close();
        }

        public void onFailure(IOException e, Response res) {
            e.printStackTrace();
            this.listener.close();
        }
    }

    public static interface SocketListener {
        public void open(String var1, WebSocket var2);

        public void bytesMessage(InputStream var1);

        public void textMessage(Reader var1);

        public void close();
    }
}

