/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.ws.WebSocket;
import io.kubernetes.client.util.WebSockets;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import okio.ByteString;
import org.apache.log4j.Logger;

public class WebSocketStreamHandler
implements WebSockets.SocketListener {
    Map<Integer, PipedOutputStream> output = new HashMap<Integer, PipedOutputStream>();
    Map<Integer, PipedInputStream> input = new HashMap<Integer, PipedInputStream>();
    WebSocket socket;
    String protocol;
    private static final Logger log = Logger.getLogger(WebSockets.class);

    @Override
    public void open(String protocol, WebSocket socket) {
        this.protocol = protocol;
        this.socket = socket;
    }

    @Override
    public void bytesMessage(InputStream in) {
        try {
            OutputStream out = this.getSocketInputOutputStream(in.read());
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            log.error((Object)"Error writing message", (Throwable)ex);
        }
    }

    @Override
    public void textMessage(Reader in) {
        try {
            OutputStream out = this.getSocketInputOutputStream(in.read());
            ByteArrayInputStream inStream = new ByteArrayInputStream(CharStreams.toString((Readable)in).getBytes(Charsets.UTF_8));
            ByteStreams.copy((InputStream)inStream, (OutputStream)out);
        }
        catch (IOException ex) {
            log.error((Object)"Error writing message", (Throwable)ex);
        }
    }

    @Override
    public void close() {
        for (PipedOutputStream out : this.output.values()) {
            try {
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        for (PipedInputStream in : this.input.values()) {
            try {
                in.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public synchronized InputStream getInputStream(int stream) {
        if (!this.input.containsKey(stream)) {
            try {
                PipedInputStream pipeIn = new PipedInputStream();
                PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
                this.output.put(stream, pipeOut);
                this.input.put(stream, pipeIn);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.input.get(stream);
    }

    public OutputStream getOutputStream(int stream) {
        return new WebSocketOutputStream(stream);
    }

    private synchronized OutputStream getSocketInputOutputStream(int stream) {
        if (!this.output.containsKey(stream)) {
            try {
                PipedInputStream pipeIn = new PipedInputStream();
                PipedOutputStream pipeOut = new PipedOutputStream(pipeIn);
                this.output.put(stream, pipeOut);
                this.input.put(stream, pipeIn);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.output.get(stream);
    }

    private class WebSocketOutputStream
    extends OutputStream {
        private byte stream;

        public WebSocketOutputStream(int stream) {
            this.stream = (byte)stream;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            if (WebSocketStreamHandler.this.socket == null) {
                throw new IOException("No websocket connection!");
            }
            byte[] buffer = new byte[length + 1];
            buffer[0] = this.stream;
            System.arraycopy(b, offset, buffer, 1, length);
            WebSocketStreamHandler.this.socket.sendMessage(RequestBody.create((MediaType)WebSocket.BINARY, (ByteString)ByteString.of((byte[])buffer)));
        }
    }
}

