/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import com.google.gson.annotations.SerializedName;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.ResponseBody;
import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.JSON;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Iterator;

public class Watch<T>
implements Iterable<Response<T>>,
Iterator<Response<T>> {
    Type watchType;
    ResponseBody response;
    JSON json;

    public static <T> Watch<T> createWatch(ApiClient client, Call call, Type watchType) throws ApiException {
        try {
            com.squareup.okhttp.Response response = call.execute();
            if (!response.isSuccessful()) {
                String respBody = null;
                if (response.body() != null) {
                    try {
                        respBody = response.body().string();
                    }
                    catch (IOException e) {
                        throw new ApiException(response.message(), (Throwable)e, response.code(), response.headers().toMultimap());
                    }
                }
                throw new ApiException(response.message(), response.code(), response.headers().toMultimap(), respBody);
            }
            return new Watch<T>(client.getJSON(), response.body(), watchType);
        }
        catch (IOException e) {
            throw new ApiException((Throwable)e);
        }
    }

    private Watch(JSON json, ResponseBody body, Type watchType) {
        this.response = body;
        this.watchType = watchType;
        this.json = json;
    }

    @Override
    public Response<T> next() {
        try {
            String line = this.response.source().readUtf8Line();
            if (line == null) {
                throw new RuntimeException("Null response from the server.");
            }
            return (Response)this.json.deserialize(line, this.watchType);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception during next method.", e);
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return !this.response.source().exhausted();
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception during hasNext method.", e);
        }
    }

    @Override
    public Iterator<Response<T>> iterator() {
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public static class Response<T> {
        @SerializedName(value="type")
        public String type;
        @SerializedName(value="object")
        public T object;

        Response(String type, T object) {
            this.type = type;
            this.object = object;
        }
    }
}

