/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.controller;

import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.ControllerManager;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.spring.extended.controller.annotation.KubernetesReconciler;
import io.kubernetes.client.spring.extended.controller.factory.KubernetesControllerFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

public class KubernetesReconcilerProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(KubernetesReconcilerProcessor.class);
    private ControllerManager controllerManager;
    private ExecutorService controllerManagerDaemon = Executors.newSingleThreadExecutor();
    private SharedInformerFactory sharedInformerFactory;

    public KubernetesReconcilerProcessor(SharedInformerFactory sharedInformerFactory) {
        this.sharedInformerFactory = sharedInformerFactory;
    }

    public int getOrder() {
        return 1;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] names;
        for (String name : names = beanFactory.getBeanNamesForType(Reconciler.class)) {
            Reconciler reconciler = (Reconciler)beanFactory.getBean(name);
            KubernetesReconciler kubernetesReconciler = reconciler.getClass().getAnnotation(KubernetesReconciler.class);
            String reconcilerName = kubernetesReconciler.value();
            KubernetesControllerFactory controllerFactory = new KubernetesControllerFactory(this.sharedInformerFactory, reconciler);
            Controller controller = controllerFactory.getObject();
            beanFactory.registerSingleton(reconcilerName, (Object)controller);
        }
    }
}

