/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1PodTemplateSpec;
import io.kubernetes.client.models.V1beta1DaemonSetUpdateStrategy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="DaemonSetSpec is the specification of a daemon set.")
public class V1beta1DaemonSetSpec {
    @SerializedName(value="minReadySeconds")
    private Integer minReadySeconds = null;
    @SerializedName(value="revisionHistoryLimit")
    private Integer revisionHistoryLimit = null;
    @SerializedName(value="selector")
    private V1LabelSelector selector = null;
    @SerializedName(value="template")
    private V1PodTemplateSpec template = null;
    @SerializedName(value="templateGeneration")
    private Long templateGeneration = null;
    @SerializedName(value="updateStrategy")
    private V1beta1DaemonSetUpdateStrategy updateStrategy = null;

    public V1beta1DaemonSetSpec minReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
        return this;
    }

    @ApiModelProperty(value="The minimum number of seconds for which a newly created DaemonSet pod should be ready without any of its container crashing, for it to be considered available. Defaults to 0 (pod will be considered available as soon as it is ready).")
    public Integer getMinReadySeconds() {
        return this.minReadySeconds;
    }

    public void setMinReadySeconds(Integer minReadySeconds) {
        this.minReadySeconds = minReadySeconds;
    }

    public V1beta1DaemonSetSpec revisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
        return this;
    }

    @ApiModelProperty(value="The number of old history to retain to allow rollback. This is a pointer to distinguish between explicit zero and not specified. Defaults to 10.")
    public Integer getRevisionHistoryLimit() {
        return this.revisionHistoryLimit;
    }

    public void setRevisionHistoryLimit(Integer revisionHistoryLimit) {
        this.revisionHistoryLimit = revisionHistoryLimit;
    }

    public V1beta1DaemonSetSpec selector(V1LabelSelector selector) {
        this.selector = selector;
        return this;
    }

    @ApiModelProperty(value="A label query over pods that are managed by the daemon set. Must match in order to be controlled. If empty, defaulted to labels on Pod template. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors")
    public V1LabelSelector getSelector() {
        return this.selector;
    }

    public void setSelector(V1LabelSelector selector) {
        this.selector = selector;
    }

    public V1beta1DaemonSetSpec template(V1PodTemplateSpec template) {
        this.template = template;
        return this;
    }

    @ApiModelProperty(required=true, value="An object that describes the pod that will be created. The DaemonSet will create exactly one copy of this pod on every node that matches the template's node selector (or on every node if no node selector is specified). More info: https://kubernetes.io/docs/concepts/workloads/controllers/replicationcontroller#pod-template")
    public V1PodTemplateSpec getTemplate() {
        return this.template;
    }

    public void setTemplate(V1PodTemplateSpec template) {
        this.template = template;
    }

    public V1beta1DaemonSetSpec templateGeneration(Long templateGeneration) {
        this.templateGeneration = templateGeneration;
        return this;
    }

    @ApiModelProperty(value="DEPRECATED. A sequence number representing a specific generation of the template. Populated by the system. It can be set only during the creation.")
    public Long getTemplateGeneration() {
        return this.templateGeneration;
    }

    public void setTemplateGeneration(Long templateGeneration) {
        this.templateGeneration = templateGeneration;
    }

    public V1beta1DaemonSetSpec updateStrategy(V1beta1DaemonSetUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
        return this;
    }

    @ApiModelProperty(value="An update strategy to replace existing DaemonSet pods with new pods.")
    public V1beta1DaemonSetUpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void setUpdateStrategy(V1beta1DaemonSetUpdateStrategy updateStrategy) {
        this.updateStrategy = updateStrategy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DaemonSetSpec v1beta1DaemonSetSpec = (V1beta1DaemonSetSpec)o;
        return Objects.equals(this.minReadySeconds, v1beta1DaemonSetSpec.minReadySeconds) && Objects.equals(this.revisionHistoryLimit, v1beta1DaemonSetSpec.revisionHistoryLimit) && Objects.equals(this.selector, v1beta1DaemonSetSpec.selector) && Objects.equals(this.template, v1beta1DaemonSetSpec.template) && Objects.equals(this.templateGeneration, v1beta1DaemonSetSpec.templateGeneration) && Objects.equals(this.updateStrategy, v1beta1DaemonSetSpec.updateStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.minReadySeconds, this.revisionHistoryLimit, this.selector, this.template, this.templateGeneration, this.updateStrategy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DaemonSetSpec {\n");
        sb.append("    minReadySeconds: ").append(this.toIndentedString(this.minReadySeconds)).append("\n");
        sb.append("    revisionHistoryLimit: ").append(this.toIndentedString(this.revisionHistoryLimit)).append("\n");
        sb.append("    selector: ").append(this.toIndentedString(this.selector)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    templateGeneration: ").append(this.toIndentedString(this.templateGeneration)).append("\n");
        sb.append("    updateStrategy: ").append(this.toIndentedString(this.updateStrategy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

