/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1Capabilities;
import io.kubernetes.client.models.V1CapabilitiesBuilder;
import io.kubernetes.client.models.V1CapabilitiesFluentImpl;
import io.kubernetes.client.models.V1SELinuxOptions;
import io.kubernetes.client.models.V1SELinuxOptionsBuilder;
import io.kubernetes.client.models.V1SELinuxOptionsFluentImpl;
import io.kubernetes.client.models.V1SecurityContext;
import io.kubernetes.client.models.V1SecurityContextFluent;

public class V1SecurityContextFluentImpl<A extends V1SecurityContextFluent<A>>
extends BaseFluent<A>
implements V1SecurityContextFluent<A> {
    private Boolean allowPrivilegeEscalation;
    private V1CapabilitiesBuilder capabilities;
    private Boolean privileged;
    private String procMount;
    private Boolean readOnlyRootFilesystem;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private V1SELinuxOptionsBuilder seLinuxOptions;

    public V1SecurityContextFluentImpl() {
    }

    public V1SecurityContextFluentImpl(V1SecurityContext instance) {
        this.withAllowPrivilegeEscalation(instance.isAllowPrivilegeEscalation());
        this.withCapabilities(instance.getCapabilities());
        this.withPrivileged(instance.isPrivileged());
        this.withProcMount(instance.getProcMount());
        this.withReadOnlyRootFilesystem(instance.isReadOnlyRootFilesystem());
        this.withRunAsGroup(instance.getRunAsGroup());
        this.withRunAsNonRoot(instance.isRunAsNonRoot());
        this.withRunAsUser(instance.getRunAsUser());
        this.withSeLinuxOptions(instance.getSeLinuxOptions());
    }

    @Override
    public Boolean isAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation;
    }

    @Override
    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation) {
        this.allowPrivilegeEscalation = allowPrivilegeEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasAllowPrivilegeEscalation() {
        return this.allowPrivilegeEscalation != null;
    }

    @Override
    public A withNewAllowPrivilegeEscalation(String arg1) {
        return this.withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    @Override
    public A withNewAllowPrivilegeEscalation(boolean arg1) {
        return this.withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    @Override
    @Deprecated
    public V1Capabilities getCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    @Override
    public V1Capabilities buildCapabilities() {
        return this.capabilities != null ? this.capabilities.build() : null;
    }

    @Override
    public A withCapabilities(V1Capabilities capabilities) {
        this._visitables.get("capabilities").remove(this.capabilities);
        if (capabilities != null) {
            this.capabilities = new V1CapabilitiesBuilder(capabilities);
            this._visitables.get("capabilities").add(this.capabilities);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCapabilities() {
        return this.capabilities != null;
    }

    @Override
    public V1SecurityContextFluent.CapabilitiesNested<A> withNewCapabilities() {
        return new CapabilitiesNestedImpl();
    }

    @Override
    public V1SecurityContextFluent.CapabilitiesNested<A> withNewCapabilitiesLike(V1Capabilities item) {
        return new CapabilitiesNestedImpl(item);
    }

    @Override
    public V1SecurityContextFluent.CapabilitiesNested<A> editCapabilities() {
        return this.withNewCapabilitiesLike(this.getCapabilities());
    }

    @Override
    public V1SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilities() {
        return this.withNewCapabilitiesLike(this.getCapabilities() != null ? this.getCapabilities() : new V1CapabilitiesBuilder().build());
    }

    @Override
    public V1SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilitiesLike(V1Capabilities item) {
        return this.withNewCapabilitiesLike(this.getCapabilities() != null ? this.getCapabilities() : item);
    }

    @Override
    public Boolean isPrivileged() {
        return this.privileged;
    }

    @Override
    public A withPrivileged(Boolean privileged) {
        this.privileged = privileged;
        return (A)this;
    }

    @Override
    public Boolean hasPrivileged() {
        return this.privileged != null;
    }

    @Override
    public A withNewPrivileged(String arg1) {
        return this.withPrivileged(new Boolean(arg1));
    }

    @Override
    public A withNewPrivileged(boolean arg1) {
        return this.withPrivileged(new Boolean(arg1));
    }

    @Override
    public String getProcMount() {
        return this.procMount;
    }

    @Override
    public A withProcMount(String procMount) {
        this.procMount = procMount;
        return (A)this;
    }

    @Override
    public Boolean hasProcMount() {
        return this.procMount != null;
    }

    @Override
    public A withNewProcMount(String arg1) {
        return this.withProcMount(new String(arg1));
    }

    @Override
    public A withNewProcMount(StringBuilder arg1) {
        return this.withProcMount(new String(arg1));
    }

    @Override
    public A withNewProcMount(StringBuffer arg1) {
        return this.withProcMount(new String(arg1));
    }

    @Override
    public Boolean isReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem;
    }

    @Override
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem) {
        this.readOnlyRootFilesystem = readOnlyRootFilesystem;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnlyRootFilesystem() {
        return this.readOnlyRootFilesystem != null;
    }

    @Override
    public A withNewReadOnlyRootFilesystem(String arg1) {
        return this.withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    @Override
    public A withNewReadOnlyRootFilesystem(boolean arg1) {
        return this.withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    @Override
    public Long getRunAsGroup() {
        return this.runAsGroup;
    }

    @Override
    public A withRunAsGroup(Long runAsGroup) {
        this.runAsGroup = runAsGroup;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsGroup() {
        return this.runAsGroup != null;
    }

    @Override
    public Boolean isRunAsNonRoot() {
        return this.runAsNonRoot;
    }

    @Override
    public A withRunAsNonRoot(Boolean runAsNonRoot) {
        this.runAsNonRoot = runAsNonRoot;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsNonRoot() {
        return this.runAsNonRoot != null;
    }

    @Override
    public A withNewRunAsNonRoot(String arg1) {
        return this.withRunAsNonRoot(new Boolean(arg1));
    }

    @Override
    public A withNewRunAsNonRoot(boolean arg1) {
        return this.withRunAsNonRoot(new Boolean(arg1));
    }

    @Override
    public Long getRunAsUser() {
        return this.runAsUser;
    }

    @Override
    public A withRunAsUser(Long runAsUser) {
        this.runAsUser = runAsUser;
        return (A)this;
    }

    @Override
    public Boolean hasRunAsUser() {
        return this.runAsUser != null;
    }

    @Override
    @Deprecated
    public V1SELinuxOptions getSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public V1SELinuxOptions buildSeLinuxOptions() {
        return this.seLinuxOptions != null ? this.seLinuxOptions.build() : null;
    }

    @Override
    public A withSeLinuxOptions(V1SELinuxOptions seLinuxOptions) {
        this._visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
        if (seLinuxOptions != null) {
            this.seLinuxOptions = new V1SELinuxOptionsBuilder(seLinuxOptions);
            this._visitables.get("seLinuxOptions").add(this.seLinuxOptions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSeLinuxOptions() {
        return this.seLinuxOptions != null;
    }

    @Override
    public V1SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
        return new SeLinuxOptionsNestedImpl();
    }

    @Override
    public V1SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(V1SELinuxOptions item) {
        return new SeLinuxOptionsNestedImpl(item);
    }

    @Override
    public V1SecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions());
    }

    @Override
    public V1SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : new V1SELinuxOptionsBuilder().build());
    }

    @Override
    public V1SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(V1SELinuxOptions item) {
        return this.withNewSeLinuxOptionsLike(this.getSeLinuxOptions() != null ? this.getSeLinuxOptions() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1SecurityContextFluentImpl that = (V1SecurityContextFluentImpl)o;
        if (this.allowPrivilegeEscalation != null ? !this.allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) : that.allowPrivilegeEscalation != null) {
            return false;
        }
        if (this.capabilities != null ? !this.capabilities.equals(that.capabilities) : that.capabilities != null) {
            return false;
        }
        if (this.privileged != null ? !this.privileged.equals(that.privileged) : that.privileged != null) {
            return false;
        }
        if (this.procMount != null ? !this.procMount.equals(that.procMount) : that.procMount != null) {
            return false;
        }
        if (this.readOnlyRootFilesystem != null ? !this.readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) : that.readOnlyRootFilesystem != null) {
            return false;
        }
        if (this.runAsGroup != null ? !this.runAsGroup.equals(that.runAsGroup) : that.runAsGroup != null) {
            return false;
        }
        if (this.runAsNonRoot != null ? !this.runAsNonRoot.equals(that.runAsNonRoot) : that.runAsNonRoot != null) {
            return false;
        }
        if (this.runAsUser != null ? !this.runAsUser.equals(that.runAsUser) : that.runAsUser != null) {
            return false;
        }
        return !(this.seLinuxOptions != null ? !this.seLinuxOptions.equals(that.seLinuxOptions) : that.seLinuxOptions != null);
    }

    public class SeLinuxOptionsNestedImpl<N>
    extends V1SELinuxOptionsFluentImpl<V1SecurityContextFluent.SeLinuxOptionsNested<N>>
    implements V1SecurityContextFluent.SeLinuxOptionsNested<N>,
    Nested<N> {
        private final V1SELinuxOptionsBuilder builder;

        SeLinuxOptionsNestedImpl(V1SELinuxOptions item) {
            this.builder = new V1SELinuxOptionsBuilder(this, item);
        }

        SeLinuxOptionsNestedImpl() {
            this.builder = new V1SELinuxOptionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluentImpl.this.withSeLinuxOptions(this.builder.build());
        }

        @Override
        public N endSeLinuxOptions() {
            return this.and();
        }
    }

    public class CapabilitiesNestedImpl<N>
    extends V1CapabilitiesFluentImpl<V1SecurityContextFluent.CapabilitiesNested<N>>
    implements V1SecurityContextFluent.CapabilitiesNested<N>,
    Nested<N> {
        private final V1CapabilitiesBuilder builder;

        CapabilitiesNestedImpl(V1Capabilities item) {
            this.builder = new V1CapabilitiesBuilder(this, item);
        }

        CapabilitiesNestedImpl() {
            this.builder = new V1CapabilitiesBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1SecurityContextFluentImpl.this.withCapabilities(this.builder.build());
        }

        @Override
        public N endCapabilities() {
            return this.and();
        }
    }
}

