/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1KeyToPath;
import io.kubernetes.client.models.V1KeyToPathBuilder;
import io.kubernetes.client.models.V1KeyToPathFluentImpl;
import io.kubernetes.client.models.V1SecretVolumeSource;
import io.kubernetes.client.models.V1SecretVolumeSourceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1SecretVolumeSourceFluentImpl<A extends V1SecretVolumeSourceFluent<A>>
extends BaseFluent<A>
implements V1SecretVolumeSourceFluent<A> {
    private Integer defaultMode;
    private List<V1KeyToPathBuilder> items;
    private Boolean optional;
    private String secretName;

    public V1SecretVolumeSourceFluentImpl() {
    }

    public V1SecretVolumeSourceFluentImpl(V1SecretVolumeSource instance) {
        this.withDefaultMode(instance.getDefaultMode());
        this.withItems(instance.getItems());
        this.withOptional(instance.isOptional());
        this.withSecretName(instance.getSecretName());
    }

    @Override
    public Integer getDefaultMode() {
        return this.defaultMode;
    }

    @Override
    public A withDefaultMode(Integer defaultMode) {
        this.defaultMode = defaultMode;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultMode() {
        return this.defaultMode != null;
    }

    @Override
    public A addToItems(int index, V1KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPathBuilder>();
        }
        V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, V1KeyToPath item) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPathBuilder>();
        }
        V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(V1KeyToPath ... items) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPathBuilder>();
        }
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<V1KeyToPath> items) {
        if (this.items == null) {
            this.items = new ArrayList<V1KeyToPathBuilder>();
        }
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(V1KeyToPath ... items) {
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<V1KeyToPath> items) {
        for (V1KeyToPath item : items) {
            V1KeyToPathBuilder builder = new V1KeyToPathBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1KeyToPath> getItems() {
        return V1SecretVolumeSourceFluentImpl.build(this.items);
    }

    @Override
    public List<V1KeyToPath> buildItems() {
        return V1SecretVolumeSourceFluentImpl.build(this.items);
    }

    @Override
    public V1KeyToPath buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public V1KeyToPath buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public V1KeyToPath buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public V1KeyToPath buildMatchingItem(Predicate<V1KeyToPathBuilder> predicate) {
        for (V1KeyToPathBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<V1KeyToPathBuilder> predicate) {
        for (V1KeyToPathBuilder item : this.items) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<V1KeyToPath> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<V1KeyToPathBuilder>();
            for (V1KeyToPath item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(V1KeyToPath ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (V1KeyToPath item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public V1SecretVolumeSourceFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public V1SecretVolumeSourceFluent.ItemsNested<A> addNewItemLike(V1KeyToPath item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public V1SecretVolumeSourceFluent.ItemsNested<A> setNewItemLike(int index, V1KeyToPath item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public V1SecretVolumeSourceFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1SecretVolumeSourceFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public V1SecretVolumeSourceFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1SecretVolumeSourceFluent.ItemsNested<A> editMatchingItem(Predicate<V1KeyToPathBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.apply(this.items.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public Boolean isOptional() {
        return this.optional;
    }

    @Override
    public A withOptional(Boolean optional) {
        this.optional = optional;
        return (A)this;
    }

    @Override
    public Boolean hasOptional() {
        return this.optional != null;
    }

    @Override
    public A withNewOptional(String arg1) {
        return this.withOptional(new Boolean(arg1));
    }

    @Override
    public A withNewOptional(boolean arg1) {
        return this.withOptional(new Boolean(arg1));
    }

    @Override
    public String getSecretName() {
        return this.secretName;
    }

    @Override
    public A withSecretName(String secretName) {
        this.secretName = secretName;
        return (A)this;
    }

    @Override
    public Boolean hasSecretName() {
        return this.secretName != null;
    }

    @Override
    public A withNewSecretName(String arg1) {
        return this.withSecretName(new String(arg1));
    }

    @Override
    public A withNewSecretName(StringBuilder arg1) {
        return this.withSecretName(new String(arg1));
    }

    @Override
    public A withNewSecretName(StringBuffer arg1) {
        return this.withSecretName(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1SecretVolumeSourceFluentImpl that = (V1SecretVolumeSourceFluentImpl)o;
        if (this.defaultMode != null ? !this.defaultMode.equals(that.defaultMode) : that.defaultMode != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.optional != null ? !this.optional.equals(that.optional) : that.optional != null) {
            return false;
        }
        return !(this.secretName != null ? !this.secretName.equals(that.secretName) : that.secretName != null);
    }

    public class ItemsNestedImpl<N>
    extends V1KeyToPathFluentImpl<V1SecretVolumeSourceFluent.ItemsNested<N>>
    implements V1SecretVolumeSourceFluent.ItemsNested<N>,
    Nested<N> {
        private final V1KeyToPathBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, V1KeyToPath item) {
            this.index = index;
            this.builder = new V1KeyToPathBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new V1KeyToPathBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1SecretVolumeSourceFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

