/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1ObjectMetaBuilder;
import io.kubernetes.client.models.V1ObjectMetaFluentImpl;
import io.kubernetes.client.models.V1ReplicationController;
import io.kubernetes.client.models.V1ReplicationControllerFluent;
import io.kubernetes.client.models.V1ReplicationControllerSpec;
import io.kubernetes.client.models.V1ReplicationControllerSpecBuilder;
import io.kubernetes.client.models.V1ReplicationControllerSpecFluentImpl;
import io.kubernetes.client.models.V1ReplicationControllerStatus;
import io.kubernetes.client.models.V1ReplicationControllerStatusBuilder;
import io.kubernetes.client.models.V1ReplicationControllerStatusFluentImpl;

public class V1ReplicationControllerFluentImpl<A extends V1ReplicationControllerFluent<A>>
extends BaseFluent<A>
implements V1ReplicationControllerFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1ReplicationControllerSpecBuilder spec;
    private V1ReplicationControllerStatusBuilder status;

    public V1ReplicationControllerFluentImpl() {
    }

    public V1ReplicationControllerFluentImpl(V1ReplicationController instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public V1ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1ReplicationControllerFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1ReplicationControllerFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1ReplicationControllerFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1ReplicationControllerFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ObjectMetaBuilder().build());
    }

    @Override
    public V1ReplicationControllerFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public V1ReplicationControllerSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public V1ReplicationControllerSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(V1ReplicationControllerSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new V1ReplicationControllerSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public V1ReplicationControllerFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public V1ReplicationControllerFluent.SpecNested<A> withNewSpecLike(V1ReplicationControllerSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public V1ReplicationControllerFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public V1ReplicationControllerFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new V1ReplicationControllerSpecBuilder().build());
    }

    @Override
    public V1ReplicationControllerFluent.SpecNested<A> editOrNewSpecLike(V1ReplicationControllerSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public V1ReplicationControllerStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public V1ReplicationControllerStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(V1ReplicationControllerStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new V1ReplicationControllerStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public V1ReplicationControllerFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public V1ReplicationControllerFluent.StatusNested<A> withNewStatusLike(V1ReplicationControllerStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public V1ReplicationControllerFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public V1ReplicationControllerFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new V1ReplicationControllerStatusBuilder().build());
    }

    @Override
    public V1ReplicationControllerFluent.StatusNested<A> editOrNewStatusLike(V1ReplicationControllerStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ReplicationControllerFluentImpl that = (V1ReplicationControllerFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends V1ReplicationControllerStatusFluentImpl<V1ReplicationControllerFluent.StatusNested<N>>
    implements V1ReplicationControllerFluent.StatusNested<N>,
    Nested<N> {
        private final V1ReplicationControllerStatusBuilder builder;

        StatusNestedImpl(V1ReplicationControllerStatus item) {
            this.builder = new V1ReplicationControllerStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new V1ReplicationControllerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ReplicationControllerFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends V1ReplicationControllerSpecFluentImpl<V1ReplicationControllerFluent.SpecNested<N>>
    implements V1ReplicationControllerFluent.SpecNested<N>,
    Nested<N> {
        private final V1ReplicationControllerSpecBuilder builder;

        SpecNestedImpl(V1ReplicationControllerSpec item) {
            this.builder = new V1ReplicationControllerSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new V1ReplicationControllerSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ReplicationControllerFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends V1ObjectMetaFluentImpl<V1ReplicationControllerFluent.MetadataNested<N>>
    implements V1ReplicationControllerFluent.MetadataNested<N>,
    Nested<N> {
        private final V1ObjectMetaBuilder builder;

        MetadataNestedImpl(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ReplicationControllerFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

