/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1NodeConfigSource;
import io.kubernetes.client.models.V1NodeConfigSourceBuilder;
import io.kubernetes.client.models.V1NodeConfigSourceFluentImpl;
import io.kubernetes.client.models.V1NodeSpec;
import io.kubernetes.client.models.V1NodeSpecFluent;
import io.kubernetes.client.models.V1Taint;
import io.kubernetes.client.models.V1TaintBuilder;
import io.kubernetes.client.models.V1TaintFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1NodeSpecFluentImpl<A extends V1NodeSpecFluent<A>>
extends BaseFluent<A>
implements V1NodeSpecFluent<A> {
    private V1NodeConfigSourceBuilder configSource;
    private String externalID;
    private String podCIDR;
    private String providerID;
    private List<V1TaintBuilder> taints;
    private Boolean unschedulable;

    public V1NodeSpecFluentImpl() {
    }

    public V1NodeSpecFluentImpl(V1NodeSpec instance) {
        this.withConfigSource(instance.getConfigSource());
        this.withExternalID(instance.getExternalID());
        this.withPodCIDR(instance.getPodCIDR());
        this.withProviderID(instance.getProviderID());
        this.withTaints(instance.getTaints());
        this.withUnschedulable(instance.isUnschedulable());
    }

    @Override
    @Deprecated
    public V1NodeConfigSource getConfigSource() {
        return this.configSource != null ? this.configSource.build() : null;
    }

    @Override
    public V1NodeConfigSource buildConfigSource() {
        return this.configSource != null ? this.configSource.build() : null;
    }

    @Override
    public A withConfigSource(V1NodeConfigSource configSource) {
        this._visitables.get("configSource").remove(this.configSource);
        if (configSource != null) {
            this.configSource = new V1NodeConfigSourceBuilder(configSource);
            this._visitables.get("configSource").add(this.configSource);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConfigSource() {
        return this.configSource != null;
    }

    @Override
    public V1NodeSpecFluent.ConfigSourceNested<A> withNewConfigSource() {
        return new ConfigSourceNestedImpl();
    }

    @Override
    public V1NodeSpecFluent.ConfigSourceNested<A> withNewConfigSourceLike(V1NodeConfigSource item) {
        return new ConfigSourceNestedImpl(item);
    }

    @Override
    public V1NodeSpecFluent.ConfigSourceNested<A> editConfigSource() {
        return this.withNewConfigSourceLike(this.getConfigSource());
    }

    @Override
    public V1NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSource() {
        return this.withNewConfigSourceLike(this.getConfigSource() != null ? this.getConfigSource() : new V1NodeConfigSourceBuilder().build());
    }

    @Override
    public V1NodeSpecFluent.ConfigSourceNested<A> editOrNewConfigSourceLike(V1NodeConfigSource item) {
        return this.withNewConfigSourceLike(this.getConfigSource() != null ? this.getConfigSource() : item);
    }

    @Override
    public String getExternalID() {
        return this.externalID;
    }

    @Override
    public A withExternalID(String externalID) {
        this.externalID = externalID;
        return (A)this;
    }

    @Override
    public Boolean hasExternalID() {
        return this.externalID != null;
    }

    @Override
    public A withNewExternalID(String arg1) {
        return this.withExternalID(new String(arg1));
    }

    @Override
    public A withNewExternalID(StringBuilder arg1) {
        return this.withExternalID(new String(arg1));
    }

    @Override
    public A withNewExternalID(StringBuffer arg1) {
        return this.withExternalID(new String(arg1));
    }

    @Override
    public String getPodCIDR() {
        return this.podCIDR;
    }

    @Override
    public A withPodCIDR(String podCIDR) {
        this.podCIDR = podCIDR;
        return (A)this;
    }

    @Override
    public Boolean hasPodCIDR() {
        return this.podCIDR != null;
    }

    @Override
    public A withNewPodCIDR(String arg1) {
        return this.withPodCIDR(new String(arg1));
    }

    @Override
    public A withNewPodCIDR(StringBuilder arg1) {
        return this.withPodCIDR(new String(arg1));
    }

    @Override
    public A withNewPodCIDR(StringBuffer arg1) {
        return this.withPodCIDR(new String(arg1));
    }

    @Override
    public String getProviderID() {
        return this.providerID;
    }

    @Override
    public A withProviderID(String providerID) {
        this.providerID = providerID;
        return (A)this;
    }

    @Override
    public Boolean hasProviderID() {
        return this.providerID != null;
    }

    @Override
    public A withNewProviderID(String arg1) {
        return this.withProviderID(new String(arg1));
    }

    @Override
    public A withNewProviderID(StringBuilder arg1) {
        return this.withProviderID(new String(arg1));
    }

    @Override
    public A withNewProviderID(StringBuffer arg1) {
        return this.withProviderID(new String(arg1));
    }

    @Override
    public A addToTaints(int index, V1Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<V1TaintBuilder>();
        }
        V1TaintBuilder builder = new V1TaintBuilder(item);
        this._visitables.get("taints").add(index >= 0 ? index : this._visitables.get("taints").size(), builder);
        this.taints.add(index >= 0 ? index : this.taints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTaints(int index, V1Taint item) {
        if (this.taints == null) {
            this.taints = new ArrayList<V1TaintBuilder>();
        }
        V1TaintBuilder builder = new V1TaintBuilder(item);
        if (index < 0 || index >= this._visitables.get("taints").size()) {
            this._visitables.get("taints").add(builder);
        } else {
            this._visitables.get("taints").set(index, builder);
        }
        if (index < 0 || index >= this.taints.size()) {
            this.taints.add(builder);
        } else {
            this.taints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTaints(V1Taint ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList<V1TaintBuilder>();
        }
        for (V1Taint item : items) {
            V1TaintBuilder builder = new V1TaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTaints(Collection<V1Taint> items) {
        if (this.taints == null) {
            this.taints = new ArrayList<V1TaintBuilder>();
        }
        for (V1Taint item : items) {
            V1TaintBuilder builder = new V1TaintBuilder(item);
            this._visitables.get("taints").add(builder);
            this.taints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTaints(V1Taint ... items) {
        for (V1Taint item : items) {
            V1TaintBuilder builder = new V1TaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            if (this.taints == null) continue;
            this.taints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTaints(Collection<V1Taint> items) {
        for (V1Taint item : items) {
            V1TaintBuilder builder = new V1TaintBuilder(item);
            this._visitables.get("taints").remove(builder);
            if (this.taints == null) continue;
            this.taints.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Taint> getTaints() {
        return V1NodeSpecFluentImpl.build(this.taints);
    }

    @Override
    public List<V1Taint> buildTaints() {
        return V1NodeSpecFluentImpl.build(this.taints);
    }

    @Override
    public V1Taint buildTaint(int index) {
        return this.taints.get(index).build();
    }

    @Override
    public V1Taint buildFirstTaint() {
        return this.taints.get(0).build();
    }

    @Override
    public V1Taint buildLastTaint() {
        return this.taints.get(this.taints.size() - 1).build();
    }

    @Override
    public V1Taint buildMatchingTaint(Predicate<V1TaintBuilder> predicate) {
        for (V1TaintBuilder item : this.taints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTaint(Predicate<V1TaintBuilder> predicate) {
        for (V1TaintBuilder item : this.taints) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTaints(List<V1Taint> taints) {
        if (this.taints != null) {
            this._visitables.get("taints").removeAll(this.taints);
        }
        if (taints != null) {
            this.taints = new ArrayList<V1TaintBuilder>();
            for (V1Taint item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)this;
    }

    @Override
    public A withTaints(V1Taint ... taints) {
        if (this.taints != null) {
            this.taints.clear();
        }
        if (taints != null) {
            for (V1Taint item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> addNewTaint() {
        return new TaintsNestedImpl();
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> addNewTaintLike(V1Taint item) {
        return new TaintsNestedImpl(-1, item);
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> setNewTaintLike(int index, V1Taint item) {
        return new TaintsNestedImpl(index, item);
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> editTaint(int index) {
        if (this.taints.size() <= index) {
            throw new RuntimeException("Can't edit taints. Index exceeds size.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> editFirstTaint() {
        if (this.taints.size() == 0) {
            throw new RuntimeException("Can't edit first taints. The list is empty.");
        }
        return this.setNewTaintLike(0, this.buildTaint(0));
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> editLastTaint() {
        int index = this.taints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last taints. The list is empty.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public V1NodeSpecFluent.TaintsNested<A> editMatchingTaint(Predicate<V1TaintBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.taints.size(); ++i) {
            if (!predicate.apply(this.taints.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching taints. No match found.");
        }
        return this.setNewTaintLike(index, this.buildTaint(index));
    }

    @Override
    public Boolean isUnschedulable() {
        return this.unschedulable;
    }

    @Override
    public A withUnschedulable(Boolean unschedulable) {
        this.unschedulable = unschedulable;
        return (A)this;
    }

    @Override
    public Boolean hasUnschedulable() {
        return this.unschedulable != null;
    }

    @Override
    public A withNewUnschedulable(String arg1) {
        return this.withUnschedulable(new Boolean(arg1));
    }

    @Override
    public A withNewUnschedulable(boolean arg1) {
        return this.withUnschedulable(new Boolean(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NodeSpecFluentImpl that = (V1NodeSpecFluentImpl)o;
        if (this.configSource != null ? !this.configSource.equals(that.configSource) : that.configSource != null) {
            return false;
        }
        if (this.externalID != null ? !this.externalID.equals(that.externalID) : that.externalID != null) {
            return false;
        }
        if (this.podCIDR != null ? !this.podCIDR.equals(that.podCIDR) : that.podCIDR != null) {
            return false;
        }
        if (this.providerID != null ? !this.providerID.equals(that.providerID) : that.providerID != null) {
            return false;
        }
        if (this.taints != null ? !this.taints.equals(that.taints) : that.taints != null) {
            return false;
        }
        return !(this.unschedulable != null ? !this.unschedulable.equals(that.unschedulable) : that.unschedulable != null);
    }

    public class TaintsNestedImpl<N>
    extends V1TaintFluentImpl<V1NodeSpecFluent.TaintsNested<N>>
    implements V1NodeSpecFluent.TaintsNested<N>,
    Nested<N> {
        private final V1TaintBuilder builder;
        private final int index;

        TaintsNestedImpl(int index, V1Taint item) {
            this.index = index;
            this.builder = new V1TaintBuilder(this, item);
        }

        TaintsNestedImpl() {
            this.index = -1;
            this.builder = new V1TaintBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeSpecFluentImpl.this.setToTaints(this.index, this.builder.build());
        }

        @Override
        public N endTaint() {
            return this.and();
        }
    }

    public class ConfigSourceNestedImpl<N>
    extends V1NodeConfigSourceFluentImpl<V1NodeSpecFluent.ConfigSourceNested<N>>
    implements V1NodeSpecFluent.ConfigSourceNested<N>,
    Nested<N> {
        private final V1NodeConfigSourceBuilder builder;

        ConfigSourceNestedImpl(V1NodeConfigSource item) {
            this.builder = new V1NodeConfigSourceBuilder(this, item);
        }

        ConfigSourceNestedImpl() {
            this.builder = new V1NodeConfigSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1NodeSpecFluentImpl.this.withConfigSource(this.builder.build());
        }

        @Override
        public N endConfigSource() {
            return this.and();
        }
    }
}

