/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1JobCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

@ApiModel(description="JobStatus represents the current state of a Job.")
public class V1JobStatus {
    @SerializedName(value="active")
    private Integer active = null;
    @SerializedName(value="completionTime")
    private DateTime completionTime = null;
    @SerializedName(value="conditions")
    private List<V1JobCondition> conditions = null;
    @SerializedName(value="failed")
    private Integer failed = null;
    @SerializedName(value="startTime")
    private DateTime startTime = null;
    @SerializedName(value="succeeded")
    private Integer succeeded = null;

    public V1JobStatus active(Integer active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="The number of actively running pods.")
    public Integer getActive() {
        return this.active;
    }

    public void setActive(Integer active) {
        this.active = active;
    }

    public V1JobStatus completionTime(DateTime completionTime) {
        this.completionTime = completionTime;
        return this;
    }

    @ApiModelProperty(value="Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.")
    public DateTime getCompletionTime() {
        return this.completionTime;
    }

    public void setCompletionTime(DateTime completionTime) {
        this.completionTime = completionTime;
    }

    public V1JobStatus conditions(List<V1JobCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1JobStatus addConditionsItem(V1JobCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1JobCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(value="The latest available observations of an object's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/")
    public List<V1JobCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1JobCondition> conditions) {
        this.conditions = conditions;
    }

    public V1JobStatus failed(Integer failed) {
        this.failed = failed;
        return this;
    }

    @ApiModelProperty(value="The number of pods which reached phase Failed.")
    public Integer getFailed() {
        return this.failed;
    }

    public void setFailed(Integer failed) {
        this.failed = failed;
    }

    public V1JobStatus startTime(DateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    @ApiModelProperty(value="Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC.")
    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime startTime) {
        this.startTime = startTime;
    }

    public V1JobStatus succeeded(Integer succeeded) {
        this.succeeded = succeeded;
        return this;
    }

    @ApiModelProperty(value="The number of pods which reached phase Succeeded.")
    public Integer getSucceeded() {
        return this.succeeded;
    }

    public void setSucceeded(Integer succeeded) {
        this.succeeded = succeeded;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1JobStatus v1JobStatus = (V1JobStatus)o;
        return Objects.equals(this.active, v1JobStatus.active) && Objects.equals(this.completionTime, v1JobStatus.completionTime) && Objects.equals(this.conditions, v1JobStatus.conditions) && Objects.equals(this.failed, v1JobStatus.failed) && Objects.equals(this.startTime, v1JobStatus.startTime) && Objects.equals(this.succeeded, v1JobStatus.succeeded);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.completionTime, this.conditions, this.failed, this.startTime, this.succeeded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1JobStatus {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    completionTime: ").append(this.toIndentedString(this.completionTime)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    failed: ").append(this.toIndentedString(this.failed)).append("\n");
        sb.append("    startTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("    succeeded: ").append(this.toIndentedString(this.succeeded)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

