/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.models.V1HTTPHeader;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="HTTPGetAction describes an action based on HTTP Get requests.")
public class V1HTTPGetAction {
    @SerializedName(value="host")
    private String host = null;
    @SerializedName(value="httpHeaders")
    private List<V1HTTPHeader> httpHeaders = null;
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="port")
    private IntOrString port = null;
    @SerializedName(value="scheme")
    private String scheme = null;

    public V1HTTPGetAction host(String host) {
        this.host = host;
        return this;
    }

    @ApiModelProperty(value="Host name to connect to, defaults to the pod IP. You probably want to set \"Host\" in httpHeaders instead.")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public V1HTTPGetAction httpHeaders(List<V1HTTPHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
        return this;
    }

    public V1HTTPGetAction addHttpHeadersItem(V1HTTPHeader httpHeadersItem) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList<V1HTTPHeader>();
        }
        this.httpHeaders.add(httpHeadersItem);
        return this;
    }

    @ApiModelProperty(value="Custom headers to set in the request. HTTP allows repeated headers.")
    public List<V1HTTPHeader> getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(List<V1HTTPHeader> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public V1HTTPGetAction path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="Path to access on the HTTP server.")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1HTTPGetAction port(IntOrString port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(required=true, value="Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.")
    public IntOrString getPort() {
        return this.port;
    }

    public void setPort(IntOrString port) {
        this.port = port;
    }

    public V1HTTPGetAction scheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    @ApiModelProperty(value="Scheme to use for connecting to the host. Defaults to HTTP.")
    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HTTPGetAction v1HTTPGetAction = (V1HTTPGetAction)o;
        return Objects.equals(this.host, v1HTTPGetAction.host) && Objects.equals(this.httpHeaders, v1HTTPGetAction.httpHeaders) && Objects.equals(this.path, v1HTTPGetAction.path) && Objects.equals(this.port, v1HTTPGetAction.port) && Objects.equals(this.scheme, v1HTTPGetAction.scheme);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.httpHeaders, this.path, this.port, this.scheme);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1HTTPGetAction {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    httpHeaders: ").append(this.toIndentedString(this.httpHeaders)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString(this.scheme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

