/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1SecretReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Represents a Ceph Filesystem mount that lasts the lifetime of a pod Cephfs volumes do not support ownership management or SELinux relabeling.")
public class V1CephFSPersistentVolumeSource {
    @SerializedName(value="monitors")
    private List<String> monitors = new ArrayList<String>();
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="readOnly")
    private Boolean readOnly = null;
    @SerializedName(value="secretFile")
    private String secretFile = null;
    @SerializedName(value="secretRef")
    private V1SecretReference secretRef = null;
    @SerializedName(value="user")
    private String user = null;

    public V1CephFSPersistentVolumeSource monitors(List<String> monitors) {
        this.monitors = monitors;
        return this;
    }

    public V1CephFSPersistentVolumeSource addMonitorsItem(String monitorsItem) {
        this.monitors.add(monitorsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Required: Monitors is a collection of Ceph monitors More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it")
    public List<String> getMonitors() {
        return this.monitors;
    }

    public void setMonitors(List<String> monitors) {
        this.monitors = monitors;
    }

    public V1CephFSPersistentVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(value="Optional: Used as the mounted root, rather than the full Ceph tree, default is /")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1CephFSPersistentVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @ApiModelProperty(value="Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it")
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1CephFSPersistentVolumeSource secretFile(String secretFile) {
        this.secretFile = secretFile;
        return this;
    }

    @ApiModelProperty(value="Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it")
    public String getSecretFile() {
        return this.secretFile;
    }

    public void setSecretFile(String secretFile) {
        this.secretFile = secretFile;
    }

    public V1CephFSPersistentVolumeSource secretRef(V1SecretReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @ApiModelProperty(value="Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it")
    public V1SecretReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1SecretReference secretRef) {
        this.secretRef = secretRef;
    }

    public V1CephFSPersistentVolumeSource user(String user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="Optional: User is the rados user name, default is admin More info: https://releases.k8s.io/HEAD/examples/volumes/cephfs/README.md#how-to-use-it")
    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1CephFSPersistentVolumeSource v1CephFSPersistentVolumeSource = (V1CephFSPersistentVolumeSource)o;
        return Objects.equals(this.monitors, v1CephFSPersistentVolumeSource.monitors) && Objects.equals(this.path, v1CephFSPersistentVolumeSource.path) && Objects.equals(this.readOnly, v1CephFSPersistentVolumeSource.readOnly) && Objects.equals(this.secretFile, v1CephFSPersistentVolumeSource.secretFile) && Objects.equals(this.secretRef, v1CephFSPersistentVolumeSource.secretRef) && Objects.equals(this.user, v1CephFSPersistentVolumeSource.user);
    }

    public int hashCode() {
        return Objects.hash(this.monitors, this.path, this.readOnly, this.secretFile, this.secretRef, this.user);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1CephFSPersistentVolumeSource {\n");
        sb.append("    monitors: ").append(this.toIndentedString(this.monitors)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretFile: ").append(this.toIndentedString(this.secretFile)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

