/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1APIResource;
import io.kubernetes.client.models.V1APIResourceBuilder;
import io.kubernetes.client.models.V1APIResourceFluentImpl;
import io.kubernetes.client.models.V1APIResourceList;
import io.kubernetes.client.models.V1APIResourceListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1APIResourceListFluentImpl<A extends V1APIResourceListFluent<A>>
extends BaseFluent<A>
implements V1APIResourceListFluent<A> {
    private String apiVersion;
    private String groupVersion;
    private String kind;
    private List<V1APIResourceBuilder> resources;

    public V1APIResourceListFluentImpl() {
    }

    public V1APIResourceListFluentImpl(V1APIResourceList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroupVersion(instance.getGroupVersion());
        this.withKind(instance.getKind());
        this.withResources(instance.getResources());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getGroupVersion() {
        return this.groupVersion;
    }

    @Override
    public A withGroupVersion(String groupVersion) {
        this.groupVersion = groupVersion;
        return (A)this;
    }

    @Override
    public Boolean hasGroupVersion() {
        return this.groupVersion != null;
    }

    @Override
    public A withNewGroupVersion(String arg1) {
        return this.withGroupVersion(new String(arg1));
    }

    @Override
    public A withNewGroupVersion(StringBuilder arg1) {
        return this.withGroupVersion(new String(arg1));
    }

    @Override
    public A withNewGroupVersion(StringBuffer arg1) {
        return this.withGroupVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A addToResources(int index, V1APIResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList<V1APIResourceBuilder>();
        }
        V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
        this._visitables.get("resources").add(index >= 0 ? index : this._visitables.get("resources").size(), builder);
        this.resources.add(index >= 0 ? index : this.resources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResources(int index, V1APIResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList<V1APIResourceBuilder>();
        }
        V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
        if (index < 0 || index >= this._visitables.get("resources").size()) {
            this._visitables.get("resources").add(builder);
        } else {
            this._visitables.get("resources").set(index, builder);
        }
        if (index < 0 || index >= this.resources.size()) {
            this.resources.add(builder);
        } else {
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResources(V1APIResource ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<V1APIResourceBuilder>();
        }
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<V1APIResource> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<V1APIResourceBuilder>();
        }
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(V1APIResource ... items) {
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<V1APIResource> items) {
        for (V1APIResource item : items) {
            V1APIResourceBuilder builder = new V1APIResourceBuilder(item);
            this._visitables.get("resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1APIResource> getResources() {
        return V1APIResourceListFluentImpl.build(this.resources);
    }

    @Override
    public List<V1APIResource> buildResources() {
        return V1APIResourceListFluentImpl.build(this.resources);
    }

    @Override
    public V1APIResource buildResource(int index) {
        return this.resources.get(index).build();
    }

    @Override
    public V1APIResource buildFirstResource() {
        return this.resources.get(0).build();
    }

    @Override
    public V1APIResource buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    @Override
    public V1APIResource buildMatchingResource(Predicate<V1APIResourceBuilder> predicate) {
        for (V1APIResourceBuilder item : this.resources) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<V1APIResourceBuilder> predicate) {
        for (V1APIResourceBuilder item : this.resources) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<V1APIResource> resources) {
        if (this.resources != null) {
            this._visitables.get("resources").removeAll(this.resources);
        }
        if (resources != null) {
            this.resources = new ArrayList<V1APIResourceBuilder>();
            for (V1APIResource item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(V1APIResource ... resources) {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (resources != null) {
            for (V1APIResource item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> addNewResourceLike(V1APIResource item) {
        return new ResourcesNestedImpl(-1, item);
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> setNewResourceLike(int index, V1APIResource item) {
        return new ResourcesNestedImpl(index, item);
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public V1APIResourceListFluent.ResourcesNested<A> editMatchingResource(Predicate<V1APIResourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.apply(this.resources.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1APIResourceListFluentImpl that = (V1APIResourceListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groupVersion != null ? !this.groupVersion.equals(that.groupVersion) : that.groupVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.resources != null ? !this.resources.equals(that.resources) : that.resources != null);
    }

    public class ResourcesNestedImpl<N>
    extends V1APIResourceFluentImpl<V1APIResourceListFluent.ResourcesNested<N>>
    implements V1APIResourceListFluent.ResourcesNested<N>,
    Nested<N> {
        private final V1APIResourceBuilder builder;
        private final int index;

        ResourcesNestedImpl(int index, V1APIResource item) {
            this.index = index;
            this.builder = new V1APIResourceBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.index = -1;
            this.builder = new V1APIResourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIResourceListFluentImpl.this.setToResources(this.index, this.builder.build());
        }

        @Override
        public N endResource() {
            return this.and();
        }
    }
}

