/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1alpha3AllocatedDeviceStatus;
import io.kubernetes.client.openapi.models.V1alpha3AllocationResult;
import io.kubernetes.client.openapi.models.V1alpha3ResourceClaimConsumerReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourceClaimStatus tracks whether the resource has been allocated and what the result of that was.")
public class V1alpha3ResourceClaimStatus {
    public static final String SERIALIZED_NAME_ALLOCATION = "allocation";
    @SerializedName(value="allocation")
    private V1alpha3AllocationResult allocation;
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    private List<V1alpha3AllocatedDeviceStatus> devices = new ArrayList<V1alpha3AllocatedDeviceStatus>();
    public static final String SERIALIZED_NAME_RESERVED_FOR = "reservedFor";
    @SerializedName(value="reservedFor")
    private List<V1alpha3ResourceClaimConsumerReference> reservedFor = new ArrayList<V1alpha3ResourceClaimConsumerReference>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha3ResourceClaimStatus allocation(V1alpha3AllocationResult allocation) {
        this.allocation = allocation;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha3AllocationResult getAllocation() {
        return this.allocation;
    }

    public void setAllocation(V1alpha3AllocationResult allocation) {
        this.allocation = allocation;
    }

    public V1alpha3ResourceClaimStatus devices(List<V1alpha3AllocatedDeviceStatus> devices) {
        this.devices = devices;
        return this;
    }

    public V1alpha3ResourceClaimStatus addDevicesItem(V1alpha3AllocatedDeviceStatus devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<V1alpha3AllocatedDeviceStatus>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Devices contains the status of each device allocated for this claim, as reported by the driver. This can include driver-specific information. Entries are owned by their respective drivers.")
    public List<V1alpha3AllocatedDeviceStatus> getDevices() {
        return this.devices;
    }

    public void setDevices(List<V1alpha3AllocatedDeviceStatus> devices) {
        this.devices = devices;
    }

    public V1alpha3ResourceClaimStatus reservedFor(List<V1alpha3ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
        return this;
    }

    public V1alpha3ResourceClaimStatus addReservedForItem(V1alpha3ResourceClaimConsumerReference reservedForItem) {
        if (this.reservedFor == null) {
            this.reservedFor = new ArrayList<V1alpha3ResourceClaimConsumerReference>();
        }
        this.reservedFor.add(reservedForItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ReservedFor indicates which entities are currently allowed to use the claim. A Pod which references a ResourceClaim which is not reserved for that Pod will not be started. A claim that is in use or might be in use because it has been reserved must not get deallocated.  In a cluster with multiple scheduler instances, two pods might get scheduled concurrently by different schedulers. When they reference the same ResourceClaim which already has reached its maximum number of consumers, only one pod can be scheduled.  Both schedulers try to add their pod to the claim.status.reservedFor field, but only the update that reaches the API server first gets stored. The other one fails with an error and the scheduler which issued it knows that it must put the pod back into the queue, waiting for the ResourceClaim to become usable again.  There can be at most 256 such reservations. This may get increased in the future, but not reduced.")
    public List<V1alpha3ResourceClaimConsumerReference> getReservedFor() {
        return this.reservedFor;
    }

    public void setReservedFor(List<V1alpha3ResourceClaimConsumerReference> reservedFor) {
        this.reservedFor = reservedFor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3ResourceClaimStatus v1alpha3ResourceClaimStatus = (V1alpha3ResourceClaimStatus)o;
        return Objects.equals(this.allocation, v1alpha3ResourceClaimStatus.allocation) && Objects.equals(this.devices, v1alpha3ResourceClaimStatus.devices) && Objects.equals(this.reservedFor, v1alpha3ResourceClaimStatus.reservedFor);
    }

    public int hashCode() {
        return Objects.hash(this.allocation, this.devices, this.reservedFor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3ResourceClaimStatus {\n");
        sb.append("    allocation: ").append(this.toIndentedString(this.allocation)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    reservedFor: ").append(this.toIndentedString(this.reservedFor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayreservedFor;
        int i;
        JsonArray jsonArraydevices;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha3ResourceClaimStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha3ResourceClaimStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ALLOCATION) != null && !jsonObj.get(SERIALIZED_NAME_ALLOCATION).isJsonNull()) {
            V1alpha3AllocationResult.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ALLOCATION));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonNull() && (jsonArraydevices = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `devices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICES).toString()));
            }
            for (i = 0; i < jsonArraydevices.size(); ++i) {
                V1alpha3AllocatedDeviceStatus.validateJsonElement(jsonArraydevices.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RESERVED_FOR) != null && !jsonObj.get(SERIALIZED_NAME_RESERVED_FOR).isJsonNull() && (jsonArrayreservedFor = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESERVED_FOR)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESERVED_FOR).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `reservedFor` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESERVED_FOR).toString()));
            }
            for (i = 0; i < jsonArrayreservedFor.size(); ++i) {
                V1alpha3ResourceClaimConsumerReference.validateJsonElement(jsonArrayreservedFor.get(i));
            }
        }
    }

    public static V1alpha3ResourceClaimStatus fromJson(String jsonString) throws IOException {
        return (V1alpha3ResourceClaimStatus)JSON.getGson().fromJson(jsonString, V1alpha3ResourceClaimStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ALLOCATION);
        openapiFields.add(SERIALIZED_NAME_DEVICES);
        openapiFields.add(SERIALIZED_NAME_RESERVED_FOR);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha3ResourceClaimStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha3ResourceClaimStatus.class));
            return new TypeAdapter<V1alpha3ResourceClaimStatus>(){

                public void write(JsonWriter out, V1alpha3ResourceClaimStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha3ResourceClaimStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha3ResourceClaimStatus.validateJsonElement(jsonElement);
                    return (V1alpha3ResourceClaimStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

