/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1GroupVersionForDiscovery;
import io.kubernetes.client.openapi.models.V1ServerAddressByClientCIDR;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="APIGroup contains the name, the supported versions, and the preferred version of a group.")
public class V1APIGroup {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PREFERRED_VERSION = "preferredVersion";
    @SerializedName(value="preferredVersion")
    private V1GroupVersionForDiscovery preferredVersion;
    public static final String SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS = "serverAddressByClientCIDRs";
    @SerializedName(value="serverAddressByClientCIDRs")
    private List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDR>();
    public static final String SERIALIZED_NAME_VERSIONS = "versions";
    @SerializedName(value="versions")
    private List<V1GroupVersionForDiscovery> versions = new ArrayList<V1GroupVersionForDiscovery>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1APIGroup apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1APIGroup kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1APIGroup name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="name is the name of the group.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1APIGroup preferredVersion(V1GroupVersionForDiscovery preferredVersion) {
        this.preferredVersion = preferredVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1GroupVersionForDiscovery getPreferredVersion() {
        return this.preferredVersion;
    }

    public void setPreferredVersion(V1GroupVersionForDiscovery preferredVersion) {
        this.preferredVersion = preferredVersion;
    }

    public V1APIGroup serverAddressByClientCIDRs(List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
        return this;
    }

    public V1APIGroup addServerAddressByClientCIDRsItem(V1ServerAddressByClientCIDR serverAddressByClientCIDRsItem) {
        if (this.serverAddressByClientCIDRs == null) {
            this.serverAddressByClientCIDRs = new ArrayList<V1ServerAddressByClientCIDR>();
        }
        this.serverAddressByClientCIDRs.add(serverAddressByClientCIDRsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="a map of client CIDR to server address that is serving this group. This is to help clients reach servers in the most network-efficient way possible. Clients can use the appropriate server address as per the CIDR that they match. In case of multiple matches, clients should use the longest matching CIDR. The server returns only those CIDRs that it thinks that the client can match. For example: the master will return an internal IP CIDR only, if the client reaches the server using an internal IP. Server looks at X-Forwarded-For header or X-Real-Ip header or request.RemoteAddr (in that order) to get the client IP.")
    public List<V1ServerAddressByClientCIDR> getServerAddressByClientCIDRs() {
        return this.serverAddressByClientCIDRs;
    }

    public void setServerAddressByClientCIDRs(List<V1ServerAddressByClientCIDR> serverAddressByClientCIDRs) {
        this.serverAddressByClientCIDRs = serverAddressByClientCIDRs;
    }

    public V1APIGroup versions(List<V1GroupVersionForDiscovery> versions) {
        this.versions = versions;
        return this;
    }

    public V1APIGroup addVersionsItem(V1GroupVersionForDiscovery versionsItem) {
        if (this.versions == null) {
            this.versions = new ArrayList<V1GroupVersionForDiscovery>();
        }
        this.versions.add(versionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="versions are the versions supported in this group.")
    public List<V1GroupVersionForDiscovery> getVersions() {
        return this.versions;
    }

    public void setVersions(List<V1GroupVersionForDiscovery> versions) {
        this.versions = versions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIGroup v1APIGroup = (V1APIGroup)o;
        return Objects.equals(this.apiVersion, v1APIGroup.apiVersion) && Objects.equals(this.kind, v1APIGroup.kind) && Objects.equals(this.name, v1APIGroup.name) && Objects.equals(this.preferredVersion, v1APIGroup.preferredVersion) && Objects.equals(this.serverAddressByClientCIDRs, v1APIGroup.serverAddressByClientCIDRs) && Objects.equals(this.versions, v1APIGroup.versions);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.name, this.preferredVersion, this.serverAddressByClientCIDRs, this.versions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1APIGroup {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    preferredVersion: ").append(this.toIndentedString(this.preferredVersion)).append("\n");
        sb.append("    serverAddressByClientCIDRs: ").append(this.toIndentedString(this.serverAddressByClientCIDRs)).append("\n");
        sb.append("    versions: ").append(this.toIndentedString(this.versions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        int i;
        JsonArray jsonArrayserverAddressByClientCIDRs;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1APIGroup is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1APIGroup` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PREFERRED_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_PREFERRED_VERSION).isJsonNull()) {
            V1GroupVersionForDiscovery.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PREFERRED_VERSION));
        }
        if (jsonObj.get(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS) != null && !jsonObj.get(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS).isJsonNull() && (jsonArrayserverAddressByClientCIDRs = jsonObj.getAsJsonArray(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `serverAddressByClientCIDRs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS).toString()));
            }
            for (i = 0; i < jsonArrayserverAddressByClientCIDRs.size(); ++i) {
                V1ServerAddressByClientCIDR.validateJsonElement(jsonArrayserverAddressByClientCIDRs.get(i));
            }
        }
        if (!jsonObj.get(SERIALIZED_NAME_VERSIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `versions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSIONS).toString()));
        }
        JsonArray jsonArrayversions = jsonObj.getAsJsonArray(SERIALIZED_NAME_VERSIONS);
        for (i = 0; i < jsonArrayversions.size(); ++i) {
            V1GroupVersionForDiscovery.validateJsonElement(jsonArrayversions.get(i));
        }
    }

    public static V1APIGroup fromJson(String jsonString) throws IOException {
        return (V1APIGroup)JSON.getGson().fromJson(jsonString, V1APIGroup.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PREFERRED_VERSION);
        openapiFields.add(SERIALIZED_NAME_SERVER_ADDRESS_BY_CLIENT_C_I_D_RS);
        openapiFields.add(SERIALIZED_NAME_VERSIONS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_VERSIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1APIGroup.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1APIGroup.class));
            return new TypeAdapter<V1APIGroup>(){

                public void write(JsonWriter out, V1APIGroup value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1APIGroup read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1APIGroup.validateJsonElement(jsonElement);
                    return (V1APIGroup)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

