/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.apis;

import com.google.gson.reflect.TypeToken;
import io.kubernetes.client.custom.V1Patch;
import io.kubernetes.client.openapi.ApiCallback;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.ApiResponse;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.Pair;
import io.kubernetes.client.openapi.models.V1APIResourceList;
import io.kubernetes.client.openapi.models.V1DeleteOptions;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionMigration;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionMigrationList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;

public class StoragemigrationV1alpha1Api {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public StoragemigrationV1alpha1Api() {
        this(Configuration.getDefaultApiClient());
    }

    public StoragemigrationV1alpha1Api(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call createStorageVersionMigrationCall(V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha1StorageVersionMigration localVarPostBody = body;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call createStorageVersionMigrationValidateBeforeCall(V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling createStorageVersionMigration(Async)");
        }
        return this.createStorageVersionMigrationCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha1StorageVersionMigration> createStorageVersionMigrationWithHttpInfo(V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.createStorageVersionMigrationValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call createStorageVersionMigrationAsync(V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
        Call localVarCall = this.createStorageVersionMigrationValidateBeforeCall(body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIcreateStorageVersionMigrationRequest createStorageVersionMigration(V1alpha1StorageVersionMigration body) {
        return new APIcreateStorageVersionMigrationRequest(body);
    }

    private Call deleteCollectionStorageVersionMigrationCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteCollectionStorageVersionMigrationValidateBeforeCall(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        return this.deleteCollectionStorageVersionMigrationCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
    }

    private ApiResponse<V1Status> deleteCollectionStorageVersionMigrationWithHttpInfo(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteCollectionStorageVersionMigrationValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCollectionStorageVersionMigrationAsync(String pretty, String _continue, String dryRun, String fieldSelector, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, String labelSelector, Integer limit, Boolean orphanDependents, String propagationPolicy, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteCollectionStorageVersionMigrationValidateBeforeCall(pretty, _continue, dryRun, fieldSelector, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, labelSelector, limit, orphanDependents, propagationPolicy, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteCollectionStorageVersionMigrationRequest deleteCollectionStorageVersionMigration() {
        return new APIdeleteCollectionStorageVersionMigrationRequest();
    }

    private Call deleteStorageVersionMigrationCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1DeleteOptions localVarPostBody = body;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (gracePeriodSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("gracePeriodSeconds", gracePeriodSeconds));
        }
        if (ignoreStoreReadErrorWithClusterBreakingPotential != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("ignoreStoreReadErrorWithClusterBreakingPotential", ignoreStoreReadErrorWithClusterBreakingPotential));
        }
        if (orphanDependents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orphanDependents", orphanDependents));
        }
        if (propagationPolicy != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("propagationPolicy", propagationPolicy));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteStorageVersionMigrationValidateBeforeCall(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling deleteStorageVersionMigration(Async)");
        }
        return this.deleteStorageVersionMigrationCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
    }

    private ApiResponse<V1Status> deleteStorageVersionMigrationWithHttpInfo(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body) throws ApiException {
        Call localVarCall = this.deleteStorageVersionMigrationValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, null);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteStorageVersionMigrationAsync(String name, String pretty, String dryRun, Integer gracePeriodSeconds, Boolean ignoreStoreReadErrorWithClusterBreakingPotential, Boolean orphanDependents, String propagationPolicy, V1DeleteOptions body, ApiCallback<V1Status> _callback) throws ApiException {
        Call localVarCall = this.deleteStorageVersionMigrationValidateBeforeCall(name, pretty, dryRun, gracePeriodSeconds, ignoreStoreReadErrorWithClusterBreakingPotential, orphanDependents, propagationPolicy, body, _callback);
        Type localVarReturnType = new TypeToken<V1Status>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIdeleteStorageVersionMigrationRequest deleteStorageVersionMigration(String name) {
        return new APIdeleteStorageVersionMigrationRequest(name);
    }

    private Call getAPIResourcesCall(ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getAPIResourcesValidateBeforeCall(ApiCallback _callback) throws ApiException {
        return this.getAPIResourcesCall(_callback);
    }

    private ApiResponse<V1APIResourceList> getAPIResourcesWithHttpInfo() throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getAPIResourcesAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
        Call localVarCall = this.getAPIResourcesValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<V1APIResourceList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIgetAPIResourcesRequest getAPIResources() {
        return new APIgetAPIResourcesRequest();
    }

    private Call listStorageVersionMigrationCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (allowWatchBookmarks != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("allowWatchBookmarks", allowWatchBookmarks));
        }
        if (_continue != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("continue", _continue));
        }
        if (fieldSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldSelector", fieldSelector));
        }
        if (labelSelector != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labelSelector", labelSelector));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("limit", limit));
        }
        if (resourceVersion != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersion", resourceVersion));
        }
        if (resourceVersionMatch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("resourceVersionMatch", resourceVersionMatch));
        }
        if (sendInitialEvents != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("sendInitialEvents", sendInitialEvents));
        }
        if (timeoutSeconds != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("timeoutSeconds", timeoutSeconds));
        }
        if (watch != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("watch", watch));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor", "application/json;stream=watch", "application/vnd.kubernetes.protobuf;stream=watch", "application/cbor-seq"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listStorageVersionMigrationValidateBeforeCall(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback _callback) throws ApiException {
        return this.listStorageVersionMigrationCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
    }

    private ApiResponse<V1alpha1StorageVersionMigrationList> listStorageVersionMigrationWithHttpInfo(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch) throws ApiException {
        Call localVarCall = this.listStorageVersionMigrationValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, null);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigrationList>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call listStorageVersionMigrationAsync(String pretty, Boolean allowWatchBookmarks, String _continue, String fieldSelector, String labelSelector, Integer limit, String resourceVersion, String resourceVersionMatch, Boolean sendInitialEvents, Integer timeoutSeconds, Boolean watch, ApiCallback<V1alpha1StorageVersionMigrationList> _callback) throws ApiException {
        Call localVarCall = this.listStorageVersionMigrationValidateBeforeCall(pretty, allowWatchBookmarks, _continue, fieldSelector, labelSelector, limit, resourceVersion, resourceVersionMatch, sendInitialEvents, timeoutSeconds, watch, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigrationList>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIlistStorageVersionMigrationRequest listStorageVersionMigration() {
        return new APIlistStorageVersionMigrationRequest();
    }

    private Call patchStorageVersionMigrationCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchStorageVersionMigrationValidateBeforeCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchStorageVersionMigration(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchStorageVersionMigration(Async)");
        }
        return this.patchStorageVersionMigrationCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1alpha1StorageVersionMigration> patchStorageVersionMigrationWithHttpInfo(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchStorageVersionMigrationValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchStorageVersionMigrationAsync(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
        Call localVarCall = this.patchStorageVersionMigrationValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchStorageVersionMigrationRequest patchStorageVersionMigration(String name, V1Patch body) {
        return new APIpatchStorageVersionMigrationRequest(name, body);
    }

    private Call patchStorageVersionMigrationStatusCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1Patch localVarPostBody = body;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call patchStorageVersionMigrationStatusValidateBeforeCall(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling patchStorageVersionMigrationStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling patchStorageVersionMigrationStatus(Async)");
        }
        return this.patchStorageVersionMigrationStatusCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
    }

    private ApiResponse<V1alpha1StorageVersionMigration> patchStorageVersionMigrationStatusWithHttpInfo(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force) throws ApiException {
        Call localVarCall = this.patchStorageVersionMigrationStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, null);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call patchStorageVersionMigrationStatusAsync(String name, V1Patch body, String pretty, String dryRun, String fieldManager, String fieldValidation, Boolean force, ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
        Call localVarCall = this.patchStorageVersionMigrationStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, force, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIpatchStorageVersionMigrationStatusRequest patchStorageVersionMigrationStatus(String name, V1Patch body) {
        return new APIpatchStorageVersionMigrationStatusRequest(name, body);
    }

    private Call readStorageVersionMigrationCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readStorageVersionMigrationValidateBeforeCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readStorageVersionMigration(Async)");
        }
        return this.readStorageVersionMigrationCall(name, pretty, _callback);
    }

    private ApiResponse<V1alpha1StorageVersionMigration> readStorageVersionMigrationWithHttpInfo(String name, String pretty) throws ApiException {
        Call localVarCall = this.readStorageVersionMigrationValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readStorageVersionMigrationAsync(String name, String pretty, ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
        Call localVarCall = this.readStorageVersionMigrationValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadStorageVersionMigrationRequest readStorageVersionMigration(String name) {
        return new APIreadStorageVersionMigrationRequest(name);
    }

    private Call readStorageVersionMigrationStatusCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call readStorageVersionMigrationStatusValidateBeforeCall(String name, String pretty, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling readStorageVersionMigrationStatus(Async)");
        }
        return this.readStorageVersionMigrationStatusCall(name, pretty, _callback);
    }

    private ApiResponse<V1alpha1StorageVersionMigration> readStorageVersionMigrationStatusWithHttpInfo(String name, String pretty) throws ApiException {
        Call localVarCall = this.readStorageVersionMigrationStatusValidateBeforeCall(name, pretty, null);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call readStorageVersionMigrationStatusAsync(String name, String pretty, ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
        Call localVarCall = this.readStorageVersionMigrationStatusValidateBeforeCall(name, pretty, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreadStorageVersionMigrationStatusRequest readStorageVersionMigrationStatus(String name) {
        return new APIreadStorageVersionMigrationStatusRequest(name);
    }

    private Call replaceStorageVersionMigrationCall(String name, V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha1StorageVersionMigration localVarPostBody = body;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceStorageVersionMigrationValidateBeforeCall(String name, V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceStorageVersionMigration(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceStorageVersionMigration(Async)");
        }
        return this.replaceStorageVersionMigrationCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha1StorageVersionMigration> replaceStorageVersionMigrationWithHttpInfo(String name, V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceStorageVersionMigrationValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceStorageVersionMigrationAsync(String name, V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
        Call localVarCall = this.replaceStorageVersionMigrationValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceStorageVersionMigrationRequest replaceStorageVersionMigration(String name, V1alpha1StorageVersionMigration body) {
        return new APIreplaceStorageVersionMigrationRequest(name, body);
    }

    private Call replaceStorageVersionMigrationStatusCall(String name, V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        V1alpha1StorageVersionMigration localVarPostBody = body;
        String localVarPath = "/apis/storagemigration.k8s.io/v1alpha1/storageversionmigrations/{name}/status".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (pretty != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pretty", pretty));
        }
        if (dryRun != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("dryRun", dryRun));
        }
        if (fieldManager != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldManager", fieldManager));
        }
        if (fieldValidation != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("fieldValidation", fieldValidation));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json", "application/yaml", "application/vnd.kubernetes.protobuf", "application/cbor"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{"BearerToken"};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call replaceStorageVersionMigrationStatusValidateBeforeCall(String name, V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling replaceStorageVersionMigrationStatus(Async)");
        }
        if (body == null) {
            throw new ApiException("Missing the required parameter 'body' when calling replaceStorageVersionMigrationStatus(Async)");
        }
        return this.replaceStorageVersionMigrationStatusCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
    }

    private ApiResponse<V1alpha1StorageVersionMigration> replaceStorageVersionMigrationStatusWithHttpInfo(String name, V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation) throws ApiException {
        Call localVarCall = this.replaceStorageVersionMigrationStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, null);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call replaceStorageVersionMigrationStatusAsync(String name, V1alpha1StorageVersionMigration body, String pretty, String dryRun, String fieldManager, String fieldValidation, ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
        Call localVarCall = this.replaceStorageVersionMigrationStatusValidateBeforeCall(name, body, pretty, dryRun, fieldManager, fieldValidation, _callback);
        Type localVarReturnType = new TypeToken<V1alpha1StorageVersionMigration>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIreplaceStorageVersionMigrationStatusRequest replaceStorageVersionMigrationStatus(String name, V1alpha1StorageVersionMigration body) {
        return new APIreplaceStorageVersionMigrationStatusRequest(name, body);
    }

    public class APIcreateStorageVersionMigrationRequest {
        private final V1alpha1StorageVersionMigration body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIcreateStorageVersionMigrationRequest(V1alpha1StorageVersionMigration body) {
            this.body = body;
        }

        public APIcreateStorageVersionMigrationRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIcreateStorageVersionMigrationRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIcreateStorageVersionMigrationRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIcreateStorageVersionMigrationRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.createStorageVersionMigrationCall(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha1StorageVersionMigration execute() throws ApiException {
            ApiResponse<V1alpha1StorageVersionMigration> localVarResp = StoragemigrationV1alpha1Api.this.createStorageVersionMigrationWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha1StorageVersionMigration> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.createStorageVersionMigrationWithHttpInfo(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.createStorageVersionMigrationAsync(this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIdeleteCollectionStorageVersionMigrationRequest {
        private String pretty;
        private String _continue;
        private String dryRun;
        private String fieldSelector;
        private Integer gracePeriodSeconds;
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        private String labelSelector;
        private Integer limit;
        private Boolean orphanDependents;
        private String propagationPolicy;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private V1DeleteOptions body;

        private APIdeleteCollectionStorageVersionMigrationRequest() {
        }

        public APIdeleteCollectionStorageVersionMigrationRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest gracePeriodSeconds(Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest ignoreStoreReadErrorWithClusterBreakingPotential(Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest orphanDependents(Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest propagationPolicy(String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIdeleteCollectionStorageVersionMigrationRequest body(V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.deleteCollectionStorageVersionMigrationCall(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = StoragemigrationV1alpha1Api.this.deleteCollectionStorageVersionMigrationWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.deleteCollectionStorageVersionMigrationWithHttpInfo(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.deleteCollectionStorageVersionMigrationAsync(this.pretty, this._continue, this.dryRun, this.fieldSelector, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.labelSelector, this.limit, this.orphanDependents, this.propagationPolicy, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.body, _callback);
        }
    }

    public class APIdeleteStorageVersionMigrationRequest {
        private final String name;
        private String pretty;
        private String dryRun;
        private Integer gracePeriodSeconds;
        private Boolean ignoreStoreReadErrorWithClusterBreakingPotential;
        private Boolean orphanDependents;
        private String propagationPolicy;
        private V1DeleteOptions body;

        private APIdeleteStorageVersionMigrationRequest(String name) {
            this.name = name;
        }

        public APIdeleteStorageVersionMigrationRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIdeleteStorageVersionMigrationRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIdeleteStorageVersionMigrationRequest gracePeriodSeconds(Integer gracePeriodSeconds) {
            this.gracePeriodSeconds = gracePeriodSeconds;
            return this;
        }

        public APIdeleteStorageVersionMigrationRequest ignoreStoreReadErrorWithClusterBreakingPotential(Boolean ignoreStoreReadErrorWithClusterBreakingPotential) {
            this.ignoreStoreReadErrorWithClusterBreakingPotential = ignoreStoreReadErrorWithClusterBreakingPotential;
            return this;
        }

        public APIdeleteStorageVersionMigrationRequest orphanDependents(Boolean orphanDependents) {
            this.orphanDependents = orphanDependents;
            return this;
        }

        public APIdeleteStorageVersionMigrationRequest propagationPolicy(String propagationPolicy) {
            this.propagationPolicy = propagationPolicy;
            return this;
        }

        public APIdeleteStorageVersionMigrationRequest body(V1DeleteOptions body) {
            this.body = body;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.deleteStorageVersionMigrationCall(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }

        public V1Status execute() throws ApiException {
            ApiResponse<V1Status> localVarResp = StoragemigrationV1alpha1Api.this.deleteStorageVersionMigrationWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
            return localVarResp.getData();
        }

        public ApiResponse<V1Status> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.deleteStorageVersionMigrationWithHttpInfo(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body);
        }

        public Call executeAsync(ApiCallback<V1Status> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.deleteStorageVersionMigrationAsync(this.name, this.pretty, this.dryRun, this.gracePeriodSeconds, this.ignoreStoreReadErrorWithClusterBreakingPotential, this.orphanDependents, this.propagationPolicy, this.body, _callback);
        }
    }

    public class APIgetAPIResourcesRequest {
        private APIgetAPIResourcesRequest() {
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.getAPIResourcesCall(_callback);
        }

        public V1APIResourceList execute() throws ApiException {
            ApiResponse<V1APIResourceList> localVarResp = StoragemigrationV1alpha1Api.this.getAPIResourcesWithHttpInfo();
            return localVarResp.getData();
        }

        public ApiResponse<V1APIResourceList> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.getAPIResourcesWithHttpInfo();
        }

        public Call executeAsync(ApiCallback<V1APIResourceList> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.getAPIResourcesAsync(_callback);
        }
    }

    public class APIlistStorageVersionMigrationRequest {
        private String pretty;
        private Boolean allowWatchBookmarks;
        private String _continue;
        private String fieldSelector;
        private String labelSelector;
        private Integer limit;
        private String resourceVersion;
        private String resourceVersionMatch;
        private Boolean sendInitialEvents;
        private Integer timeoutSeconds;
        private Boolean watch;

        private APIlistStorageVersionMigrationRequest() {
        }

        public APIlistStorageVersionMigrationRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIlistStorageVersionMigrationRequest allowWatchBookmarks(Boolean allowWatchBookmarks) {
            this.allowWatchBookmarks = allowWatchBookmarks;
            return this;
        }

        public APIlistStorageVersionMigrationRequest _continue(String _continue) {
            this._continue = _continue;
            return this;
        }

        public APIlistStorageVersionMigrationRequest fieldSelector(String fieldSelector) {
            this.fieldSelector = fieldSelector;
            return this;
        }

        public APIlistStorageVersionMigrationRequest labelSelector(String labelSelector) {
            this.labelSelector = labelSelector;
            return this;
        }

        public APIlistStorageVersionMigrationRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public APIlistStorageVersionMigrationRequest resourceVersion(String resourceVersion) {
            this.resourceVersion = resourceVersion;
            return this;
        }

        public APIlistStorageVersionMigrationRequest resourceVersionMatch(String resourceVersionMatch) {
            this.resourceVersionMatch = resourceVersionMatch;
            return this;
        }

        public APIlistStorageVersionMigrationRequest sendInitialEvents(Boolean sendInitialEvents) {
            this.sendInitialEvents = sendInitialEvents;
            return this;
        }

        public APIlistStorageVersionMigrationRequest timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public APIlistStorageVersionMigrationRequest watch(Boolean watch) {
            this.watch = watch;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.listStorageVersionMigrationCall(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }

        public V1alpha1StorageVersionMigrationList execute() throws ApiException {
            ApiResponse<V1alpha1StorageVersionMigrationList> localVarResp = StoragemigrationV1alpha1Api.this.listStorageVersionMigrationWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha1StorageVersionMigrationList> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.listStorageVersionMigrationWithHttpInfo(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch);
        }

        public Call executeAsync(ApiCallback<V1alpha1StorageVersionMigrationList> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.listStorageVersionMigrationAsync(this.pretty, this.allowWatchBookmarks, this._continue, this.fieldSelector, this.labelSelector, this.limit, this.resourceVersion, this.resourceVersionMatch, this.sendInitialEvents, this.timeoutSeconds, this.watch, _callback);
        }
    }

    public class APIpatchStorageVersionMigrationRequest {
        private final String name;
        private final V1Patch body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private Boolean force;

        private APIpatchStorageVersionMigrationRequest(String name, V1Patch body) {
            this.name = name;
            this.body = body;
        }

        public APIpatchStorageVersionMigrationRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchStorageVersionMigrationRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchStorageVersionMigrationRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchStorageVersionMigrationRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchStorageVersionMigrationRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.patchStorageVersionMigrationCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1alpha1StorageVersionMigration execute() throws ApiException {
            ApiResponse<V1alpha1StorageVersionMigration> localVarResp = StoragemigrationV1alpha1Api.this.patchStorageVersionMigrationWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha1StorageVersionMigration> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.patchStorageVersionMigrationWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.patchStorageVersionMigrationAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIpatchStorageVersionMigrationStatusRequest {
        private final String name;
        private final V1Patch body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;
        private Boolean force;

        private APIpatchStorageVersionMigrationStatusRequest(String name, V1Patch body) {
            this.name = name;
            this.body = body;
        }

        public APIpatchStorageVersionMigrationStatusRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIpatchStorageVersionMigrationStatusRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIpatchStorageVersionMigrationStatusRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIpatchStorageVersionMigrationStatusRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public APIpatchStorageVersionMigrationStatusRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.patchStorageVersionMigrationStatusCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }

        public V1alpha1StorageVersionMigration execute() throws ApiException {
            ApiResponse<V1alpha1StorageVersionMigration> localVarResp = StoragemigrationV1alpha1Api.this.patchStorageVersionMigrationStatusWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha1StorageVersionMigration> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.patchStorageVersionMigrationStatusWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force);
        }

        public Call executeAsync(ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.patchStorageVersionMigrationStatusAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, this.force, _callback);
        }
    }

    public class APIreadStorageVersionMigrationRequest {
        private final String name;
        private String pretty;

        private APIreadStorageVersionMigrationRequest(String name) {
            this.name = name;
        }

        public APIreadStorageVersionMigrationRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.readStorageVersionMigrationCall(this.name, this.pretty, _callback);
        }

        public V1alpha1StorageVersionMigration execute() throws ApiException {
            ApiResponse<V1alpha1StorageVersionMigration> localVarResp = StoragemigrationV1alpha1Api.this.readStorageVersionMigrationWithHttpInfo(this.name, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha1StorageVersionMigration> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.readStorageVersionMigrationWithHttpInfo(this.name, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.readStorageVersionMigrationAsync(this.name, this.pretty, _callback);
        }
    }

    public class APIreadStorageVersionMigrationStatusRequest {
        private final String name;
        private String pretty;

        private APIreadStorageVersionMigrationStatusRequest(String name) {
            this.name = name;
        }

        public APIreadStorageVersionMigrationStatusRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.readStorageVersionMigrationStatusCall(this.name, this.pretty, _callback);
        }

        public V1alpha1StorageVersionMigration execute() throws ApiException {
            ApiResponse<V1alpha1StorageVersionMigration> localVarResp = StoragemigrationV1alpha1Api.this.readStorageVersionMigrationStatusWithHttpInfo(this.name, this.pretty);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha1StorageVersionMigration> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.readStorageVersionMigrationStatusWithHttpInfo(this.name, this.pretty);
        }

        public Call executeAsync(ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.readStorageVersionMigrationStatusAsync(this.name, this.pretty, _callback);
        }
    }

    public class APIreplaceStorageVersionMigrationRequest {
        private final String name;
        private final V1alpha1StorageVersionMigration body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIreplaceStorageVersionMigrationRequest(String name, V1alpha1StorageVersionMigration body) {
            this.name = name;
            this.body = body;
        }

        public APIreplaceStorageVersionMigrationRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceStorageVersionMigrationRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceStorageVersionMigrationRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceStorageVersionMigrationRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.replaceStorageVersionMigrationCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha1StorageVersionMigration execute() throws ApiException {
            ApiResponse<V1alpha1StorageVersionMigration> localVarResp = StoragemigrationV1alpha1Api.this.replaceStorageVersionMigrationWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha1StorageVersionMigration> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.replaceStorageVersionMigrationWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.replaceStorageVersionMigrationAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }

    public class APIreplaceStorageVersionMigrationStatusRequest {
        private final String name;
        private final V1alpha1StorageVersionMigration body;
        private String pretty;
        private String dryRun;
        private String fieldManager;
        private String fieldValidation;

        private APIreplaceStorageVersionMigrationStatusRequest(String name, V1alpha1StorageVersionMigration body) {
            this.name = name;
            this.body = body;
        }

        public APIreplaceStorageVersionMigrationStatusRequest pretty(String pretty) {
            this.pretty = pretty;
            return this;
        }

        public APIreplaceStorageVersionMigrationStatusRequest dryRun(String dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public APIreplaceStorageVersionMigrationStatusRequest fieldManager(String fieldManager) {
            this.fieldManager = fieldManager;
            return this;
        }

        public APIreplaceStorageVersionMigrationStatusRequest fieldValidation(String fieldValidation) {
            this.fieldValidation = fieldValidation;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.replaceStorageVersionMigrationStatusCall(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }

        public V1alpha1StorageVersionMigration execute() throws ApiException {
            ApiResponse<V1alpha1StorageVersionMigration> localVarResp = StoragemigrationV1alpha1Api.this.replaceStorageVersionMigrationStatusWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
            return localVarResp.getData();
        }

        public ApiResponse<V1alpha1StorageVersionMigration> executeWithHttpInfo() throws ApiException {
            return StoragemigrationV1alpha1Api.this.replaceStorageVersionMigrationStatusWithHttpInfo(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation);
        }

        public Call executeAsync(ApiCallback<V1alpha1StorageVersionMigration> _callback) throws ApiException {
            return StoragemigrationV1alpha1Api.this.replaceStorageVersionMigrationStatusAsync(this.name, this.body, this.pretty, this.dryRun, this.fieldManager, this.fieldValidation, _callback);
        }
    }
}

