/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1PortStatus;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1LoadBalancerIngress {
    public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
    @SerializedName(value="hostname")
    private String hostname;
    public static final String SERIALIZED_NAME_IP = "ip";
    @SerializedName(value="ip")
    private String ip;
    public static final String SERIALIZED_NAME_IP_MODE = "ipMode";
    @SerializedName(value="ipMode")
    private String ipMode;
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<V1PortStatus> ports;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1LoadBalancerIngress hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public V1LoadBalancerIngress ip(String ip) {
        this.ip = ip;
        return this;
    }

    @Nullable
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public V1LoadBalancerIngress ipMode(String ipMode) {
        this.ipMode = ipMode;
        return this;
    }

    @Nullable
    public String getIpMode() {
        return this.ipMode;
    }

    public void setIpMode(String ipMode) {
        this.ipMode = ipMode;
    }

    public V1LoadBalancerIngress ports(List<V1PortStatus> ports) {
        this.ports = ports;
        return this;
    }

    public V1LoadBalancerIngress addPortsItem(V1PortStatus portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1PortStatus>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    public List<V1PortStatus> getPorts() {
        return this.ports;
    }

    public void setPorts(List<V1PortStatus> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LoadBalancerIngress v1LoadBalancerIngress = (V1LoadBalancerIngress)o;
        return Objects.equals(this.hostname, v1LoadBalancerIngress.hostname) && Objects.equals(this.ip, v1LoadBalancerIngress.ip) && Objects.equals(this.ipMode, v1LoadBalancerIngress.ipMode) && Objects.equals(this.ports, v1LoadBalancerIngress.ports);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip, this.ipMode, this.ports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LoadBalancerIngress {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    ipMode: ").append(this.toIndentedString(this.ipMode)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayports;
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1LoadBalancerIngress is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1LoadBalancerIngress` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTNAME) != null && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTNAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTNAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IP) != null && !jsonObj.get(SERIALIZED_NAME_IP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ip` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IP_MODE) != null && !jsonObj.get(SERIALIZED_NAME_IP_MODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IP_MODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ipMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IP_MODE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTS) != null && !jsonObj.get(SERIALIZED_NAME_PORTS).isJsonNull() && (jsonArrayports = jsonObj.getAsJsonArray(SERIALIZED_NAME_PORTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PORTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ports` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTS).toString()));
            }
            for (int i = 0; i < jsonArrayports.size(); ++i) {
                V1PortStatus.validateJsonObject(jsonArrayports.get(i).getAsJsonObject());
            }
        }
    }

    public static V1LoadBalancerIngress fromJson(String jsonString) throws IOException {
        return (V1LoadBalancerIngress)JSON.getGson().fromJson(jsonString, V1LoadBalancerIngress.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_HOSTNAME);
        openapiFields.add(SERIALIZED_NAME_IP);
        openapiFields.add(SERIALIZED_NAME_IP_MODE);
        openapiFields.add(SERIALIZED_NAME_PORTS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1LoadBalancerIngress.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1LoadBalancerIngress.class));
            return new TypeAdapter<V1LoadBalancerIngress>(){

                public void write(JsonWriter out, V1LoadBalancerIngress value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1LoadBalancerIngress read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1LoadBalancerIngress.validateJsonObject(jsonObj);
                    return (V1LoadBalancerIngress)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

