/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1beta1APIServiceSpec;
import io.kubernetes.client.models.V1beta1APIServiceStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="APIService represents a server for a particular GroupVersion. Name must be \"version.group\".")
public class V1beta1APIService {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="spec")
    private V1beta1APIServiceSpec spec = null;
    @SerializedName(value="status")
    private V1beta1APIServiceStatus status = null;

    public V1beta1APIService apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1beta1APIService kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1beta1APIService metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1beta1APIService spec(V1beta1APIServiceSpec spec) {
        this.spec = spec;
        return this;
    }

    @ApiModelProperty(value="Spec contains information for locating and communicating with a server")
    public V1beta1APIServiceSpec getSpec() {
        return this.spec;
    }

    public void setSpec(V1beta1APIServiceSpec spec) {
        this.spec = spec;
    }

    public V1beta1APIService status(V1beta1APIServiceStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="Status contains derived information about an API server")
    public V1beta1APIServiceStatus getStatus() {
        return this.status;
    }

    public void setStatus(V1beta1APIServiceStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1APIService v1beta1APIService = (V1beta1APIService)o;
        return Objects.equals(this.apiVersion, v1beta1APIService.apiVersion) && Objects.equals(this.kind, v1beta1APIService.kind) && Objects.equals(this.metadata, v1beta1APIService.metadata) && Objects.equals(this.spec, v1beta1APIService.spec) && Objects.equals(this.status, v1beta1APIService.status);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1APIService {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

