/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1TokenReviewStatus;
import io.kubernetes.client.openapi.models.V1TokenReviewStatusFluent;
import io.kubernetes.client.openapi.models.V1UserInfo;
import io.kubernetes.client.openapi.models.V1UserInfoBuilder;
import io.kubernetes.client.openapi.models.V1UserInfoFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class V1TokenReviewStatusFluentImpl<A extends V1TokenReviewStatusFluent<A>>
extends BaseFluent<A>
implements V1TokenReviewStatusFluent<A> {
    private List<String> audiences;
    private Boolean authenticated;
    private String error;
    private V1UserInfoBuilder user;

    public V1TokenReviewStatusFluentImpl() {
    }

    public V1TokenReviewStatusFluentImpl(V1TokenReviewStatus instance) {
        this.withAudiences(instance.getAudiences());
        this.withAuthenticated(instance.getAuthenticated());
        this.withError(instance.getError());
        this.withUser(instance.getUser());
    }

    @Override
    public A addToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAudiences(int index, String item) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        this.audiences.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAudiences(String ... items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAudiences(Collection<String> items) {
        if (this.audiences == null) {
            this.audiences = new ArrayList<String>();
        }
        for (String item : items) {
            this.audiences.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAudiences(String ... items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAudiences(Collection<String> items) {
        for (String item : items) {
            if (this.audiences == null) continue;
            this.audiences.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAudiences() {
        return this.audiences;
    }

    @Override
    public String getAudience(int index) {
        return this.audiences.get(index);
    }

    @Override
    public String getFirstAudience() {
        return this.audiences.get(0);
    }

    @Override
    public String getLastAudience() {
        return this.audiences.get(this.audiences.size() - 1);
    }

    @Override
    public String getMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAudience(Predicate<String> predicate) {
        for (String item : this.audiences) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAudiences(List<String> audiences) {
        if (this.audiences != null) {
            this._visitables.get("audiences").removeAll(this.audiences);
        }
        if (audiences != null) {
            this.audiences = new ArrayList<String>();
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        } else {
            this.audiences = null;
        }
        return (A)this;
    }

    @Override
    public A withAudiences(String ... audiences) {
        if (this.audiences != null) {
            this.audiences.clear();
        }
        if (audiences != null) {
            for (String item : audiences) {
                this.addToAudiences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAudiences() {
        return this.audiences != null && !this.audiences.isEmpty();
    }

    @Override
    public A addNewAudience(String arg1) {
        return this.addToAudiences(new String(arg1));
    }

    @Override
    public A addNewAudience(StringBuilder arg1) {
        return this.addToAudiences(new String(arg1));
    }

    @Override
    public A addNewAudience(StringBuffer arg1) {
        return this.addToAudiences(new String(arg1));
    }

    @Override
    public Boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public A withAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return (A)this;
    }

    @Override
    public Boolean hasAuthenticated() {
        return this.authenticated != null;
    }

    @Override
    public A withNewAuthenticated(String arg1) {
        return this.withAuthenticated(new Boolean(arg1));
    }

    @Override
    public A withNewAuthenticated(boolean arg1) {
        return this.withAuthenticated(new Boolean(arg1));
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public A withError(String error) {
        this.error = error;
        return (A)this;
    }

    @Override
    public Boolean hasError() {
        return this.error != null;
    }

    @Override
    public A withNewError(String arg1) {
        return this.withError(new String(arg1));
    }

    @Override
    public A withNewError(StringBuilder arg1) {
        return this.withError(new String(arg1));
    }

    @Override
    public A withNewError(StringBuffer arg1) {
        return this.withError(new String(arg1));
    }

    @Override
    @Deprecated
    public V1UserInfo getUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public V1UserInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public A withUser(V1UserInfo user) {
        this._visitables.get("user").remove(this.user);
        if (user != null) {
            this.user = new V1UserInfoBuilder(user);
            this._visitables.get("user").add(this.user);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public V1TokenReviewStatusFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public V1TokenReviewStatusFluent.UserNested<A> withNewUserLike(V1UserInfo item) {
        return new UserNestedImpl(item);
    }

    @Override
    public V1TokenReviewStatusFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    @Override
    public V1TokenReviewStatusFluent.UserNested<A> editOrNewUser() {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : new V1UserInfoBuilder().build());
    }

    @Override
    public V1TokenReviewStatusFluent.UserNested<A> editOrNewUserLike(V1UserInfo item) {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TokenReviewStatusFluentImpl that = (V1TokenReviewStatusFluentImpl)o;
        if (this.audiences != null ? !this.audiences.equals(that.audiences) : that.audiences != null) {
            return false;
        }
        if (this.authenticated != null ? !this.authenticated.equals(that.authenticated) : that.authenticated != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public int hashCode() {
        return Objects.hash(this.audiences, this.authenticated, this.error, this.user, super.hashCode());
    }

    public class UserNestedImpl<N>
    extends V1UserInfoFluentImpl<V1TokenReviewStatusFluent.UserNested<N>>
    implements V1TokenReviewStatusFluent.UserNested<N>,
    Nested<N> {
        private final V1UserInfoBuilder builder;

        UserNestedImpl(V1UserInfo item) {
            this.builder = new V1UserInfoBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new V1UserInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1TokenReviewStatusFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }
}

