/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.collections;

import io.ktor.util.KtorExperimentalAPI;
import io.ktor.util.collections.internal.SharedList;
import io.ktor.utils.io.NativeUtilsJvmKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.markers.KMutableList;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;

@KtorExperimentalAPI
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\f\n\u0002\u0010)\n\u0002\b\u0002\n\u0002\u0010+\n\u0002\b\u000e\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001d\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\n2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0016\u0010\u0019\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\nH\u0002J\b\u0010\u001d\u001a\u00020\u0016H\u0016J\u0016\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u001f\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0016\u0010 \u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\nH\u0096\u0002\u00a2\u0006\u0002\u0010!J\u0012\u0010\"\u001a\u00020\u00162\b\b\u0002\u0010#\u001a\u00020\nH\u0002J\u0015\u0010$\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020\u0013H\u0016J\u000f\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(H\u0096\u0002J\u0015\u0010)\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010%J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+H\u0016J\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+2\u0006\u0010\u0017\u001a\u00020\nH\u0016J\u0015\u0010,\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010-\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u0015\u0010.\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010!J\u0018\u0010/\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\n2\u0006\u00100\u001a\u00020\nH\u0002J\u0016\u00101\u001a\u00020\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u001bH\u0016J\u001e\u00102\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u00103J\u001e\u00104\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\nH\u0016J\u0010\u00107\u001a\u00020\u00162\u0006\u00108\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8V@RX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u00069"}, d2={"Lio/ktor/util/collections/ConcurrentList;", "T", "", "()V", "data", "Lio/ktor/util/collections/internal/SharedList;", "lock", "", "Lkotlinx/atomicfu/locks/SynchronizedObject;", "<set-?>", "", "size", "getSize", "()I", "setSize", "(I)V", "size$delegate", "Lkotlin/properties/ReadWriteProperty;", "add", "", "element", "(Ljava/lang/Object;)Z", "", "index", "(ILjava/lang/Object;)V", "addAll", "elements", "", "checkIndex", "clear", "contains", "containsAll", "get", "(I)Ljava/lang/Object;", "increaseCapacity", "targetCapacity", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "removeAll", "removeAt", "reserve", "gapSize", "retainAll", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "subList", "fromIndex", "toIndex", "sweep", "firstNull", "ktor-utils"})
public final class ConcurrentList<T>
implements List<T>,
KMutableList {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private SharedList<T> data = new SharedList(32);
    @NotNull
    private final ReadWriteProperty size$delegate;
    private final Object lock;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(ConcurrentList.class, "size", "getSize()I", 0))};
    }

    public int getSize() {
        return ((Number)this.size$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    private void setSize(int n) {
        this.size$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)n);
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) >= 0;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$all$iv = elements;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (this.contains(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(int index) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            if (index >= this.size()) {
                throw (Throwable)new NoSuchElementException();
            }
            T t = this.data.get(index);
            Intrinsics.checkNotNull(t);
            T t2 = t;
            return t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int indexOf(Object element) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            int n = 0;
            int n2 = this.size();
            while (n < n2) {
                void index;
                if (Intrinsics.areEqual(this.data.get((int)index), (Object)element)) {
                    return (int)index;
                }
                ++index;
            }
            return -1;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int lastIndexOf(Object element) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            int n = this.size() - 1;
            boolean bl5 = false;
            while (n >= 0) {
                void index;
                if (Intrinsics.areEqual(this.data.get((int)index), (Object)element)) {
                    return (int)index;
                }
                --index;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T element) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            if (this.size() >= this.data.size()) {
                ConcurrentList.increaseCapacity$default(this, 0, 1, null);
            }
            this.data.set(this.size(), element);
            ConcurrentList concurrentList = this;
            concurrentList.setSize(concurrentList.size() + 1);
            boolean bl5 = true;
            return bl5;
        }
    }

    @Override
    public void add(int index, T element) {
        this.reserve(index, 1);
        this.data.set(index, element);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.reserve(index, elements.size());
        int current = index;
        for (T item : elements) {
            this.data.set(current, item);
            ++current;
        }
        Collection<T> collection = elements;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$all$iv = elements;
        boolean $i$f$all = false;
        if (!((Collection)$this$all$iv).isEmpty()) {
            Iterator iterator2 = $this$all$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator2.next();
                boolean bl = false;
                if (this.add((T)it)) continue;
                break;
            }
        }
        Collection<T> collection = elements;
        boolean bl = false;
        return !collection.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            this.data = new SharedList(32);
            this.setSize(0);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        String string = "Common concurrent list doesn't support iterator.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        String string = "Common concurrent list doesn't support iterator.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        String string = "Common concurrent list doesn't support iterator.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        String string = "Common concurrent list doesn't support slicing.";
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object element) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            int index;
            block4: {
                boolean bl4 = false;
                index = this.indexOf(element);
                if (index >= 0) break block4;
                boolean bl5 = false;
                return bl5;
            }
            this.remove(index);
            boolean bl6 = true;
            return bl6;
        }
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        boolean result = false;
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            boolean bl = false;
            result = this.remove(it) || result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T removeAt(int index) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            this.checkIndex(index);
            T old = this.data.get(index);
            this.data.set(index, (Object)null);
            this.sweep(index);
            T t = old;
            Intrinsics.checkNotNull(t);
            T t2 = t;
            return t2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            boolean changed = false;
            int firstNull = -1;
            int n = 0;
            int n2 = this.size();
            while (n < n2) {
                T item;
                void index;
                Intrinsics.checkNotNull(this.data.get((int)index));
                if (!elements.contains(item)) {
                    changed = true;
                    this.data.set((int)index, (Object)null);
                    if (firstNull < 0) {
                        firstNull = index;
                    }
                }
                ++index;
            }
            if (changed) {
                this.sweep(firstNull);
            }
            boolean bl5 = changed;
            return bl5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T set(int index, T element) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        synchronized (object) {
            boolean bl4 = false;
            this.checkIndex(index);
            T old = this.data.get(index);
            this.data.set(index, element);
            T t = old;
            if (t == null) {
                t = element;
            }
            T t2 = t;
            return t2;
        }
    }

    private final void checkIndex(int index) {
        if (index >= this.size() || index < 0) {
            throw (Throwable)new IndexOutOfBoundsException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void increaseCapacity(int targetCapacity) {
        SharedList<T> newData = new SharedList<T>(targetCapacity);
        int n = 0;
        int n2 = targetCapacity;
        while (n < n2) {
            void index;
            newData.set((int)index, this.data.get((int)index));
            ++index;
        }
        this.data = newData;
    }

    static /* synthetic */ void increaseCapacity$default(ConcurrentList concurrentList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = concurrentList.data.size() * 2;
        }
        concurrentList.increaseCapacity(n);
    }

    private final void sweep(int firstNull) {
        int index;
        int writePosition = firstNull;
        int n = writePosition + 1;
        int n2 = this.size();
        while (n < n2) {
            if (this.data.get(index) != null) {
                this.data.set(writePosition, this.data.get(index));
                ++writePosition;
            }
            ++index;
        }
        n2 = this.size();
        for (index = writePosition; index < n2; ++index) {
            this.data.set(index, (Object)null);
        }
        this.setSize(writePosition);
    }

    /*
     * WARNING - void declaration
     */
    private final void reserve(int index, int gapSize) {
        if (gapSize + this.size() >= this.data.size()) {
            this.increaseCapacity(gapSize + this.size());
        }
        for (int readPosition = this.size(); readPosition >= index; --readPosition) {
            this.data.set(readPosition + gapSize, this.data.get(readPosition));
        }
        int n = index;
        int n2 = index + gapSize;
        while (n < n2) {
            void current;
            this.data.set((int)current, (Object)null);
            ++current;
        }
    }

    public ConcurrentList() {
        Integer value$iv = 0;
        boolean $i$f$shared = false;
        this.size$delegate = (ReadWriteProperty)new ReadWriteProperty<Object, Integer>((Object)value$iv){
            private Integer value;
            final /* synthetic */ Object $value;
            {
                this.$value = $captured_local_variable$0;
                this.value = $captured_local_variable$0;
            }

            public Integer getValue(@NotNull Object thisRef, @NotNull KProperty<?> property) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                return this.value;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void setValue(@NotNull Object thisRef, @NotNull KProperty property, Object value) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                this.value = value;
            }
        };
        this.lock = new Object();
        NativeUtilsJvmKt.makeShared((Object)this);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }
}

