/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.tomcat;

import io.ktor.application.Application;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineJvmKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import io.ktor.server.servlet.DefaultServletUpgrade;
import io.ktor.server.servlet.KtorServlet;
import io.ktor.server.servlet.ServletUpgrade;
import io.ktor.server.tomcat.TomcatApplicationEngine;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import org.apache.catalina.Context;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;
import org.apache.tomcat.util.net.openssl.OpenSSLImplementation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002*\u0001\u0018\u0018\u0000 %2\u00020(:\u0002%&B(\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR#\u0010$\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\u00a8\u0006'"}, d2={"Lio/ktor/server/tomcat/TomcatApplicationEngine;", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "environment", "Lkotlin/Function1;", "Lio/ktor/server/tomcat/TomcatApplicationEngine$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "configure", "<init>", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "", "wait", "start", "(Z)Lio/ktor/server/tomcat/TomcatApplicationEngine;", "", "gracePeriodMillis", "timeoutMillis", "stop", "(JJ)V", "Lkotlinx/coroutines/CompletableJob;", "cancellationDeferred", "Lkotlinx/coroutines/CompletableJob;", "configuration", "Lio/ktor/server/tomcat/TomcatApplicationEngine$Configuration;", "io/ktor/server/tomcat/TomcatApplicationEngine$ktorServlet$1", "ktorServlet", "Lio/ktor/server/tomcat/TomcatApplicationEngine$ktorServlet$1;", "Lorg/apache/catalina/startup/Tomcat;", "server", "Lorg/apache/catalina/startup/Tomcat;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "tempDirectory$delegate", "Lkotlin/Lazy;", "getTempDirectory", "()Ljava/nio/file/Path;", "tempDirectory", "Companion", "Configuration", "ktor-server-tomcat", "Lio/ktor/server/engine/BaseApplicationEngine;"})
public final class TomcatApplicationEngine
extends BaseApplicationEngine {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final Lazy tempDirectory$delegate;
    @Nullable
    private CompletableJob cancellationDeferred;
    @NotNull
    private final ktorServlet.1 ktorServlet;
    @NotNull
    private final Tomcat server;
    @NotNull
    private volatile /* synthetic */ int stopped;
    private static final /* synthetic */ AtomicIntegerFieldUpdater stopped$FU;
    @NotNull
    private static final List<String> nativeNames = CollectionsKt.listOf((Object)"netty-tcnative-windows-x86_64");

    /*
     * WARNING - void declaration
     */
    public TomcatApplicationEngine(@NotNull ApplicationEngineEnvironment environment, @NotNull Function1<? super Configuration, Unit> configure) {
        Connector connector;
        Service service;
        void $this$server_u24lambda_u2d6;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        super(environment, null, 2, null);
        Configuration configuration = new Configuration();
        configure.invoke((Object)configuration);
        this.configuration = configuration;
        this.tempDirectory$delegate = LazyKt.lazy((Function0)tempDirectory.2.INSTANCE);
        this.ktorServlet = new KtorServlet(this, environment){
            final /* synthetic */ TomcatApplicationEngine this$0;
            final /* synthetic */ ApplicationEngineEnvironment $environment;
            {
                this.this$0 = $receiver;
                this.$environment = $environment;
            }

            @NotNull
            protected EnginePipeline getEnginePipeline() {
                return this.this$0.getPipeline();
            }

            @NotNull
            protected Application getApplication() {
                return this.this$0.getApplication();
            }

            @NotNull
            protected ServletUpgrade getUpgrade() {
                return (ServletUpgrade)DefaultServletUpgrade.INSTANCE;
            }

            @NotNull
            protected Logger getLogger() {
                return this.this$0.getEnvironment().getLog();
            }

            @NotNull
            public CoroutineContext getCoroutineContext() {
                return super.getCoroutineContext().plus(this.$environment.getParentCoroutineContext());
            }
        };
        Configuration configuration2 = configuration = new Tomcat();
        TomcatApplicationEngine tomcatApplicationEngine = this;
        boolean bl = false;
        this.configuration.getConfigureTomcat().invoke((Object)$this$server_u24lambda_u2d6);
        Service $this$server_u24lambda_u2d6_u24lambda_u2d3 = service = $this$server_u24lambda_u2d6.getService();
        boolean bl22 = false;
        Connector[] connectorArray = $this$server_u24lambda_u2d6_u24lambda_u2d3.findConnectors();
        Intrinsics.checkNotNullExpressionValue((Object)connectorArray, (String)"findConnectors()");
        Object $this$forEach$iv = connectorArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Connector existing = (Connector)element$iv;
            boolean bl3 = false;
            $this$server_u24lambda_u2d6_u24lambda_u2d3.removeConnector(existing);
        }
        $this$forEach$iv = environment.getConnectors();
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1;
            Connector connector2;
            Object element$iv = iterator.next();
            EngineConnectorConfig ktorConnector = (EngineConnectorConfig)element$iv;
            boolean bl4 = false;
            Connector bl3 = connector2 = new Connector();
            Service service2 = $this$server_u24lambda_u2d6_u24lambda_u2d3;
            boolean bl5 = false;
            $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setPort(ktorConnector.getPort());
            if (ktorConnector instanceof EngineSSLConnectorConfig) {
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setSecure(true);
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setScheme("https");
                if (((EngineSSLConnectorConfig)ktorConnector).getKeyStorePath() == null) {
                    throw new IllegalArgumentException("Tomcat requires keyStorePath. Make sure you're setting the property in the EngineSSLConnectorConfig class used");
                }
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setAttribute("keyAlias", (Object)((EngineSSLConnectorConfig)ktorConnector).getKeyAlias());
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setAttribute("keystorePass", (Object)new String((char[])((EngineSSLConnectorConfig)ktorConnector).getKeyStorePassword().invoke()));
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setAttribute("keyPass", (Object)new String((char[])((EngineSSLConnectorConfig)ktorConnector).getPrivateKeyPassword().invoke()));
                File file = ((EngineSSLConnectorConfig)ktorConnector).getKeyStorePath();
                Intrinsics.checkNotNull((Object)file);
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setAttribute("keystoreFile", (Object)file.getAbsolutePath());
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setAttribute("clientAuth", (Object)false);
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setAttribute("sslProtocol", (Object)"TLS");
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setAttribute("SSLEnabled", (Object)true);
                Class sslImpl = TomcatApplicationEngine.Companion.chooseSSLImplementation();
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setAttribute("sslImplementationName", (Object)sslImpl.getName());
                if (Intrinsics.areEqual((Object)sslImpl.getSimpleName(), (Object)"OpenSSLImplementation")) {
                    $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
                }
            } else {
                $this$server_u24lambda_u2d6_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.setScheme("http");
            }
            service2.addConnector(connector2);
        }
        if ($this$server_u24lambda_u2d6.getConnector() == null) {
            Service service3;
            void v1 = $this$server_u24lambda_u2d6;
            Object[] objectArray = $this$server_u24lambda_u2d6.getService().findConnectors();
            Connector connector3 = service = objectArray == null ? null : (Connector)ArraysKt.firstOrNull((Object[])objectArray);
            if (service == null) {
                void $this$server_u24lambda_u2d6_u24lambda_u2d4;
                Connector bl22 = connector = new Connector();
                void var20_29 = v1;
                boolean bl6 = false;
                $this$server_u24lambda_u2d6_u24lambda_u2d4.setPort(80);
                v1 = var20_29;
                service3 = connector;
            } else {
                service3 = service;
            }
            v1.setConnector((Connector)service3);
        }
        $this$server_u24lambda_u2d6.setBaseDir(((Object)this.getTempDirectory()).toString());
        Context ctx = $this$server_u24lambda_u2d6.addContext("", ((Object)this.getTempDirectory()).toString());
        Connector $this$server_u24lambda_u2d6_u24lambda_u2d5 = connector = Tomcat.addServlet((Context)ctx, (String)"ktor-servlet", (Servlet)((Servlet)this.ktorServlet));
        boolean bl7 = false;
        $this$server_u24lambda_u2d6_u24lambda_u2d5.addMapping("/*");
        $this$server_u24lambda_u2d6_u24lambda_u2d5.setAsyncSupported(true);
        $this$server_u24lambda_u2d6_u24lambda_u2d5.setMultipartConfigElement(new MultipartConfigElement(""));
        tomcatApplicationEngine.server = configuration;
        this.stopped = 0;
    }

    private final Path getTempDirectory() {
        Lazy lazy = this.tempDirectory$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public TomcatApplicationEngine start(boolean wait) {
        this.getEnvironment().start();
        this.server.start();
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)((ApplicationEngine)this));
        if (wait) {
            this.server.getServer().await();
            ApplicationEngineJvmKt.stop((ApplicationEngine)((ApplicationEngine)this), (long)1L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        return this;
    }

    public void stop(long gracePeriodMillis, long timeoutMillis) {
        if (stopped$FU.compareAndSet(this, 0, 1)) {
            CompletableJob completableJob = this.cancellationDeferred;
            if (completableJob != null) {
                completableJob.complete();
            }
            this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
            this.server.stop();
            this.getEnvironment().stop();
            this.server.destroy();
            File file = this.getTempDirectory().toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"tempDirectory.toFile()");
            FilesKt.deleteRecursively((File)file);
        }
    }

    static {
        stopped$FU = AtomicIntegerFieldUpdater.newUpdater(TomcatApplicationEngine.class, "stopped");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/server/tomcat/TomcatApplicationEngine$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "()V", "configureTomcat", "Lkotlin/Function1;", "Lorg/apache/catalina/startup/Tomcat;", "", "Lkotlin/ExtensionFunctionType;", "getConfigureTomcat", "()Lkotlin/jvm/functions/Function1;", "setConfigureTomcat", "(Lkotlin/jvm/functions/Function1;)V", "ktor-server-tomcat"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        @NotNull
        private Function1<? super Tomcat, Unit> configureTomcat = configureTomcat.1.INSTANCE;

        @NotNull
        public final Function1<Tomcat, Unit> getConfigureTomcat() {
            return this.configureTomcat;
        }

        public final void setConfigureTomcat(@NotNull Function1<? super Tomcat, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.configureTomcat = function1;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ktor/server/tomcat/TomcatApplicationEngine$Companion;", "", "()V", "nativeNames", "", "", "chooseSSLImplementation", "Ljava/lang/Class;", "Lorg/apache/tomcat/util/net/SSLImplementation;", "tryLoadLibrary", "", "libraryName", "ktor-server-tomcat"})
    public static final class Companion {
        private Companion() {
        }

        private final Class<? extends SSLImplementation> chooseSSLImplementation() {
            Class<JSSEImplementation> clazz;
            try {
                Class<JSSEImplementation> clazz2;
                Object v0;
                block5: {
                    Iterable $this$firstOrNull$iv = nativeNames;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!Companion.tryLoadLibrary(it)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                String nativeName = v0;
                if (nativeName != null) {
                    Library.initialize((String)nativeName);
                    SSL.initialize(null);
                    SSL.freeSSL((long)SSL.newSSL((long)SSL.SSL_PROTOCOL_ALL, (boolean)true));
                    clazz2 = OpenSSLImplementation.class;
                } else {
                    clazz2 = JSSEImplementation.class;
                }
                clazz = clazz2;
            }
            catch (Throwable t) {
                clazz = JSSEImplementation.class;
            }
            return clazz;
        }

        private final boolean tryLoadLibrary(String libraryName) {
            boolean bl;
            try {
                System.loadLibrary(libraryName);
                bl = true;
            }
            catch (Throwable t) {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

