/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.testing;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpMethod;
import io.ktor.http.cio.RequestResponseBuilder;
import io.ktor.utils.io.core.ByteBuffersKt;
import io.ktor.utils.io.core.ByteReadPacket;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 .2\u00020\u0001:\u0003-./B7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bBF\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0017\u0010\r\u001a\u0013\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\u0002\b\u0011\u00a2\u0006\u0002\u0010\u0012J\u0006\u0010*\u001a\u00020\u0010J\u0006\u0010(\u001a\u00020\u0010J\b\u0010+\u001a\u00020\u0003H\u0002J\u0006\u0010,\u001a\u00020\u0010R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u000e\u0010!\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator;", "", "url", "", "host", "port", "", "numberConnections", "queueSize", "highPressure", "", "(Ljava/lang/String;Ljava/lang/String;IIIZ)V", "numberOfConnections", "builder", "Lkotlin/Function1;", "Lio/ktor/http/cio/RequestResponseBuilder;", "", "Lkotlin/ExtensionFunctionType;", "(Ljava/lang/String;IIIZLkotlin/jvm/functions/Function1;)V", "cancelled", "codeCounts", "", "Ljava/util/concurrent/atomic/AtomicLong;", "[Ljava/util/concurrent/atomic/AtomicLong;", "connectErrors", "count", "getHighPressure", "()Z", "getHost", "()Ljava/lang/String;", "getNumberOfConnections", "()I", "getQueueSize", "readErrors", "remote", "Ljava/net/InetSocketAddress;", "request", "Lio/ktor/utils/io/core/ByteReadPacket;", "requestByteBuffer", "Ljava/nio/ByteBuffer;", "shutdown", "writeErrors", "mainLoop", "stat", "stop", "ClientState", "Companion", "ParseState", "ktor-server-test-host"})
public final class HighLoadHttpGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String host;
    private final int numberOfConnections;
    private final int queueSize;
    private final boolean highPressure;
    @NotNull
    private final InetSocketAddress remote;
    @NotNull
    private final ByteReadPacket request;
    @NotNull
    private final ByteBuffer requestByteBuffer;
    @NotNull
    private final AtomicLong count;
    @NotNull
    private final AtomicLong[] codeCounts;
    @NotNull
    private final AtomicLong readErrors;
    @NotNull
    private final AtomicLong writeErrors;
    @NotNull
    private final AtomicLong connectErrors;
    private volatile boolean cancelled;
    private volatile boolean shutdown;
    @NotNull
    private static final byte[] HTTP11;
    private static final long HTTP11Long = 5211883372140375601L;
    private static final int HTTP1_length = 8;
    private static final int HTTP_200_SPACE_Int = 0x32303020;
    private static final int HTTP_200_R_Int = 842018829;
    private static final byte N = 10;
    private static final byte S = 32;

    /*
     * WARNING - void declaration
     */
    public HighLoadHttpGenerator(@NotNull String host, int port, int numberOfConnections, int queueSize, boolean highPressure, @NotNull Function1<? super RequestResponseBuilder, Unit> builder) {
        void $this$requestByteBuffer_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.host = host;
        this.numberOfConnections = numberOfConnections;
        this.queueSize = queueSize;
        this.highPressure = highPressure;
        this.remote = new InetSocketAddress(this.host, port);
        Object object = new RequestResponseBuilder();
        boolean bl = false;
        int n = 0;
        builder.invoke(object);
        this.request = object.build();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)this.request.getRemaining());
        Intrinsics.checkNotNull((Object)byteBuffer);
        object = byteBuffer;
        bl = false;
        n = 0;
        Object object2 = object;
        HighLoadHttpGenerator highLoadHttpGenerator = this;
        boolean bl2 = false;
        ByteBuffersKt.readFully((ByteReadPacket)this.request.copy(), (ByteBuffer)$this$requestByteBuffer_u24lambda_u2d0);
        $this$requestByteBuffer_u24lambda_u2d0.clear();
        Unit unit = Unit.INSTANCE;
        highLoadHttpGenerator.requestByteBuffer = object;
        this.count = new AtomicLong(0L);
        int n2 = 0;
        AtomicLong[] atomicLongArray = new AtomicLong[1000];
        highLoadHttpGenerator = this;
        while (n2 < 1000) {
            n = n2++;
            atomicLongArray[n] = new AtomicLong(0L);
        }
        highLoadHttpGenerator.codeCounts = atomicLongArray;
        this.readErrors = new AtomicLong();
        this.writeErrors = new AtomicLong();
        this.connectErrors = new AtomicLong();
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final int getNumberOfConnections() {
        return this.numberOfConnections;
    }

    public final int getQueueSize() {
        return this.queueSize;
    }

    public final boolean getHighPressure() {
        return this.highPressure;
    }

    public HighLoadHttpGenerator(final @NotNull String url, final @NotNull String host, final int port, int numberConnections, int queueSize, boolean highPressure) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this(host, port, numberConnections, queueSize, highPressure, (Function1<? super RequestResponseBuilder, Unit>)((Function1)new Function1<RequestResponseBuilder, Unit>(){

            public final void invoke(@NotNull RequestResponseBuilder $this$null) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                $this$null.requestLine(HttpMethod.Companion.getGet(), (CharSequence)url, (CharSequence)"HTTP/1.1");
                $this$null.headerLine((CharSequence)HttpHeaders.INSTANCE.getHost(), (CharSequence)(host + ':' + port));
                $this$null.headerLine((CharSequence)HttpHeaders.INSTANCE.getAccept(), (CharSequence)"*/*");
                $this$null.emptyLine();
            }
        }));
    }

    public final void shutdown() {
        this.shutdown = true;
    }

    public final void stop() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mainLoop() {
        SelectorProvider selectorProvider = SelectorProvider.provider();
        Intrinsics.checkNotNull((Object)selectorProvider);
        SelectorProvider provider = selectorProvider;
        AbstractSelector abstractSelector = provider.openSelector();
        Intrinsics.checkNotNull((Object)abstractSelector);
        AbstractSelector selector = abstractSelector;
        Closeable closeable = selector;
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Collection<Object> tmp;
            AbstractSelector it = (AbstractSelector)closeable;
            boolean bl3 = false;
            int connectionsCount = 0;
            Collection<Object> writeReady = new ArrayList(this.getNumberOfConnections());
            ArrayList<ClientState> writeReadyTmp = new ArrayList<ClientState>(this.getNumberOfConnections());
            ArrayList<ClientState> readReady = new ArrayList<ClientState>(this.getNumberOfConnections());
            ArrayList<ClientState> pending = new ArrayList<ClientState>(this.getNumberOfConnections() * 2);
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(65536);
            Intrinsics.checkNotNull((Object)byteBuffer);
            ByteBuffer bb = byteBuffer;
            bb.order(ByteOrder.BIG_ENDIAN);
            int connectFailureInRowCount = 0;
            while (!this.cancelled && connectFailureInRowCount < 100) {
                int selectedCount;
                int n;
                ClientState c;
                int idx22;
                int t2;
                int ch2;
                if (connectionsCount < this.getNumberOfConnections()) {
                    int n2;
                    SocketChannel ch2;
                    Intrinsics.checkNotNull((Object)provider.openSocketChannel());
                    ch2.configureBlocking(false);
                    try {
                        ClientState client = new ClientState(ch2);
                        client.send(this.getQueueSize());
                        if (ch2.connect(this.remote)) {
                            ((ArrayList)writeReady).add(client);
                        } else {
                            client.setKey(ch2.register(selector, 8, client));
                            client.setCurrentOps(8);
                        }
                        n2 = connectionsCount;
                        connectionsCount = n2 + 1;
                        connectFailureInRowCount = 0;
                    }
                    catch (Throwable t2) {
                        ch2.close();
                        this.connectErrors.incrementAndGet();
                        n2 = connectFailureInRowCount;
                        connectFailureInRowCount = n2 + 1;
                    }
                }
                if ((ch2 = 0) < (t2 = ((ArrayList)writeReady).size())) {
                    do {
                        idx22 = ch2++;
                        if (this.cancelled) break;
                        Object e = ((ArrayList)writeReady).get(idx22);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"writeReady[idx]");
                        ClientState c2 = (ClientState)e;
                        if (!c2.getChannel().isConnected()) continue;
                        try {
                            if (!c2.doWrite$ktor_server_test_host()) {
                                c2.setWritePending(true);
                                readReady.add(c2);
                                pending.add(c2);
                                continue;
                            }
                            readReady.add(c2);
                            if (c2.getWritePending()) {
                                c2.setWritePending(false);
                                pending.add(c2);
                            }
                            if (c2.getRemaining() <= 0) continue;
                            writeReadyTmp.add(c2);
                        }
                        catch (Throwable t3) {
                            this.writeErrors.incrementAndGet();
                            c2.close();
                            int n3 = connectionsCount;
                            connectionsCount = n3 + -1;
                        }
                    } while (ch2 < t2);
                }
                ((ArrayList)writeReady).clear();
                tmp = writeReadyTmp;
                writeReadyTmp = writeReady;
                writeReady = tmp;
                t2 = 0;
                idx22 = readReady.size();
                if (t2 < idx22) {
                    do {
                        int n4;
                        int idx = t2++;
                        if (this.cancelled) break;
                        Object e = readReady.get(idx);
                        Intrinsics.checkNotNullExpressionValue(e, (String)"readReady[idx]");
                        c = (ClientState)e;
                        if (!c.getChannel().isConnected()) continue;
                        try {
                            int rc;
                            while ((rc = c.doRead$ktor_server_test_host(bb)) > 0) {
                            }
                            if (rc == -1) {
                                n4 = connectionsCount;
                                connectionsCount = n4 + -1;
                                c.close();
                                continue;
                            }
                            c.setReadPending(true);
                            pending.add(c);
                            if (c.getRemaining() <= 0) continue;
                            ((ArrayList)writeReady).add(c);
                        }
                        catch (Throwable t4) {
                            this.readErrors.incrementAndGet();
                            c.close();
                            n4 = connectionsCount;
                            connectionsCount = n4 + -1;
                        }
                    } while (t2 < idx22);
                }
                readReady.clear();
                t2 = 0;
                idx22 = pending.size();
                if (t2 < idx22) {
                    do {
                        int idx3 = t2++;
                        if (this.cancelled) break;
                        Object t4 = pending.get(idx3);
                        Intrinsics.checkNotNullExpressionValue(t4, (String)"pending[idx]");
                        c = (ClientState)t4;
                        c.interest(selector);
                    } while (t2 < idx22);
                }
                pending.clear();
                Collection<SelectionKey> idx22 = selector.keys();
                Intrinsics.checkNotNullExpressionValue(idx22, (String)"selector.keys()");
                idx22 = idx22;
                boolean idx3 = false;
                boolean hasKeys = !idx22.isEmpty();
                if (this.cancelled) {
                    n = 0;
                } else if (!hasKeys) {
                    n = 0;
                } else if (connectionsCount < this.getNumberOfConnections()) {
                    n = selector.selectNow();
                } else {
                    Collection idx3 = writeReady;
                    boolean c3 = false;
                    if (!idx3.isEmpty()) {
                        n = selector.selectNow();
                    } else {
                        idx3 = readReady;
                        c3 = false;
                        n = !idx3.isEmpty() ? selector.selectNow() : selector.select(500L);
                    }
                }
                if ((selectedCount = n) <= 0) continue;
                Iterator<SelectionKey> iter = selector.selectedKeys().iterator();
                while (iter.hasNext()) {
                    SelectionKey key;
                    Intrinsics.checkNotNull((Object)iter.next());
                    Object object = key.attachment();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type io.ktor.server.testing.HighLoadHttpGenerator.ClientState");
                    }
                    ClientState client = (ClientState)object;
                    if (!client.getChannel().isOpen()) {
                        client.close();
                    } else if (client.getChannel().isConnectionPending()) {
                        int n5;
                        try {
                            boolean bl4 = client.getChannel().finishConnect();
                            n5 = 0;
                            boolean bl5 = false;
                            bl5 = false;
                            boolean bl6 = false;
                            if (!bl4) {
                                boolean bl7 = false;
                                String string = "Check failed.";
                                throw (Throwable)new IllegalStateException(string.toString());
                            }
                            ((ArrayList)writeReady).add(client);
                        }
                        catch (Throwable t5) {
                            client.close();
                            n5 = connectionsCount;
                            connectionsCount = n5 + -1;
                            this.connectErrors.incrementAndGet();
                        }
                    } else {
                        int readyOps = key.readyOps();
                        if ((readyOps & 1) != 0) {
                            client.setReadPending(false);
                            readReady.add(client);
                        }
                        if ((readyOps & 4) != 0) {
                            client.setWritePending(false);
                            ((ArrayList)writeReady).add(client);
                        }
                    }
                    iter.remove();
                    client.interest(selector);
                }
            }
            tmp = selector.keys();
            Intrinsics.checkNotNullExpressionValue(tmp, (String)"selector.keys()");
            Iterable $this$forEach$iv = tmp;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SelectionKey it2 = (SelectionKey)element$iv;
                boolean bl8 = false;
                it2.cancel();
                try {
                    it2.channel().close();
                }
                catch (Throwable throwable2) {
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String stat() {
        boolean bl;
        Object $this$any$iv;
        int n;
        StringBuilder $this$stat_u24lambda_u2d5;
        StringBuilder stringBuilder;
        block3: {
            stringBuilder = new StringBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            $this$stat_u24lambda_u2d5 = stringBuilder;
            boolean bl4 = false;
            StringBuilder stringBuilder2 = $this$stat_u24lambda_u2d5;
            String string = Intrinsics.stringPlus((String)"count: ", (Object)this.count.get());
            boolean bl5 = false;
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringBuilder stringBuilder4 = stringBuilder3;
            n = 0;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            stringBuilder2 = $this$stat_u24lambda_u2d5;
            string = "errors: read " + this.readErrors.get() + ", write " + this.writeErrors.get() + ", connect: " + this.connectErrors.get();
            bl5 = false;
            StringBuilder stringBuilder5 = stringBuilder2.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            stringBuilder4 = stringBuilder5;
            n = 0;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            $this$any$iv = this.codeCounts;
            boolean $i$f$any = false;
            AtomicLong[] atomicLongArray = $this$any$iv;
            int n2 = atomicLongArray.length;
            for (n = 0; n < n2; ++n) {
                AtomicLong element$iv;
                AtomicLong it = element$iv = atomicLongArray[n];
                boolean bl6 = false;
                if (!(it.get() > 0L)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            $this$any$iv = $this$stat_u24lambda_u2d5;
            String $i$f$any = "statuses:";
            boolean bl7 = false;
            AtomicLong[] atomicLongArray = ((StringBuilder)$this$any$iv).append($i$f$any);
            Intrinsics.checkNotNullExpressionValue((Object)atomicLongArray, (String)"append(value)");
            AtomicLong[] atomicLongArray2 = atomicLongArray;
            n = 0;
            Intrinsics.checkNotNullExpressionValue((Object)atomicLongArray2.append('\n'), (String)"append('\\n')");
            AtomicLong[] $this$forEachIndexed$iv = this.codeCounts;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (AtomicLong item$iv : $this$forEachIndexed$iv) {
                StringBuilder stringBuilder6;
                void a;
                int n3 = index$iv++;
                AtomicLong bl6 = item$iv;
                int idx = n3;
                boolean bl8 = false;
                long cnt = a.get();
                if (cnt <= 0L) continue;
                StringBuilder stringBuilder7 = $this$stat_u24lambda_u2d5;
                String string = "  " + idx + "    " + cnt;
                boolean bl9 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append(string), (String)"append(value)");
                boolean bl10 = false;
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append('\\n')");
            }
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n        appendLine(\"count: ${count.get()}\")\n        appendLine(\"errors: read ${readErrors.get()}, write ${writeErrors.get()}, connect: ${connectErrors.get()}\")\n        if (codeCounts.any { it.get() > 0 }) {\n            appendLine(\"statuses:\")\n            codeCounts.forEachIndexed { idx, a ->\n                val cnt = a.get()\n                if (cnt > 0) {\n                    appendLine(\"  $idx    $cnt\")\n                }\n            }\n        }\n    }.toString()");
        return string;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        String string = "HTTP/1.1";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        HTTP11 = byArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator$ParseState;", "", "(Ljava/lang/String;I)V", "EOL", "HTTP", "SPACE", "CODE", "ktor-server-test-host"})
    private static final class ParseState
    extends Enum<ParseState> {
        public static final /* enum */ ParseState EOL = new ParseState();
        public static final /* enum */ ParseState HTTP = new ParseState();
        public static final /* enum */ ParseState SPACE = new ParseState();
        public static final /* enum */ ParseState CODE = new ParseState();
        private static final /* synthetic */ ParseState[] $VALUES;

        public static ParseState[] values() {
            return (ParseState[])$VALUES.clone();
        }

        public static ParseState valueOf(String value) {
            return Enum.valueOf(ParseState.class, value);
        }

        static {
            $VALUES = parseStateArray = new ParseState[]{ParseState.EOL, ParseState.HTTP, ParseState.SPACE, ParseState.CODE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010&\u001a\u00020\bH\u0002J\u0006\u0010'\u001a\u00020(J\u0015\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b+J\u000e\u0010,\u001a\u00020\u001aH\u0080\u0010\u00a2\u0006\u0002\b-J\u0010\u0010.\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u0010/\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J \u00100\u001a\u00020(2\u0006\u0010*\u001a\u00020\n2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\bH\u0002J\u0010\u00103\u001a\u00020(2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u00104\u001a\u00020(2\u0006\u00105\u001a\u000206J\u0010\u00107\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u00108\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J\u0010\u00109\u001a\u00020(2\b\b\u0002\u0010:\u001a\u00020\bJ\u0010\u0010;\u001a\u00020(2\u0006\u0010*\u001a\u00020\nH\u0002J \u0010<\u001a\u00020(2\u0006\u0010*\u001a\u00020\n2\u0006\u00101\u001a\u00020\b2\u0006\u00102\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001e\u0010 \u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u000eR\u000e\u0010\"\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001c\"\u0004\b%\u0010\u001e\u00a8\u0006="}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator$ClientState;", "", "channel", "Ljava/nio/channels/SocketChannel;", "(Lio/ktor/server/testing/HighLoadHttpGenerator;Ljava/nio/channels/SocketChannel;)V", "getChannel", "()Ljava/nio/channels/SocketChannel;", "code", "", "current", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "currentOps", "getCurrentOps", "()I", "setCurrentOps", "(I)V", "key", "Ljava/nio/channels/SelectionKey;", "getKey", "()Ljava/nio/channels/SelectionKey;", "setKey", "(Ljava/nio/channels/SelectionKey;)V", "parseState", "Lio/ktor/server/testing/HighLoadHttpGenerator$ParseState;", "readPending", "", "getReadPending", "()Z", "setReadPending", "(Z)V", "<set-?>", "remaining", "getRemaining", "tokenSize", "writePending", "getWritePending", "setWritePending", "calcOps", "close", "", "doRead", "bb", "doRead$ktor_server_test_host", "doWrite", "doWrite$ktor_server_test_host", "findEol", "findHttp", "findHttpSlow", "position", "limit", "gotStatus", "interest", "selector", "Ljava/nio/channels/Selector;", "parseCode", "parseLoop", "send", "qty", "skipSpaces", "skipSpacesSlow", "ktor-server-test-host"})
    private final class ClientState {
        @NotNull
        private final SocketChannel channel;
        private final ByteBuffer current;
        private int remaining;
        @NotNull
        private ParseState parseState;
        private int tokenSize;
        private int code;
        @Nullable
        private SelectionKey key;
        private boolean writePending;
        private boolean readPending;
        private int currentOps;

        public ClientState(SocketChannel channel) {
            Intrinsics.checkNotNullParameter((Object)HighLoadHttpGenerator.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.channel = channel;
            this.current = HighLoadHttpGenerator.this.requestByteBuffer.duplicate();
            this.parseState = ParseState.HTTP;
        }

        @NotNull
        public final SocketChannel getChannel() {
            return this.channel;
        }

        public final int getRemaining() {
            return this.remaining;
        }

        @Nullable
        public final SelectionKey getKey() {
            return this.key;
        }

        public final void setKey(@Nullable SelectionKey selectionKey) {
            this.key = selectionKey;
        }

        public final boolean getWritePending() {
            return this.writePending;
        }

        public final void setWritePending(boolean bl) {
            this.writePending = bl;
        }

        public final boolean getReadPending() {
            return this.readPending;
        }

        public final void setReadPending(boolean bl) {
            this.readPending = bl;
        }

        public final int getCurrentOps() {
            return this.currentOps;
        }

        public final void setCurrentOps(int n) {
            this.currentOps = n;
        }

        private final int calcOps() {
            int ops = 0;
            if (this.writePending) {
                ops |= 4;
            }
            if (this.readPending) {
                ops |= 1;
            }
            return ops;
        }

        public final void interest(@NotNull Selector selector) {
            Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
            int ops = this.calcOps();
            SelectionKey key = this.key;
            try {
                if (key == null) {
                    this.key = this.channel.register(selector, ops, this);
                    this.currentOps = ops;
                } else if (this.currentOps != ops) {
                    key.interestOps(ops);
                    this.currentOps = ops;
                }
            }
            catch (Throwable t) {
                this.close();
            }
        }

        public final void send(int qty) {
            boolean bl = qty > 0;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            if (!HighLoadHttpGenerator.this.shutdown) {
                ClientState clientState = this;
                clientState.remaining += qty;
                if (!this.current.hasRemaining()) {
                    this.current.clear();
                }
            }
        }

        public static /* synthetic */ void send$default(ClientState clientState, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = 1;
            }
            clientState.send(n);
        }

        public final void close() {
            SelectionKey selectionKey = this.key;
            if (selectionKey != null) {
                selectionKey.cancel();
            }
            this.key = null;
            this.readPending = false;
            this.writePending = false;
            try {
                this.channel.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public final boolean doWrite$ktor_server_test_host() {
            block4: {
                boolean bl;
                block5: {
                    ClientState clientState = this;
                    while (true) {
                        ClientState clientState2 = clientState;
                        if (clientState2.remaining == 0) {
                            return true;
                        }
                        boolean hp = HighLoadHttpGenerator.this.getHighPressure();
                        clientState2.channel.write(clientState2.current);
                        if (clientState2.current.hasRemaining()) break block4;
                        HighLoadHttpGenerator.this.count.incrementAndGet();
                        if (HighLoadHttpGenerator.this.shutdown) {
                            clientState2.remaining = 0;
                            bl = true;
                            break block5;
                        }
                        if (hp) {
                            clientState2.current.clear();
                            clientState = clientState2;
                            continue;
                        }
                        ClientState clientState3 = clientState2;
                        clientState3.remaining += -1;
                        if (clientState3.remaining <= 0) break;
                        clientState2.current.clear();
                        clientState = clientState2;
                    }
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public final int doRead$ktor_server_test_host(@NotNull ByteBuffer bb) {
            Intrinsics.checkNotNullParameter((Object)bb, (String)"bb");
            bb.clear();
            int rc = this.channel.read(bb);
            if (rc == -1) {
                this.close();
                return -1;
            }
            if (rc == 0) {
                return 0;
            }
            if (!HighLoadHttpGenerator.this.getHighPressure()) {
                bb.flip();
                this.parseLoop(bb);
            }
            return 1;
        }

        private final void parseLoop(ByteBuffer bb) {
            while (bb.hasRemaining()) {
                ParseState parseState = this.parseState;
                int n = WhenMappings.$EnumSwitchMapping$0[parseState.ordinal()];
                switch (n) {
                    case 1: {
                        this.findEol(bb);
                        break;
                    }
                    case 2: {
                        this.findHttp(bb);
                        break;
                    }
                    case 3: {
                        this.skipSpaces(bb);
                        break;
                    }
                    case 4: {
                        this.parseCode(bb);
                    }
                }
            }
        }

        private final void findEol(ByteBuffer bb) {
            int limit;
            int position = bb.position();
            int n = position;
            if (n < (limit = bb.limit())) {
                do {
                    int idx;
                    if (bb.get(idx = n++) != 10) continue;
                    this.parseState = ParseState.HTTP;
                    this.tokenSize = 0;
                    bb.position(idx + 1);
                    return;
                } while (n < limit);
            }
            bb.position(limit);
        }

        private final void findHttp(ByteBuffer bb) {
            int position = bb.position();
            int limit = bb.limit();
            if (this.tokenSize == 0 && limit - position >= 8) {
                if (bb.getLong(position) == 5211883372140375601L) {
                    this.parseState = ParseState.SPACE;
                    this.tokenSize = 0;
                    bb.position(position + 8);
                    return;
                }
                this.parseState = ParseState.EOL;
                return;
            }
            this.findHttpSlow(bb, position, limit);
        }

        private final void findHttpSlow(ByteBuffer bb, int position, int limit) {
            byte[] http = HTTP11;
            int offset = this.tokenSize - position;
            int n = position;
            if (n < limit) {
                do {
                    int idx;
                    byte b;
                    if ((b = bb.get(idx = n++)) == 32) {
                        this.parseState = ParseState.SPACE;
                        this.tokenSize = 0;
                        bb.position(idx + 1);
                        return;
                    }
                    if (b == http[idx + offset]) {
                        ClientState clientState = this;
                        ++clientState.tokenSize;
                        if (clientState.tokenSize <= 8) continue;
                        this.parseState = ParseState.EOL;
                        bb.position(idx + 1);
                        return;
                    }
                    this.parseState = ParseState.EOL;
                    bb.position(idx);
                    return;
                } while (n < limit);
            }
            bb.position(limit);
        }

        private final void skipSpaces(ByteBuffer bb) {
            int position = bb.position();
            int limit = bb.limit();
            if (limit - position >= 4) {
                int i = bb.getInt(position);
                switch (i) {
                    case 842018829: 
                    case 0x32303020: {
                        this.gotStatus(200);
                        this.parseState = ParseState.EOL;
                        bb.position(position + 3);
                        return;
                    }
                }
            }
            this.skipSpacesSlow(bb, position, limit);
        }

        private final void skipSpacesSlow(ByteBuffer bb, int position, int limit) {
            int n = position;
            if (n < limit) {
                do {
                    int n2;
                    int idx;
                    byte b;
                    if ((b = bb.get(idx = n++)) == 10) {
                        this.parseState = ParseState.HTTP;
                        bb.position(idx + 1);
                        return;
                    }
                    if (b == 32) {
                        ClientState clientState = this;
                        ++clientState.tokenSize;
                        if (clientState.tokenSize <= 10) continue;
                        this.parseState = ParseState.EOL;
                        bb.position(idx + 1);
                        return;
                    }
                    if (b == 50 && limit - idx >= 4) {
                        int i = bb.getInt(idx);
                        switch (i) {
                            case 842018829: 
                            case 0x32303020: {
                                this.gotStatus(200);
                                this.parseState = ParseState.EOL;
                                bb.position(idx + 3);
                                return;
                            }
                        }
                    }
                    boolean bl = 0 <= (n2 = b - 48) ? n2 <= 9 : false;
                    if (bl) {
                        this.parseState = ParseState.CODE;
                        this.code = n2;
                        this.tokenSize = 1;
                        bb.position(idx + 1);
                        return;
                    }
                    this.parseState = ParseState.EOL;
                    bb.position(idx + 1);
                    return;
                } while (n < limit);
            }
            bb.position(limit);
        }

        private final void parseCode(ByteBuffer bb) {
            int code = this.code;
            while (bb.hasRemaining()) {
                byte b = bb.get();
                if (b == 32 || b == 10) {
                    boolean bl = 100 <= code ? code <= 999 : false;
                    if (bl) {
                        this.gotStatus(code);
                    }
                    this.parseState = ParseState.EOL;
                    return;
                }
                int n = b - 48;
                if (n < 0 || n > 9) {
                    this.parseState = ParseState.EOL;
                    return;
                }
                ClientState clientState = this;
                ++clientState.tokenSize;
                if (clientState.tokenSize > 3) {
                    this.parseState = ParseState.EOL;
                    return;
                }
                code = code * 10 + n;
            }
            this.code = code;
        }

        private final void gotStatus(int code) {
            HighLoadHttpGenerator.this.codeCounts[code].incrementAndGet();
            this.send(1);
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ParseState.values().length];
                nArray[ParseState.EOL.ordinal()] = 1;
                nArray[ParseState.HTTP.ordinal()] = 2;
                nArray[ParseState.SPACE.ordinal()] = 3;
                nArray[ParseState.CODE.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J_\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00062\u0017\u0010\u001c\u001a\u0013\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u000f0\u001d\u00a2\u0006\u0002\b\u001fJN\u0010\u000e\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0006J\u001b\u0010!\u001a\u00020\u000f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160#H\u0007\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/ktor/server/testing/HighLoadHttpGenerator$Companion;", "", "()V", "HTTP11", "", "HTTP11Long", "", "HTTP1_length", "", "HTTP_200_R_Int", "HTTP_200_SPACE_Int", "N", "", "S", "doRun", "", "loadGenerator", "Lio/ktor/server/testing/HighLoadHttpGenerator;", "numberOfThreads", "gracefulMillis", "timeMillis", "host", "", "port", "connectionsPerThread", "queueSize", "highPressure", "", "builder", "Lkotlin/Function1;", "Lio/ktor/http/cio/RequestResponseBuilder;", "Lkotlin/ExtensionFunctionType;", "url", "main", "args", "", "([Ljava/lang/String;)V", "ktor-server-test-host"})
    public static final class Companion {
        private Companion() {
        }

        public final void doRun(@NotNull String url, @NotNull String host, int port, int numberOfThreads, int connectionsPerThread, int queueSize, boolean highPressure, long gracefulMillis, long timeMillis) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            HighLoadHttpGenerator generator = new HighLoadHttpGenerator(url, host, port, connectionsPerThread, queueSize, highPressure);
            this.doRun(generator, numberOfThreads, gracefulMillis, timeMillis);
        }

        public final void doRun(@NotNull String host, int port, int numberOfThreads, int connectionsPerThread, int queueSize, boolean highPressure, long gracefulMillis, long timeMillis, @NotNull Function1<? super RequestResponseBuilder, Unit> builder) {
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            HighLoadHttpGenerator generator = new HighLoadHttpGenerator(host, port, connectionsPerThread, queueSize, highPressure, builder);
            this.doRun(generator, numberOfThreads, gracefulMillis, timeMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void doRun(HighLoadHttpGenerator loadGenerator, int numberOfThreads, long gracefulMillis, long timeMillis) {
            boolean $this$mapTo$iv$iv2;
            String $i$f$map2;
            void $this$mapTo$iv$iv2;
            String string = "Running...";
            boolean bl = false;
            System.out.println((Object)string);
            Iterable $this$map$iv = (Iterable)new IntRange(1, numberOfThreads);
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(loadGenerator){
                    final /* synthetic */ HighLoadHttpGenerator $loadGenerator;
                    {
                        this.$loadGenerator = $loadGenerator;
                        super(0);
                    }

                    public final void invoke() {
                        this.$loadGenerator.mainLoop();
                    }
                }), (int)31, null);
                collection.add(thread);
            }
            List threads2 = (List)destination$iv$iv;
            Thread joiner2 = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>((List<? extends Thread>)threads2, gracefulMillis){
                final /* synthetic */ List<Thread> $threads;
                final /* synthetic */ long $gracefulMillis;
                {
                    this.$threads = $threads;
                    this.$gracefulMillis = $gracefulMillis;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void $this$forEach$iv;
                    Iterable iterable = this.$threads;
                    long l = this.$gracefulMillis;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Thread it = (Thread)element$iv;
                        boolean bl = false;
                        it.join(l);
                    }
                }
            }), (int)30, null);
            try {
                Thread.sleep(timeMillis);
                $i$f$map2 = "Shutting down...";
                $this$mapTo$iv$iv2 = false;
                System.out.println((Object)$i$f$map2);
                loadGenerator.shutdown();
                joiner2.start();
                joiner2.join(gracefulMillis);
            }
            finally {
                $i$f$map2 = "Termination...";
                $this$mapTo$iv$iv2 = false;
                System.out.println((Object)$i$f$map2);
                loadGenerator.stop();
                Iterable $this$forEach$iv = threads2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread it = (Thread)element$iv;
                    boolean bl3 = false;
                    it.interrupt();
                }
                joiner2.join();
                String string2 = "Terminated.";
                $i$f$forEach = false;
                System.out.println((Object)string2);
                string2 = loadGenerator.stat();
                $i$f$forEach = false;
                System.out.println((Object)string2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void main(@NotNull String[] args) {
            String string;
            boolean bl;
            HighLoadHttpGenerator manager;
            boolean bl2;
            block8: {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                boolean debug = false;
                URL url = new URL("http://localhost:8081/");
                int connections = 4000;
                int queue = 100;
                int time = 20;
                boolean highPressure = false;
                int numberCpu = Runtime.getRuntime().availableProcessors();
                boolean bl3 = false;
                boolean bl4 = false;
                CharSequence charSequence = new StringBuilder();
                boolean bl5 = false;
                bl2 = false;
                Object $this$main_u24lambda_u2d2 = charSequence;
                boolean bl6 = false;
                ((StringBuilder)$this$main_u24lambda_u2d2).append(url.getPath());
                CharSequence charSequence2 = url.getQuery();
                boolean bl7 = false;
                boolean bl8 = false;
                if (!(charSequence2 == null || charSequence2.length() == 0)) {
                    ((StringBuilder)$this$main_u24lambda_u2d2).append('?');
                    ((StringBuilder)$this$main_u24lambda_u2d2).append(url.getQuery());
                }
                String string2 = charSequence.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                String pathAndQuery = string2;
                charSequence = url.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"url.host");
                manager = new HighLoadHttpGenerator(pathAndQuery, (String)charSequence, url.getPort() == -1 ? 80 : url.getPort(), connections / numberCpu, queue, highPressure);
                Iterable $this$map$iv = (Iterable)new IntRange(1, numberCpu);
                boolean $i$f$map = false;
                $this$main_u24lambda_u2d2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl9 = false;
                    Thread thread = ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(manager){
                        final /* synthetic */ HighLoadHttpGenerator $manager;
                        {
                            this.$manager = $manager;
                            super(0);
                        }

                        public final void invoke() {
                            this.$manager.mainLoop();
                        }
                    }), (int)30, null);
                    collection.add(thread);
                }
                List threads2 = (List)destination$iv$iv;
                Iterable $this$forEach$iv = threads2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread it = (Thread)element$iv;
                    boolean bl10 = false;
                    it.start();
                }
                TimeUnit.SECONDS.sleep(time);
                manager.shutdown();
                Thread.sleep(1000L);
                manager.stop();
                $this$forEach$iv = threads2;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Thread it = (Thread)element$iv;
                    boolean bl11 = false;
                    it.join(1000L);
                }
                Iterable $this$any$iv = threads2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Thread it = (Thread)element$iv;
                        boolean bl12 = false;
                        if (!it.isAlive()) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                string = "There are threads get stuck";
                bl2 = false;
                System.out.println((Object)string);
            }
            string = manager.stat();
            bl2 = false;
            System.out.println((Object)string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

