/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.sessions;

import io.ktor.sessions.DirectoryStorage;
import io.ktor.sessions.DirectoryStorageKt;
import io.ktor.sessions.SessionStorage;
import io.ktor.util.cio.FileChannelsKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteWriteChannel;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0002J\u0019\u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\fJC\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\t\u001a\u00020\n2\"\u0010\u000f\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\t\u001a\u00020\nH\u0002J=\u0010\u0018\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\"\u0010\u0019\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0010H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lio/ktor/sessions/DirectoryStorage;", "Lio/ktor/sessions/SessionStorage;", "Ljava/io/Closeable;", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "close", "", "fileOf", "id", "", "invalidate", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "read", "R", "consumer", "Lkotlin/Function2;", "Lio/ktor/utils/io/ByteReadChannel;", "Lkotlin/coroutines/Continuation;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requireId", "split", "Lkotlin/sequences/Sequence;", "write", "provider", "Lio/ktor/utils/io/ByteWriteChannel;", "ktor-server-sessions"})
public final class DirectoryStorage
implements SessionStorage,
Closeable {
    @NotNull
    private final File dir;

    public DirectoryStorage(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
        DirectoryStorageKt.access$mkdirsOrFail(this.dir);
    }

    @Override
    public void close() {
    }

    @Nullable
    public Object write(@NotNull String id, @NotNull Function2<? super ByteWriteChannel, ? super Continuation<? super Unit>, ? extends Object> provider, @NotNull Continuation<? super Unit> $completion) {
        this.requireId(id);
        File file = this.fileOf(id);
        File file2 = file.getParentFile();
        if (file2 != null) {
            DirectoryStorageKt.access$mkdirsOrFail(file2);
        }
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(provider, file, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Function2<ByteWriteChannel, Continuation<? super Unit>, Object> $provider;
            final /* synthetic */ File $file;
            {
                this.$provider = $provider;
                this.$file = $file;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        this.label = 1;
                        Object object3 = this.$provider.invoke((Object)FileChannelsKt.writeChannel((File)this.$file, (CoroutineContext)$this$coroutineScope.getCoroutineContext()), (Object)((Object)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public <R> Object read(@NotNull String var1_1, @NotNull Function2<? super ByteReadChannel, ? super Continuation<? super R>, ? extends Object> var2_2, @NotNull Continuation<? super R> var3_3) {
        if (!(var3_3 instanceof read.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ DirectoryStorage this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.read(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.requireId(id);
                file = this.fileOf(id);
                var5_9 = file.getParentFile();
                if (var5_9 != null) {
                    DirectoryStorageKt.access$mkdirsOrFail(var5_9);
                }
                $continuation.L$0 = id;
                $continuation.label = 1;
                v0 = consumer.invoke((Object)FileChannelsKt.readChannel$default((File)file, (long)0L, (long)0L, null, (int)7, null), $continuation);
                ** if (v0 != var8_6) goto lbl24
lbl23:
                // 1 sources

                return var8_6;
lbl24:
                // 1 sources

                ** GOTO lbl31
            }
            case 1: {
                id = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl31:
                    // 2 sources

                    return v0;
                }
                catch (FileNotFoundException var4_8) {
                    throw new NoSuchElementException(Intrinsics.stringPlus((String)"No session data found for id ", (Object)id));
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object invalidate(@NotNull String id, @NotNull Continuation<? super Unit> $completion) {
        this.requireId(id);
        try {
            File file = this.fileOf(id);
            file.delete();
            File file2 = file.getParentFile();
            if (file2 != null) {
                DirectoryStorageKt.access$deleteParentsWhileEmpty(file2, this.dir);
            }
        }
        catch (FileNotFoundException notFound) {
            throw new NoSuchElementException(Intrinsics.stringPlus((String)"No session data found for id ", (Object)id));
        }
        return Unit.INSTANCE;
    }

    private final File fileOf(String id) {
        Sequence<String> sequence = this.split(id);
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        return new File(this.dir, SequencesKt.joinToString$default(sequence, (CharSequence)string, null, (CharSequence)".dat", (int)0, null, null, (int)58, null));
    }

    private final Sequence<String> split(String id) {
        return StringsKt.windowedSequence((CharSequence)id, (int)2, (int)2, (boolean)true);
    }

    private final void requireId(String id) {
        Object[] objectArray = (Object[])id;
        boolean bl = false;
        if (objectArray.length() == 0) {
            throw new IllegalArgumentException("Session id is empty");
        }
        objectArray = new String[]{"..", "/", "\\", "!", "?", ">", "<", "\u0000"};
        if (StringsKt.indexOfAny$default((CharSequence)id, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)0, (boolean)false, (int)6, null) != -1) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Bad session id ", (Object)id));
        }
    }
}

