/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.sessions;

import io.ktor.sessions.CacheStorage;
import io.ktor.sessions.DirectoryStorage;
import io.ktor.sessions.SessionStorage;
import io.ktor.util.KtorExperimentalAPI;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007\u001a\u0015\u0010\u0006\u001a\u00020\u0007*\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0082\u0010\u001a\f\u0010\t\u001a\u00020\u0007*\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"directorySessionStorage", "Lio/ktor/sessions/SessionStorage;", "rootDir", "Ljava/io/File;", "cached", "", "deleteParentsWhileEmpty", "", "mostTop", "mkdirsOrFail", "ktor-server-sessions"})
public final class DirectoryStorageKt {
    @KtorExperimentalAPI
    @NotNull
    public static final SessionStorage directorySessionStorage(@NotNull File rootDir, boolean cached) {
        SessionStorage sessionStorage;
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        boolean bl = cached;
        if (bl) {
            sessionStorage = new CacheStorage(new DirectoryStorage(rootDir), 60000L);
        } else if (!bl) {
            sessionStorage = new DirectoryStorage(rootDir);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sessionStorage;
    }

    public static /* synthetic */ SessionStorage directorySessionStorage$default(File file, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return DirectoryStorageKt.directorySessionStorage(file, bl);
    }

    private static final void mkdirsOrFail(@NotNull File $this$mkdirsOrFail) {
        if (!$this$mkdirsOrFail.mkdirs() && !$this$mkdirsOrFail.exists()) {
            throw (Throwable)new IOException("Couldn't create directory " + $this$mkdirsOrFail);
        }
        if (!$this$mkdirsOrFail.isDirectory()) {
            throw (Throwable)new IOException("Path is not a directory: " + $this$mkdirsOrFail);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final void deleteParentsWhileEmpty(@NotNull File $this$deleteParentsWhileEmpty, File mostTop) {
        while (Intrinsics.areEqual((Object)$this$deleteParentsWhileEmpty, (Object)mostTop) ^ true) {
            if (!$this$deleteParentsWhileEmpty.isDirectory()) return;
            if (!$this$deleteParentsWhileEmpty.exists()) return;
            String[] stringArray = $this$deleteParentsWhileEmpty.list();
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray != null) {
                String[] stringArray2 = stringArray;
                boolean bl3 = false;
                if (stringArray2.length != 0) return;
                boolean bl4 = true;
                if (!bl4) return;
            }
            boolean bl5 = true;
            if (!bl5) return;
            if (!$this$deleteParentsWhileEmpty.delete() && $this$deleteParentsWhileEmpty.exists()) {
                throw (Throwable)new IOException("Failed to delete dir " + $this$deleteParentsWhileEmpty);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)$this$deleteParentsWhileEmpty.getParentFile(), (String)"parentFile");
        }
    }

    public static final /* synthetic */ void access$mkdirsOrFail(File $this$access_u24mkdirsOrFail) {
        DirectoryStorageKt.mkdirsOrFail($this$access_u24mkdirsOrFail);
    }

    public static final /* synthetic */ void access$deleteParentsWhileEmpty(File $this$access_u24deleteParentsWhileEmpty, File mostTop) {
        DirectoryStorageKt.deleteParentsWhileEmpty($this$access_u24deleteParentsWhileEmpty, mostTop);
    }
}

