/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.sessions;

import io.ktor.sessions.DirectoryStorage;
import io.ktor.sessions.DirectoryStorageKt;
import io.ktor.sessions.SessionStorage;
import io.ktor.util.cio.FileChannelsKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.io.ByteReadChannel;
import kotlinx.coroutines.io.ByteWriteChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0019\u0010\r\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJC\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\u0006\u0010\u000b\u001a\u00020\f2\"\u0010\u0011\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00100\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J=\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\"\u0010\u001b\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lio/ktor/sessions/DirectoryStorage;", "Lio/ktor/sessions/SessionStorage;", "Ljava/io/Closeable;", "dir", "Ljava/io/File;", "(Ljava/io/File;)V", "getDir", "()Ljava/io/File;", "close", "", "fileOf", "id", "", "invalidate", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "read", "R", "consumer", "Lkotlin/Function2;", "Lkotlinx/coroutines/io/ByteReadChannel;", "Lkotlin/coroutines/Continuation;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "requireId", "split", "Lkotlin/sequences/Sequence;", "write", "provider", "Lkotlinx/coroutines/io/ByteWriteChannel;", "ktor-server-sessions"})
public final class DirectoryStorage
implements SessionStorage,
Closeable {
    @NotNull
    private final File dir;

    @Override
    public void close() {
    }

    @Nullable
    public Object write(@NotNull String id, @NotNull Function2<? super ByteWriteChannel, ? super Continuation<? super Unit>, ? extends Object> provider, @NotNull Continuation<? super Unit> continuation) {
        File file;
        block0: {
            this.requireId(id);
            file = this.fileOf(id);
            File file2 = file.getParentFile();
            if (file2 == null) break block0;
            DirectoryStorageKt.access$mkdirsOrFail(file2);
        }
        return provider.invoke((Object)FileChannelsKt.writeChannel$default((File)file, null, (int)1, null), continuation);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public <R> Object read(@NotNull String id, @NotNull Function2<? super ByteReadChannel, ? super Continuation<? super R>, ? extends Object> consumer, @NotNull Continuation<? super R> var3_3) {
        if (!(var3_3 instanceof read.1)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ DirectoryStorage this$0;
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;

                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    this.result = result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.read((String)null, null, this);
                }
                {
                    this.this$0 = directoryStorage;
                    super(continuation);
                }
            };
        }
        var5_5 = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                v0 = var5_5;
                if (v0 instanceof Result.Failure) {
                    throw ((Result.Failure)v0).exception;
                }
                this.requireId(id);
                file = this.fileOf(id);
                v1 = file.getParentFile();
                if (v1 != null) {
                    DirectoryStorageKt.access$mkdirsOrFail(v1);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = id;
                $continuation.L$2 = consumer;
                $continuation.L$3 = file;
                $continuation.label = 1;
                v2 = consumer.invoke((Object)FileChannelsKt.readChannel$default((File)file, (long)0L, (long)0L, null, (int)7, null), (Object)$continuation);
                ** if (v2 != var7_6) goto lbl29
lbl28:
                // 1 sources

                return var7_6;
lbl29:
                // 1 sources

                ** GOTO lbl40
            }
            case 1: {
                file = (File)$continuation.L$3;
                consumer = (Function2)$continuation.L$2;
                id = (String)$continuation.L$1;
                this = (DirectoryStorage)$continuation.L$0;
                try {
                    v3 = var5_5;
                    if (v3 instanceof Result.Failure) {
                        throw ((Result.Failure)v3).exception;
                    }
                    v2 = var5_5;
lbl40:
                    // 2 sources

                    return v2;
                }
                catch (FileNotFoundException notFound) {
                    throw (Throwable)new NoSuchElementException("No session data found for id " + id);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public Object invalidate(@NotNull String id, @NotNull Continuation<? super Unit> continuation) {
        this.requireId(id);
        try {
            File file = this.fileOf(id);
            file.delete();
            File file2 = file.getParentFile();
            if (file2 != null) {
                DirectoryStorageKt.access$deleteParentsWhileEmpty(file2, this.dir);
            }
        }
        catch (FileNotFoundException notFound) {
            throw (Throwable)new NoSuchElementException("No session data found for id " + id);
        }
        return Unit.INSTANCE;
    }

    private final File fileOf(String id) {
        Sequence<String> sequence = this.split(id);
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.separator");
        return new File(this.dir, SequencesKt.joinToString$default(sequence, (CharSequence)string, null, (CharSequence)".dat", (int)0, null, null, (int)58, null));
    }

    private final Sequence<String> split(String id) {
        return DirectoryStorageKt.window$default(id, 2, 0, false, 6, null);
    }

    private final void requireId(String id) {
        CharSequence charSequence = id;
        if (charSequence.length() == 0) {
            throw (Throwable)new IllegalArgumentException("Session id is empty");
        }
        if (StringsKt.indexOfAny$default((CharSequence)id, (Collection)CollectionsKt.listOf((Object[])new String[]{"..", "/", "\\", "!", "?", ">", "<", "\u0000"}), (int)0, (boolean)false, (int)6, null) != -1) {
            throw (Throwable)new IllegalArgumentException("Bad session id " + id);
        }
    }

    @NotNull
    public final File getDir() {
        return this.dir;
    }

    public DirectoryStorage(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        this.dir = dir;
        DirectoryStorageKt.access$mkdirsOrFail(this.dir);
    }
}

