/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.servlet;

import io.ktor.server.engine.EngineAPI;
import io.ktor.server.servlet.ServletReaderKt;
import io.ktor.server.servlet.ServletUpgradeKt;
import io.ktor.server.servlet.ServletWriterKt;
import io.ktor.server.servlet.UpgradeRequest;
import io.ktor.util.InternalAPI;
import io.ktor.util.cio.ByteBufferPoolKt;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.WebConnection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.io.ByteReadChannel;
import kotlinx.coroutines.io.ByteWriteChannel;
import kotlinx.coroutines.io.jvm.javaio.ReadingKt;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalAPI
@EngineAPI
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00112\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/ktor/server/servlet/ServletUpgradeHandler;", "Ljavax/servlet/http/HttpUpgradeHandler;", "Lkotlinx/coroutines/CoroutineScope;", "()V", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "up", "Lio/ktor/server/servlet/UpgradeRequest;", "getUp", "()Lio/ktor/server/servlet/UpgradeRequest;", "setUp", "(Lio/ktor/server/servlet/UpgradeRequest;)V", "upgradeJob", "Lkotlinx/coroutines/CompletableJob;", "destroy", "", "init", "webConnection", "Ljavax/servlet/http/WebConnection;", "ktor-server-servlet"})
public final class ServletUpgradeHandler
implements HttpUpgradeHandler,
CoroutineScope {
    @NotNull
    public volatile UpgradeRequest up;
    private final CompletableJob upgradeJob = JobKt.Job$default(null, (int)1, null);

    @NotNull
    public final UpgradeRequest getUp() {
        UpgradeRequest upgradeRequest = this.up;
        if (upgradeRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"up");
        }
        return upgradeRequest;
    }

    public final void setUp(@NotNull UpgradeRequest upgradeRequest) {
        Intrinsics.checkParameterIsNotNull((Object)upgradeRequest, (String)"<set-?>");
        this.up = upgradeRequest;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.upgradeJob;
    }

    public void init(@Nullable WebConnection webConnection) {
        ByteReadChannel byteReadChannel;
        if (webConnection == null) {
            throw (Throwable)new IllegalArgumentException("Upgrade processing requires WebConnection instance");
        }
        this.upgradeJob.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(webConnection){
            final /* synthetic */ WebConnection $webConnection;

            public final void invoke(@Nullable Throwable it) {
                this.$webConnection.close();
            }
            {
                this.$webConnection = webConnection;
                super(1);
            }
        });
        UpgradeRequest upgradeRequest = this.up;
        if (upgradeRequest == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"up");
        }
        if (upgradeRequest.getDisableAsyncInput()) {
            ServletInputStream servletInputStream = webConnection.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)servletInputStream, (String)"webConnection.inputStream");
            InputStream inputStream = (InputStream)servletInputStream;
            UpgradeRequest upgradeRequest2 = this.up;
            if (upgradeRequest2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"up");
            }
            byteReadChannel = ReadingKt.toByteReadChannel((InputStream)inputStream, (CoroutineContext)upgradeRequest2.getUserContext().plus((CoroutineContext)this.upgradeJob), (ObjectPool)ByteBufferPoolKt.getKtorDefaultPool());
        } else {
            ServletInputStream servletInputStream = webConnection.getInputStream();
            Intrinsics.checkExpressionValueIsNotNull((Object)servletInputStream, (String)"webConnection.inputStream");
            byteReadChannel = ServletReaderKt.servletReader(this, servletInputStream).getChannel();
        }
        ByteReadChannel inputChannel = byteReadChannel;
        ServletOutputStream servletOutputStream = webConnection.getOutputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)servletOutputStream, (String)"webConnection.outputStream");
        ByteWriteChannel outputChannel = ServletWriterKt.servletWriter(this, servletOutputStream).getChannel();
        UpgradeRequest upgradeRequest3 = this.up;
        if (upgradeRequest3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"up");
        }
        BuildersKt.launch((CoroutineScope)this, (CoroutineContext)upgradeRequest3.getUserContext().plus((CoroutineContext)ServletUpgradeKt.access$getServletUpgradeCoroutineName$p()), (CoroutineStart)CoroutineStart.UNDISPATCHED, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, inputChannel, outputChannel, null){
            private CoroutineScope p$;
            int label;
            final /* synthetic */ ServletUpgradeHandler this$0;
            final /* synthetic */ ByteReadChannel $inputChannel;
            final /* synthetic */ ByteWriteChannel $outputChannel;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)result);
                        CoroutineScope coroutineScope = this.p$;
                        this.label = 1;
                        Object object2 = this.this$0.getUp().getUpgradeMessage().upgrade(this.$inputChannel, this.$outputChannel, this.this$0.getUp().getEngineContext(), this.this$0.getUp().getUserContext(), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)result);
                        Object object2 = result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = servletUpgradeHandler;
                this.$inputChannel = byteReadChannel;
                this.$outputChannel = byteWriteChannel;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public void destroy() {
        this.upgradeJob.completeExceptionally((Throwable)new CancellationException("Upgraded WebConnection destroyed"));
    }
}

