/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.http2;

import io.ktor.application.Application;
import io.ktor.http.HttpUrlEncodedKt;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.URLBuilder;
import io.ktor.response.ResponsePushBuilder;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.netty.NettyApplicationCallHandler;
import io.ktor.server.netty.cio.NettyRequestQueue;
import io.ktor.server.netty.cio.NettyResponsePipeline;
import io.ktor.server.netty.cio.WriterEncapsulation;
import io.ktor.server.netty.http2.NettyHttp2ApplicationCall;
import io.ktor.server.netty.http2.NettyHttp2ApplicationRequest;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Field;
import java.nio.channels.ClosedChannelException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ChannelHandler.Sharable
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0001\u0018\u0000 02\u00020\u00012\u00020\u0002:\u000201B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001a\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0012\u0010\u001d\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020\u00182\b\u0010\u001e\u001a\u0004\u0018\u00010\u001aH\u0016J\u0018\u0010#\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0002J\u001d\u0010&\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J\u0011\u0010*\u001a\u00020\u0013*\u0006\u0012\u0002\b\u00030+H\u0082\u0010J\u0014\u0010,\u001a\u00020\u0018*\u00020-2\u0006\u0010.\u001a\u00020/H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "Lkotlinx/coroutines/CoroutineScope;", "enginePipeline", "Lio/ktor/server/engine/EnginePipeline;", "application", "Lio/ktor/application/Application;", "callEventGroup", "Lio/netty/util/concurrent/EventExecutorGroup;", "userCoroutineContext", "Lkotlin/coroutines/CoroutineContext;", "(Lio/ktor/server/engine/EnginePipeline;Lio/ktor/application/Application;Lio/netty/util/concurrent/EventExecutorGroup;Lkotlin/coroutines/CoroutineContext;)V", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "handlerJob", "Lkotlinx/coroutines/CompletableDeferred;", "", "idField", "Ljava/lang/reflect/Field;", "Lio/netty/handler/codec/http2/Http2FrameStream;", "getIdField", "(Lio/netty/handler/codec/http2/Http2FrameStream;)Ljava/lang/reflect/Field;", "channelRead", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "message", "", "channelRegistered", "ctx", "exceptionCaught", "cause", "", "handlerRemoved", "startHttp2", "headers", "Lio/netty/handler/codec/http2/Http2Headers;", "startHttp2PushPromise", "builder", "Lio/ktor/response/ResponsePushBuilder;", "startHttp2PushPromise$ktor_server_netty", "findIdField", "Ljava/lang/Class;", "setId", "Lio/netty/handler/codec/http2/Http2StreamChannel;", "streamId", "", "Companion", "Http2ClosedChannelException", "ktor-server-netty"})
public final class NettyHttp2Handler
extends ChannelInboundHandlerAdapter
implements CoroutineScope {
    private final CompletableDeferred handlerJob;
    private final EnginePipeline enginePipeline;
    private final Application application;
    private final EventExecutorGroup callEventGroup;
    private final CoroutineContext userCoroutineContext;
    private static final AttributeKey<NettyHttp2ApplicationCall> ApplicationCallKey;
    public static final Companion Companion;

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.handlerJob;
    }

    public void channelRead(@NotNull ChannelHandlerContext context, @Nullable Object message) {
        block7: {
            Object object;
            block8: {
                Object object2;
                block9: {
                    Object object3;
                    block6: {
                        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                        object = message;
                        if (!(object instanceof Http2HeadersFrame)) break block6;
                        Http2Headers http2Headers = ((Http2HeadersFrame)message).headers();
                        Intrinsics.checkExpressionValueIsNotNull((Object)http2Headers, (String)"message.headers()");
                        this.startHttp2(context, http2Headers);
                        break block7;
                    }
                    if (!(object instanceof Http2DataFrame)) break block8;
                    object2 = NettyHttp2Handler.Companion.getApplicationCall(context);
                    if (object2 == null || (object2 = object2.getRequest()) == null) break block9;
                    Object $receiver = object3 = object2;
                    boolean bl = false;
                    boolean eof = ((Http2DataFrame)message).isEndStream();
                    ((NettyHttp2ApplicationRequest)((Object)$receiver)).getContentActor().offer(message);
                    if (eof) {
                        SendChannel.DefaultImpls.close$default(((NettyHttp2ApplicationRequest)((Object)$receiver)).getContentActor(), null, (int)1, null);
                    }
                    if ((object2 = object3) != null) break block7;
                }
                object2 = ((Http2DataFrame)message).release();
                break block7;
            }
            if (object instanceof Http2ResetFrame) {
                Object object4 = NettyHttp2Handler.Companion.getApplicationCall(context);
                if (object4 != null && (object4 = object4.getRequest()) != null) {
                    Object object5;
                    Object r = object5 = object4;
                    boolean bl = false;
                    Http2ClosedChannelException e = ((Http2ResetFrame)message).errorCode() == 0L ? null : new Http2ClosedChannelException(((Http2ResetFrame)message).errorCode());
                    ((NettyHttp2ApplicationRequest)((Object)r)).getContentActor().close((Throwable)e);
                }
            } else {
                context.fireChannelRead(message);
            }
        }
    }

    public void channelRegistered(@Nullable ChannelHandlerContext ctx) {
        block0: {
            ChannelHandlerContext channelHandlerContext;
            super.channelRegistered(ctx);
            ChannelHandlerContext channelHandlerContext2 = ctx;
            if (channelHandlerContext2 == null || (channelHandlerContext2 = channelHandlerContext2.pipeline()) == null) break block0;
            ChannelHandlerContext $receiver = channelHandlerContext = channelHandlerContext2;
            boolean bl = false;
            $receiver.addLast(this.callEventGroup, new ChannelHandler[]{(ChannelHandler)new NettyApplicationCallHandler(this.userCoroutineContext, this.enginePipeline)});
        }
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        this.handlerJob.completeExceptionally(cause);
        ctx.close();
    }

    public void handlerRemoved(@Nullable ChannelHandlerContext ctx) {
        super.handlerRemoved(ctx);
        this.handlerJob.cancel();
    }

    private final void startHttp2(ChannelHandlerContext context, Http2Headers headers2) {
        NettyRequestQueue requestQueue = new NettyRequestQueue(1, 1);
        NettyResponsePipeline responseWriter = new NettyResponsePipeline(context, WriterEncapsulation.Http2.INSTANCE, requestQueue, (CoroutineContext)this.handlerJob);
        NettyHttp2ApplicationCall call = new NettyHttp2ApplicationCall(this.application, context, headers2, this, this.handlerJob.plus((CoroutineContext)Dispatchers.getUnconfined()), this.userCoroutineContext);
        NettyHttp2Handler.Companion.setApplicationCall(context, call);
        requestQueue.schedule(call);
        requestQueue.close();
        responseWriter.ensureRunning();
    }

    public final void startHttp2PushPromise$ktor_server_netty(@NotNull ChannelHandlerContext context, @NotNull ResponsePushBuilder builder) {
        Http2StreamChannel child;
        String string;
        DefaultHttp2Headers defaultHttp2Headers;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        Channel channel = context.channel();
        if (channel == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.netty.handler.codec.http2.Http2StreamChannel");
        }
        Http2StreamChannel channel2 = (Http2StreamChannel)channel;
        int streamId = channel2.stream().id();
        ChannelHandler channelHandler = channel2.parent().pipeline().get(Http2MultiplexCodec.class);
        if (channelHandler == null) {
            Intrinsics.throwNpe();
        }
        Http2MultiplexCodec codec = (Http2MultiplexCodec)channelHandler;
        Http2Connection connection = codec.connection();
        ChannelHandlerContext rootContext = channel2.parent().pipeline().lastContext();
        int promisedStreamId = connection.local().incrementAndGetNextStreamId();
        DefaultHttp2Headers $receiver = defaultHttp2Headers = new DefaultHttp2Headers();
        boolean bl = false;
        URLBuilder url = builder.getUrl();
        ParametersBuilder parameters = url.getParameters();
        if (parameters.isEmpty()) {
            string = url.getEncodedPath();
        } else {
            StringBuilder stringBuilder;
            StringBuilder $receiver2 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $receiver2.append(url.getEncodedPath());
            $receiver2.append('?');
            HttpUrlEncodedKt.formUrlEncodeTo((Parameters)parameters.build(), (Appendable)$receiver2);
            String string2 = stringBuilder.toString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        }
        String pathAndQuery = string;
        $receiver.method((CharSequence)builder.getMethod().getValue());
        $receiver.authority((CharSequence)(builder.getUrl().getHost() + ":" + builder.getUrl().getPort()));
        $receiver.scheme((CharSequence)builder.getUrl().getProtocol().getName());
        $receiver.path((CharSequence)pathAndQuery);
        DefaultHttp2Headers headers2 = defaultHttp2Headers;
        Http2StreamChannelBootstrap bs = new Http2StreamChannelBootstrap(channel2.parent()).handler((ChannelHandler)this);
        Http2StreamChannel http2StreamChannel = child = (Http2StreamChannel)bs.open().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)http2StreamChannel, (String)"child");
        this.setId(http2StreamChannel, promisedStreamId);
        ChannelPromise promise = rootContext.newPromise();
        codec.encoder().writePushPromise(rootContext, streamId, promisedStreamId, (Http2Headers)headers2, 0, promise);
        ChannelPromise channelPromise = promise;
        Intrinsics.checkExpressionValueIsNotNull((Object)channelPromise, (String)"promise");
        if (channelPromise.isSuccess()) {
            ChannelHandlerContext channelHandlerContext = child.pipeline().firstContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)channelHandlerContext, (String)"child.pipeline().firstContext()");
            this.startHttp2(channelHandlerContext, (Http2Headers)headers2);
        } else {
            promise.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this, child, headers2){
                final /* synthetic */ NettyHttp2Handler this$0;
                final /* synthetic */ Http2StreamChannel $child;
                final /* synthetic */ DefaultHttp2Headers $headers;

                public final void operationComplete(Future<? super Void> future) {
                    future.get();
                    ChannelHandlerContext channelHandlerContext = this.$child.pipeline().firstContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)channelHandlerContext, (String)"child.pipeline().firstContext()");
                    NettyHttp2Handler.access$startHttp2(this.this$0, channelHandlerContext, (Http2Headers)this.$headers);
                }
                {
                    this.this$0 = nettyHttp2Handler;
                    this.$child = http2StreamChannel;
                    this.$headers = defaultHttp2Headers;
                }
            });
        }
    }

    private final void setId(@NotNull Http2StreamChannel $receiver, int streamId) {
        Http2FrameStream http2FrameStream = $receiver.stream();
        if (http2FrameStream == null) {
            Intrinsics.throwNpe();
        }
        Http2FrameStream stream = http2FrameStream;
        this.getIdField(stream).setInt(stream, streamId);
    }

    private final Field getIdField(@NotNull Http2FrameStream $receiver) {
        return this.findIdField($receiver.getClass());
    }

    private final Field findIdField(@NotNull Class<?> $receiver) {
        while (true) {
            Class<?> superclass;
            Field field;
            try {
                field = $receiver.getDeclaredField("id");
            }
            catch (NoSuchFieldException t) {
                field = null;
            }
            Field f = field;
            if (f != null) {
                f.setAccessible(true);
                return f;
            }
            if ($receiver.getSuperclass() == null) {
                throw (Throwable)new NoSuchFieldException("id field not found");
            }
            $receiver = superclass;
        }
    }

    public NettyHttp2Handler(@NotNull EnginePipeline enginePipeline, @NotNull Application application, @NotNull EventExecutorGroup callEventGroup, @NotNull CoroutineContext userCoroutineContext) {
        Intrinsics.checkParameterIsNotNull((Object)enginePipeline, (String)"enginePipeline");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)callEventGroup, (String)"callEventGroup");
        Intrinsics.checkParameterIsNotNull((Object)userCoroutineContext, (String)"userCoroutineContext");
        this.enginePipeline = enginePipeline;
        this.application = application;
        this.callEventGroup = callEventGroup;
        this.userCoroutineContext = userCoroutineContext;
        this.handlerJob = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    static {
        Companion = new Companion(null);
        ApplicationCallKey = AttributeKey.newInstance((String)"ktor.ApplicationCall");
    }

    public static final /* synthetic */ void access$startHttp2(NettyHttp2Handler $this, ChannelHandlerContext context, Http2Headers headers2) {
        $this.startHttp2(context, headers2);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler$Http2ClosedChannelException;", "Ljava/nio/channels/ClosedChannelException;", "errorCode", "", "(J)V", "getErrorCode", "()J", "message", "", "getMessage", "()Ljava/lang/String;", "ktor-server-netty"})
    private static final class Http2ClosedChannelException
    extends ClosedChannelException {
        private final long errorCode;

        @Override
        @NotNull
        public String getMessage() {
            return "Got close frame with code " + this.errorCode;
        }

        public final long getErrorCode() {
            return this.errorCode;
        }

        public Http2ClosedChannelException(long errorCode) {
            this.errorCode = errorCode;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\b\u001a\u0004\u0018\u00010\u0005*\u00020\t2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00058B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/ktor/server/netty/http2/NettyHttp2Handler$Companion;", "", "()V", "ApplicationCallKey", "Lio/netty/util/AttributeKey;", "Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "kotlin.jvm.PlatformType", "newValue", "applicationCall", "Lio/netty/channel/ChannelHandlerContext;", "getApplicationCall", "(Lio/netty/channel/ChannelHandlerContext;)Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;", "setApplicationCall", "(Lio/netty/channel/ChannelHandlerContext;Lio/ktor/server/netty/http2/NettyHttp2ApplicationCall;)V", "ktor-server-netty"})
    public static final class Companion {
        private final NettyHttp2ApplicationCall getApplicationCall(@NotNull ChannelHandlerContext $receiver) {
            return (NettyHttp2ApplicationCall)((Object)$receiver.channel().attr(ApplicationCallKey).get());
        }

        private final void setApplicationCall(@NotNull ChannelHandlerContext $receiver, NettyHttp2ApplicationCall newValue) {
            $receiver.channel().attr(ApplicationCallKey).set((Object)newValue);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

