/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.jetty;

import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.jetty.JettyApplicationEngineBase;
import io.ktor.server.jetty.JettyKtorHandler;
import io.ktor.util.DispatcherWithShutdown;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00020\u0001B&\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ktor/server/jetty/JettyApplicationEngine;", "Lio/ktor/server/jetty/JettyApplicationEngineBase;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "configure", "Lkotlin/Function1;", "Lio/ktor/server/jetty/JettyApplicationEngineBase$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "dispatcher", "Lio/ktor/util/DispatcherWithShutdown;", "start", "wait", "", "stop", "gracePeriodMillis", "", "timeoutMillis", "ktor-server-jetty"})
public final class JettyApplicationEngine
extends JettyApplicationEngineBase {
    @NotNull
    private final DispatcherWithShutdown dispatcher;

    public JettyApplicationEngine(@NotNull ApplicationEngineEnvironment environment, @NotNull Function1<? super JettyApplicationEngineBase.Configuration, Unit> configure) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        super(environment, configure);
        ThreadPool threadPool = this.getServer().getThreadPool();
        Intrinsics.checkNotNullExpressionValue((Object)threadPool, (String)"server.threadPool");
        this.dispatcher = new DispatcherWithShutdown(ExecutorsKt.from((Executor)((Executor)threadPool)));
    }

    @Override
    @NotNull
    public JettyApplicationEngine start(boolean wait) {
        this.getServer().setHandler((Handler)new JettyKtorHandler(this.getEnvironment(), (Function0<EnginePipeline>)((Function0)new PropertyReference0Impl((Object)this){

            @Nullable
            public Object get() {
                return ((JettyApplicationEngine)((Object)this.receiver)).getPipeline();
            }
        }), (CoroutineDispatcher)this.dispatcher, this.getConfiguration()));
        super.start(wait);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(long gracePeriodMillis, long timeoutMillis) {
        this.dispatcher.prepareShutdown();
        try {
            super.stop(gracePeriodMillis, timeoutMillis);
        }
        finally {
            this.dispatcher.completeShutdown();
        }
    }
}

