/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.jetty;

import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineJvmKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineAPI;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.jetty.JettyApplicationEngineBase;
import io.ktor.server.jetty.ServerInitializerKt;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import org.eclipse.jetty.server.Server;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001\u001cB(\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lio/ktor/server/jetty/JettyApplicationEngineBase;", "Lio/ktor/server/engine/BaseApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "configure", "Lkotlin/Function1;", "Lio/ktor/server/jetty/JettyApplicationEngineBase$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "cancellationDeferred", "Lkotlinx/coroutines/CompletableJob;", "configuration", "getConfiguration", "()Lio/ktor/server/jetty/JettyApplicationEngineBase$Configuration;", "server", "Lorg/eclipse/jetty/server/Server;", "getServer", "()Lorg/eclipse/jetty/server/Server;", "start", "wait", "", "stop", "gracePeriodMillis", "", "timeoutMillis", "toString", "", "Configuration", "ktor-server-jetty"})
public class JettyApplicationEngineBase
extends BaseApplicationEngine {
    @NotNull
    private final Configuration configuration;
    private CompletableJob cancellationDeferred;
    @NotNull
    private final Server server;

    @NotNull
    protected final Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    protected final Server getServer() {
        return this.server;
    }

    @NotNull
    public JettyApplicationEngineBase start(boolean wait) {
        this.getEnvironment().start();
        this.server.start();
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)this);
        if (wait) {
            this.server.join();
            ApplicationEngineJvmKt.stop((ApplicationEngine)this, (long)1L, (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
        return this;
    }

    public void stop(long gracePeriodMillis, long timeoutMillis) {
        CompletableJob completableJob = this.cancellationDeferred;
        if (completableJob != null) {
            completableJob.complete();
        }
        this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        this.server.setStopTimeout(timeoutMillis);
        this.server.stop();
        this.server.destroy();
        this.getEnvironment().stop();
    }

    @NotNull
    public String toString() {
        return "Jetty(" + this.getEnvironment() + ')';
    }

    /*
     * WARNING - void declaration
     */
    @EngineAPI
    public JettyApplicationEngineBase(@NotNull ApplicationEngineEnvironment environment, @NotNull Function1<? super Configuration, Unit> configure) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        super(environment, null, 2, null);
        Configuration configuration = new Configuration();
        boolean bl = false;
        boolean bl2 = false;
        configure.invoke((Object)configuration);
        this.configuration = configuration;
        configuration = new Server();
        bl = false;
        bl2 = false;
        Configuration configuration2 = configuration;
        JettyApplicationEngineBase jettyApplicationEngineBase = this;
        boolean bl3 = false;
        this.configuration.getConfigureServer().invoke((Object)$this$apply);
        ServerInitializerKt.initializeServer((Server)$this$apply, environment);
        Unit unit = Unit.INSTANCE;
        jettyApplicationEngineBase.server = configuration;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/server/jetty/JettyApplicationEngineBase$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "()V", "configureServer", "Lkotlin/Function1;", "Lorg/eclipse/jetty/server/Server;", "", "Lkotlin/ExtensionFunctionType;", "getConfigureServer", "()Lkotlin/jvm/functions/Function1;", "setConfigureServer", "(Lkotlin/jvm/functions/Function1;)V", "ktor-server-jetty"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        @NotNull
        private Function1<? super Server, Unit> configureServer = configureServer.1.INSTANCE;

        @NotNull
        public final Function1<Server, Unit> getConfigureServer() {
            return this.configureServer;
        }

        public final void setConfigureServer(@NotNull Function1<? super Server, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.configureServer = function1;
        }
    }
}

