/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.engine.ClassLoaderDelegate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u0006\u0012\u0002\b\u00030\u0006H\u0002\u001a\u0014\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\b*\u00020\u0003H\u0002\u001a\u0014\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\b*\u00020\u0003H\u0002\u00a8\u0006\n"}, d2={"allURLs", "", "Ljava/net/URL;", "Ljava/lang/ClassLoader;", "findURLClassPathField", "Ljava/lang/reflect/Field;", "Ljava/lang/Class;", "urlClassPath", "", "urlClassPathByPackagesList", "ktor-server-host-common"})
public final class ClassLoadersKt {
    @NotNull
    public static final Set<URL> allURLs(@NotNull ClassLoader $this$allURLs) {
        Set<URL> parentUrls;
        Intrinsics.checkNotNullParameter((Object)$this$allURLs, (String)"<this>");
        ClassLoader classLoader = $this$allURLs.getParent();
        Set<URL> set = parentUrls = classLoader == null ? SetsKt.emptySet() : ClassLoadersKt.allURLs(classLoader);
        if ($this$allURLs instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)$this$allURLs).getURLs();
            Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"urLs");
            Set urls = CollectionsKt.toSet((Iterable)ArraysKt.filterNotNull((Object[])uRLArray));
            return SetsKt.plus((Set)urls, (Iterable)parentUrls);
        }
        List<URL> list = ClassLoadersKt.urlClassPath($this$allURLs);
        if (list == null) {
            return parentUrls;
        }
        List<URL> ucp = list;
        return SetsKt.plus(parentUrls, (Iterable)ucp);
    }

    private static final List<URL> urlClassPath(ClassLoader $this$urlClassPath) {
        try {
            Object[] urls;
            Field field = ClassLoadersKt.findURLClassPathField($this$urlClassPath.getClass());
            if (field == null) {
                return null;
            }
            Field ucpField = field;
            ucpField.setAccessible(true);
            Object object = ucpField.get($this$urlClassPath);
            if (object == null) {
                return null;
            }
            Object ucpInstance = object;
            Method method = ucpInstance.getClass().getMethod("getURLs", new Class[0]);
            if (method == null) {
                return null;
            }
            Method getURLsMethod = method;
            getURLsMethod.setAccessible(true);
            Object[] objectArray = urls = (URL[])getURLsMethod.invoke(ucpInstance, new Object[0]);
            return objectArray == null ? null : ArraysKt.toList((Object[])objectArray);
        }
        catch (Throwable _) {
            List list;
            try {
                list = ClassLoadersKt.urlClassPathByPackagesList($this$urlClassPath);
            }
            catch (Throwable _2) {
                list = null;
            }
            return list;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List<URL> urlClassPathByPackagesList(ClassLoader $this$urlClassPathByPackagesList) {
        void $this$flatMapTo$iv$iv;
        Object object;
        void $this$flatMapTo$iv;
        char[] it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = new ClassLoaderDelegate($this$urlClassPathByPackagesList).packagesList$ktor_server_host_common();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = StringsKt.replace$default((String)it, (char)'.', (char)'/', (boolean)false, (int)4, null);
            collection.add(string2);
        }
        $this$map$iv = (List)destination$iv$iv;
        Collection destination$iv = new HashSet();
        boolean $i$f$flatMapTo22 = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            void $this$mapTo$iv$iv2;
            String packageName = (String)element$iv;
            boolean bl = false;
            it = new char[]{'/'};
            List segments = StringsKt.split$default((CharSequence)packageName, (char[])it, (boolean)false, (int)0, (int)6, null);
            Iterable $this$map$iv2 = (Iterable)new IntRange(1, segments.size());
            boolean $i$f$map2 = false;
            object = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            Iterator iterator = $this$mapTo$iv$iv2.iterator();
            while (iterator.hasNext()) {
                void it2;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                String string = CollectionsKt.joinToString$default((Iterable)segments.subList(0, (int)it2), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
                collection.add(string);
            }
            Iterable list$iv = CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Object)packageName);
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        Iterable $this$sortedBy$iv = destination$iv;
        boolean $i$f$sortedBy = false;
        $i$f$flatMapTo22 = false;
        List allPackagePaths = CollectionsKt.plus((Collection)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl;
                char character;
                char element$iv;
                int n;
                boolean bl2 = false;
                String it = (String)a;
                boolean bl3 = false;
                CharSequence $this$count$iv = it;
                boolean $i$f$count = false;
                int count$iv = 0;
                CharSequence charSequence = $this$count$iv;
                for (n = 0; n < charSequence.length(); ++n) {
                    character = element$iv = charSequence.charAt(n);
                    bl = false;
                    if (!(character == '/')) continue;
                    ++count$iv;
                }
                it = (String)b;
                Comparable comparable = Integer.valueOf(count$iv);
                bl3 = false;
                $this$count$iv = it;
                $i$f$count = false;
                count$iv = 0;
                charSequence = $this$count$iv;
                for (n = 0; n < charSequence.length(); ++n) {
                    character = element$iv = charSequence.charAt(n);
                    bl = false;
                    if (!(character == '/')) continue;
                    ++count$iv;
                }
                Integer n2 = count$iv;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n2);
            }
        }), (Object)"");
        Iterable $this$flatMap$iv = allPackagePaths;
        boolean $i$f$flatMap = false;
        Iterable $i$f$flatMapTo22 = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list;
            String path = (String)element$iv$iv;
            boolean bl = false;
            Enumeration<URL> enumeration = $this$urlClassPathByPackagesList.getResources(path);
            if (enumeration == null) {
                list = null;
            } else {
                object = enumeration;
                boolean bl3 = false;
                ArrayList arrayList = Collections.list(object);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
                list = arrayList;
            }
            List list2 = list;
            Iterable list$iv$iv = list2 == null ? CollectionsKt.emptyList() : list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$distinctBy$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            URL it3 = (URL)e$iv;
            boolean bl = false;
            String string = it3.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.path");
            String key$iv = StringsKt.substringBefore$default((String)string, (char)'!', null, (int)2, null);
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        return list$iv;
    }

    private static final Field findURLClassPathField(Class<?> $this$findURLClassPathField) {
        Object object;
        Object object2;
        block3: {
            object2 = $this$findURLClassPathField.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"declaredFields");
            Object[] $this$firstOrNull$iv = object2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Field it = (Field)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"ucp") && Intrinsics.areEqual((Object)it.getType().getSimpleName(), (Object)"URLClassPath"))) continue;
                object = element$iv;
                break block3;
            }
            object = null;
        }
        Field field = (Field)object;
        if (field != null) {
            object2 = field;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            return it;
        }
        object2 = $this$findURLClassPathField.getSuperclass();
        Field field2 = field = object2 == null ? null : ClassLoadersKt.findURLClassPathField(object2);
        if (field == null) {
            return null;
        }
        return field;
    }
}

