/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.application.Application;
import io.ktor.application.ApplicationCall;
import io.ktor.application.ApplicationCallPipeline;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.response.ApplicationResponse;
import io.ktor.response.ResponseTypeKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.DefaultEnginePipelineKt;
import io.ktor.server.engine.DefaultTransformKt;
import io.ktor.server.engine.EngineAPI;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.pipeline.PipelineContext;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@EngineAPI
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001:\u0001\u000eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lio/ktor/server/engine/BaseApplicationEngine;", "Lio/ktor/server/engine/ApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "pipeline", "Lio/ktor/server/engine/EnginePipeline;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lio/ktor/server/engine/EnginePipeline;)V", "getEnvironment", "()Lio/ktor/server/engine/ApplicationEngineEnvironment;", "getPipeline", "()Lio/ktor/server/engine/EnginePipeline;", "installDefaultInterceptors", "", "Lio/ktor/application/Application;", "Configuration", "ktor-server-host-common"})
public abstract class BaseApplicationEngine
implements ApplicationEngine {
    @NotNull
    private final ApplicationEngineEnvironment environment;
    @NotNull
    private final EnginePipeline pipeline;

    public BaseApplicationEngine(@NotNull ApplicationEngineEnvironment environment2, @NotNull EnginePipeline pipeline) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)((Object)pipeline), (String)"pipeline");
        this.environment = environment2;
        this.pipeline = pipeline;
        BaseApplicationResponse.Companion.setupSendPipeline(this.pipeline.getSendPipeline());
        this.environment.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarting(), (Function1)new Function1<Application, Unit>(){

            public final void invoke(@NotNull Application it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                it.getReceivePipeline().merge((Pipeline)this.getPipeline().getReceivePipeline());
                it.getSendPipeline().merge((Pipeline)this.getPipeline().getSendPipeline());
                DefaultTransformKt.installDefaultTransformations(it.getReceivePipeline());
                DefaultTransformKt.installDefaultTransformations(it.getSendPipeline());
                this.installDefaultInterceptors(it);
            }
        });
        this.environment.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarted(), (Function1)new Function1<Application, Unit>(){

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Application it) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                Iterable iterable = this.getEnvironment().getConnectors();
                BaseApplicationEngine baseApplicationEngine = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    EngineConnectorConfig it2 = (EngineConnectorConfig)element$iv;
                    boolean bl = false;
                    Logger logger = baseApplicationEngine.getEnvironment().getLog();
                    StringBuilder stringBuilder = new StringBuilder().append("Responding at ");
                    String string = it2.getType().getName();
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                    logger.info(stringBuilder.append(string3).append("://").append(it2.getHost()).append(':').append(it2.getPort()).toString());
                }
            }
        });
    }

    public /* synthetic */ BaseApplicationEngine(ApplicationEngineEnvironment applicationEngineEnvironment, EnginePipeline enginePipeline, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            enginePipeline = DefaultEnginePipelineKt.defaultEnginePipeline(applicationEngineEnvironment);
        }
        this(applicationEngineEnvironment, enginePipeline);
    }

    @Override
    @NotNull
    public final ApplicationEngineEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final EnginePipeline getPipeline() {
        return this.pipeline;
    }

    private final void installDefaultInterceptors(Application $this$installDefaultInterceptors) {
        $this$installDefaultInterceptors.intercept(ApplicationCallPipeline.ApplicationPhase.getFallback(), (Function3)new Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object>(null){
            int label;
            private /* synthetic */ Object L$0;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        PipelineContext $this$intercept;
                        ResultKt.throwOnFailure((Object)object);
                        PipelineContext $this$call$iv = $this$intercept = (PipelineContext)this.L$0;
                        boolean $i$f$getCall = false;
                        if (((ApplicationCall)$this$call$iv.getContext()).getResponse().status() != null) return Unit.INSTANCE;
                        $this$call$iv = $this$intercept;
                        $i$f$getCall = false;
                        ApplicationCall $this$respond$iv = (ApplicationCall)$this$call$iv.getContext();
                        HttpStatusCode message$iv = HttpStatusCode.Companion.getNotFound();
                        boolean $i$f$respondWithType = false;
                        if (!(message$iv instanceof OutgoingContent || message$iv instanceof String || message$iv instanceof byte[])) {
                            try {
                                ResponseTypeKt.setResponseType((ApplicationResponse)$this$respond$iv.getResponse(), (KType)Reflection.typeOf(HttpStatusCode.class));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        this.label = 1;
                        Object object3 = $this$respond$iv.getResponse().getPipeline().execute((Object)$this$respond$iv, (Object)message$iv, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean $i$f$respondWithType = false;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull PipelineContext<Unit, ApplicationCall> p1, @NotNull Unit p2, @Nullable Continuation<? super Unit> p3) {
                Function3<PipelineContext<Unit, ApplicationCall>, Unit, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                function3.L$0 = p1;
                return function3.invokeSuspend((Object)Unit.INSTANCE);
            }
        });
    }

    @Override
    @Deprecated(message="Binary compatibility.", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ void stop(long gracePeriod, long timeout, TimeUnit timeUnit) {
        ApplicationEngine.DefaultImpls.stop(this, gracePeriod, timeout, timeUnit);
    }

    @Override
    @NotNull
    public Application getApplication() {
        return ApplicationEngine.DefaultImpls.getApplication(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "()V", "ktor-server-host-common"})
    public static class Configuration
    extends ApplicationEngine.Configuration {
    }
}

