/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.application.Application;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.DefaultEnginePipelineKt;
import io.ktor.server.engine.EngineAPI;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EnginePipeline;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@EngineAPI
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b'\u0018\u00002\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lio/ktor/server/engine/BaseApplicationEngine;", "Lio/ktor/server/engine/ApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "pipeline", "Lio/ktor/server/engine/EnginePipeline;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lio/ktor/server/engine/EnginePipeline;)V", "application", "Lio/ktor/application/Application;", "getApplication", "()Lio/ktor/application/Application;", "getEnvironment", "()Lio/ktor/server/engine/ApplicationEngineEnvironment;", "getPipeline", "()Lio/ktor/server/engine/EnginePipeline;", "Configuration", "ktor-server-host-common"})
public abstract class BaseApplicationEngine
implements ApplicationEngine {
    @NotNull
    private final ApplicationEngineEnvironment environment;
    @NotNull
    private final EnginePipeline pipeline;

    @NotNull
    public final Application getApplication() {
        return this.environment.getApplication();
    }

    @Override
    @NotNull
    public final ApplicationEngineEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public final EnginePipeline getPipeline() {
        return this.pipeline;
    }

    public BaseApplicationEngine(@NotNull ApplicationEngineEnvironment environment2, @NotNull EnginePipeline pipeline) {
        Intrinsics.checkParameterIsNotNull((Object)environment2, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)((Object)pipeline), (String)"pipeline");
        this.environment = environment2;
        this.pipeline = pipeline;
        this.environment.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarting(), (Function1)1.INSTANCE);
        this.environment.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarted(), (Function1)new Function1<Application, Unit>(){

            public final void invoke(@NotNull Application it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Iterable $receiver$iv = this.getEnvironment().getConnectors();
                for (Object element$iv : $receiver$iv) {
                    String string;
                    EngineConnectorConfig it2 = (EngineConnectorConfig)element$iv;
                    String string2 = it2.getType().getName();
                    StringBuilder stringBuilder = new StringBuilder().append("Responding at ");
                    Logger logger = this.getEnvironment().getLog();
                    String string3 = string2;
                    if (string3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                    logger.info(stringBuilder.append(string).append("://").append(it2.getHost()).append(':').append(it2.getPort()).toString());
                }
            }
        });
    }

    public /* synthetic */ BaseApplicationEngine(ApplicationEngineEnvironment applicationEngineEnvironment, EnginePipeline enginePipeline, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            enginePipeline = DefaultEnginePipelineKt.defaultEnginePipeline(applicationEngineEnvironment);
        }
        this(applicationEngineEnvironment, enginePipeline);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "Lio/ktor/server/engine/ApplicationEngine$Configuration;", "()V", "ktor-server-host-common"})
    public static class Configuration
    extends ApplicationEngine.Configuration {
    }
}

