/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.cio;

import io.ktor.util.LoggingKt;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineExceptionHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0018\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/ktor/server/cio/KtorUncaughtExceptionHandler;", "Lkotlinx/coroutines/CoroutineExceptionHandler;", "()V", "key", "Lkotlin/coroutines/CoroutineContext$Key;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "handleException", "", "context", "Lkotlin/coroutines/CoroutineContext;", "exception", "", "ktor-server-cio"})
final class KtorUncaughtExceptionHandler
implements CoroutineExceptionHandler {
    private final Logger logger = LoggerFactory.getLogger(KtorUncaughtExceptionHandler.class);

    @NotNull
    public CoroutineContext.Key<?> getKey() {
        return (CoroutineContext.Key)CoroutineExceptionHandler.Key;
    }

    public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (exception instanceof CancellationException) {
            return;
        }
        Logger logger = this.logger;
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
        LoggingKt.error((Logger)logger, (Throwable)exception);
    }

    public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
        Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
        return (R)CoroutineExceptionHandler.DefaultImpls.fold((CoroutineExceptionHandler)this, initial, operation);
    }

    @Nullable
    public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        return (E)CoroutineExceptionHandler.DefaultImpls.get((CoroutineExceptionHandler)this, key);
    }

    @NotNull
    public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        return CoroutineExceptionHandler.DefaultImpls.minusKey((CoroutineExceptionHandler)this, key);
    }

    @NotNull
    public CoroutineContext plus(@NotNull CoroutineContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return CoroutineExceptionHandler.DefaultImpls.plus((CoroutineExceptionHandler)this, (CoroutineContext)context);
    }
}

