/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.plugins.calllogging;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.plugins.calllogging.CallLoggingKt;
import io.ktor.server.plugins.calllogging.MDCEntry;
import io.ktor.server.request.ApplicationRequest;
import io.ktor.server.request.ApplicationRequestPropertiesKt;
import io.ktor.util.date.DateJvmKt;
import io.ktor.utils.io.KtorDsl;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.event.Level;

@KtorDsl
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u00020\b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\t\u0010\nJ+\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u0004\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0011\u001a\u00020\b2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\u0004\b\u0011\u0010\nJ\u001b\u0010\u0014\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010\u0003J\r\u0010\u0017\u001a\u00020\b\u00a2\u0006\u0004\b\u0017\u0010\u0003J\u0017\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0013\u0010\u001e\u001a\u00020\u000b*\u00020\u001bH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010!\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010!\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010%\u001a\u00020$H\u0002\u00a2\u0006\u0004\b!\u0010&R(\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010'\u001a\u0004\b(\u0010)\"\u0004\b*\u0010\u0015R,\u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040+8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R \u00101\u001a\b\u0012\u0004\u0012\u0002000+8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b1\u0010-\u001a\u0004\b2\u0010/R.\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000b0\u00048\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u0010\nR\"\u00108\u001a\u00020\u00068\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\"\u0010>\u001a\u00020\u00068\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b>\u00109\u001a\u0004\b?\u0010;\"\u0004\b@\u0010=R\"\u0010B\u001a\u00020A8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bB\u0010C\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR$\u0010I\u001a\u0004\u0018\u00010H8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bI\u0010J\u001a\u0004\bK\u0010L\"\u0004\bM\u0010N\u00a8\u0006O"}, d2={"Lio/ktor/server/plugins/calllogging/CallLoggingConfig;", "", "<init>", "()V", "Lkotlin/Function1;", "Lio/ktor/server/application/ApplicationCall;", "", "predicate", "", "filter", "(Lkotlin/jvm/functions/Function1;)V", "", "name", "provider", "mdc", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "formatter", "format", "Lkotlin/Function0;", "", "clock", "(Lkotlin/jvm/functions/Function0;)V", "disableDefaultColors", "disableForStaticContent", "call", "defaultFormat", "(Lio/ktor/server/application/ApplicationCall;)Ljava/lang/String;", "Lio/ktor/server/request/ApplicationRequest;", "toLogStringWithColors$ktor_server_call_logging", "(Lio/ktor/server/request/ApplicationRequest;)Ljava/lang/String;", "toLogStringWithColors", "Lio/ktor/http/HttpStatusCode;", "status", "colored", "(Lio/ktor/http/HttpStatusCode;)Ljava/lang/String;", "value", "Lorg/fusesource/jansi/Ansi$Color;", "color", "(Ljava/lang/Object;Lorg/fusesource/jansi/Ansi$Color;)Ljava/lang/String;", "Lkotlin/jvm/functions/Function0;", "getClock$ktor_server_call_logging", "()Lkotlin/jvm/functions/Function0;", "setClock$ktor_server_call_logging", "", "filters", "Ljava/util/List;", "getFilters$ktor_server_call_logging", "()Ljava/util/List;", "Lio/ktor/server/plugins/calllogging/MDCEntry;", "mdcEntries", "getMdcEntries$ktor_server_call_logging", "formatCall", "Lkotlin/jvm/functions/Function1;", "getFormatCall$ktor_server_call_logging", "()Lkotlin/jvm/functions/Function1;", "setFormatCall$ktor_server_call_logging", "isColorsEnabled", "Z", "isColorsEnabled$ktor_server_call_logging", "()Z", "setColorsEnabled$ktor_server_call_logging", "(Z)V", "ignoreStaticContent", "getIgnoreStaticContent$ktor_server_call_logging", "setIgnoreStaticContent$ktor_server_call_logging", "Lorg/slf4j/event/Level;", "level", "Lorg/slf4j/event/Level;", "getLevel", "()Lorg/slf4j/event/Level;", "setLevel", "(Lorg/slf4j/event/Level;)V", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "setLogger", "(Lorg/slf4j/Logger;)V", "ktor-server-call-logging"})
public final class CallLoggingConfig {
    @NotNull
    private Function0<Long> clock = CallLoggingConfig::clock$lambda$0;
    @NotNull
    private final List<Function1<ApplicationCall, Boolean>> filters = new ArrayList();
    @NotNull
    private final List<MDCEntry> mdcEntries = new ArrayList();
    @NotNull
    private Function1<? super ApplicationCall, String> formatCall = (Function1)new Function1<ApplicationCall, String>((Object)this){

        public final String invoke(ApplicationCall p0) {
            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
            return CallLoggingConfig.access$defaultFormat((CallLoggingConfig)this.receiver, p0);
        }
    };
    private boolean isColorsEnabled = true;
    private boolean ignoreStaticContent;
    @NotNull
    private Level level = Level.INFO;
    @Nullable
    private Logger logger;

    @NotNull
    public final Function0<Long> getClock$ktor_server_call_logging() {
        return this.clock;
    }

    public final void setClock$ktor_server_call_logging(@NotNull Function0<Long> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.clock = function0;
    }

    @NotNull
    public final List<Function1<ApplicationCall, Boolean>> getFilters$ktor_server_call_logging() {
        return this.filters;
    }

    @NotNull
    public final List<MDCEntry> getMdcEntries$ktor_server_call_logging() {
        return this.mdcEntries;
    }

    @NotNull
    public final Function1<ApplicationCall, String> getFormatCall$ktor_server_call_logging() {
        return this.formatCall;
    }

    public final void setFormatCall$ktor_server_call_logging(@NotNull Function1<? super ApplicationCall, String> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.formatCall = function1;
    }

    public final boolean isColorsEnabled$ktor_server_call_logging() {
        return this.isColorsEnabled;
    }

    public final void setColorsEnabled$ktor_server_call_logging(boolean bl) {
        this.isColorsEnabled = bl;
    }

    public final boolean getIgnoreStaticContent$ktor_server_call_logging() {
        return this.ignoreStaticContent;
    }

    public final void setIgnoreStaticContent$ktor_server_call_logging(boolean bl) {
        this.ignoreStaticContent = bl;
    }

    @NotNull
    public final Level getLevel() {
        return this.level;
    }

    public final void setLevel(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"<set-?>");
        this.level = level;
    }

    @Nullable
    public final Logger getLogger() {
        return this.logger;
    }

    public final void setLogger(@Nullable Logger logger) {
        this.logger = logger;
    }

    public final void filter(@NotNull Function1<? super ApplicationCall, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        this.filters.add(predicate);
    }

    public final void mdc(@NotNull String name, @NotNull Function1<? super ApplicationCall, String> provider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        this.mdcEntries.add(new MDCEntry(name, provider));
    }

    public final void format(@NotNull Function1<? super ApplicationCall, String> formatter) {
        Intrinsics.checkNotNullParameter(formatter, (String)"formatter");
        this.formatCall = formatter;
    }

    public final void clock(@NotNull Function0<Long> clock) {
        Intrinsics.checkNotNullParameter(clock, (String)"clock");
        this.clock = clock;
    }

    public final void disableDefaultColors() {
        this.isColorsEnabled = false;
    }

    public final void disableForStaticContent() {
        this.ignoreStaticContent = true;
    }

    private final String defaultFormat(ApplicationCall call) {
        Comparable status;
        HttpStatusCode httpStatusCode = call.getResponse().status();
        Comparable comparable = status = httpStatusCode != null ? (Comparable)httpStatusCode : (Comparable)((Object)"Unhandled");
        return Intrinsics.areEqual((Object)status, (Object)HttpStatusCode.Companion.getFound()) ? this.colored((HttpStatusCode)status) + ": " + this.toLogStringWithColors$ktor_server_call_logging(call.getRequest()) + " -> " + call.getResponse().getHeaders().get(HttpHeaders.INSTANCE.getLocation()) : (Intrinsics.areEqual((Object)status, (Object)"Unhandled") ? this.colored(status, Ansi.Color.RED) + ": " + this.toLogStringWithColors$ktor_server_call_logging(call.getRequest()) : this.colored((HttpStatusCode)status) + ": " + this.toLogStringWithColors$ktor_server_call_logging(call.getRequest()));
    }

    @NotNull
    public final String toLogStringWithColors$ktor_server_call_logging(@NotNull ApplicationRequest $this$toLogStringWithColors) {
        Intrinsics.checkNotNullParameter((Object)$this$toLogStringWithColors, (String)"<this>");
        return this.colored(ApplicationRequestPropertiesKt.getHttpMethod((ApplicationRequest)$this$toLogStringWithColors).getValue(), Ansi.Color.CYAN) + " - " + ApplicationRequestPropertiesKt.path((ApplicationRequest)$this$toLogStringWithColors) + " in " + CallLoggingKt.processingTimeMillis($this$toLogStringWithColors.getCall(), this.clock) + "ms";
    }

    private final String colored(HttpStatusCode status) {
        HttpStatusCode httpStatusCode;
        try {
            if (this.isColorsEnabled && !AnsiConsole.isInstalled()) {
                AnsiConsole.systemInstall();
            }
        }
        catch (Throwable cause) {
            this.isColorsEnabled = false;
        }
        return Intrinsics.areEqual((Object)(httpStatusCode = status), (Object)HttpStatusCode.Companion.getFound()) || Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getOK()) || Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getAccepted()) || Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getCreated()) ? this.colored(status, Ansi.Color.GREEN) : (Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getContinue()) || Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getProcessing()) || Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getPartialContent()) || Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getNotModified()) || Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getUseProxy()) || Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getUpgradeRequired()) || Intrinsics.areEqual((Object)httpStatusCode, (Object)HttpStatusCode.Companion.getNoContent()) ? this.colored(status, Ansi.Color.YELLOW) : this.colored(status, Ansi.Color.RED));
    }

    private final String colored(Object value, Ansi.Color color) {
        String string;
        if (this.isColorsEnabled) {
            String string2 = Ansi.ansi().fg(color).a(value).reset().toString();
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = value.toString();
        }
        return string;
    }

    private static final long clock$lambda$0() {
        return DateJvmKt.getTimeMillis();
    }

    public static final /* synthetic */ String access$defaultFormat(CallLoggingConfig $this, ApplicationCall call) {
        return $this.defaultFormat(call);
    }
}

