/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.serialization;

import io.ktor.application.ApplicationCall;
import io.ktor.response.ApplicationResponse;
import io.ktor.response.ResponseTypeKt;
import io.ktor.util.pipeline.PipelineContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.jvm.KTypesJvm;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\u001a\u0014\u0010\u0000\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a*\u0010\n\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u001c\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0001*\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"arraySerializer", "Lkotlinx/serialization/KSerializer;", "type", "Lkotlin/reflect/KType;", "guessSerializer", "value", "", "module", "Lkotlinx/serialization/modules/SerializersModule;", "serializerByTypeInfo", "serializerFromResponseType", "context", "Lio/ktor/util/pipeline/PipelineContext;", "Lio/ktor/application/ApplicationCall;", "elementSerializer", "", "ktor-serialization"})
public final class SerializerLookupKt {
    @NotNull
    public static final KSerializer<?> serializerByTypeInfo(@NotNull KType type) {
        KClass classifierClass;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KClassifier kClassifier = type.getClassifier();
        KClass kClass = classifierClass = kClassifier instanceof KClass ? (KClass)kClassifier : null;
        if (classifierClass != null && JvmClassMappingKt.getJavaClass((KClass)classifierClass).isArray()) {
            return SerializerLookupKt.arraySerializer(type);
        }
        return SerializersKt.serializer((KType)type);
    }

    private static final KSerializer<?> arraySerializer(KType type) {
        KType kType = ((KTypeProjection)type.getArguments().get(0)).getType();
        if (kType == null) {
            String string = "Array<*> is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KType elementType = kType;
        KSerializer<?> elementSerializer = SerializerLookupKt.serializerByTypeInfo(elementType);
        return BuiltinSerializersKt.ArraySerializer((KClass)KTypesJvm.getJvmErasure((KType)elementType), elementSerializer);
    }

    @Nullable
    public static final KSerializer<?> serializerFromResponseType(@NotNull PipelineContext<Object, ApplicationCall> context, @NotNull SerializersModule module) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        PipelineContext<Object, ApplicationCall> $this$call$iv = context;
        boolean $i$f$getCall = false;
        KType kType = ResponseTypeKt.getResponseType((ApplicationResponse)((ApplicationCall)$this$call$iv.getContext()).getResponse());
        if (kType == null) {
            return null;
        }
        KType responseType = kType;
        return SerializersKt.serializer((SerializersModule)module, (KType)responseType);
    }

    @NotNull
    public static final KSerializer<?> guessSerializer(@NotNull Object value, @NotNull SerializersModule module) {
        KSerializer kSerializer;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = value;
        if (object instanceof JsonElement) {
            kSerializer = JsonElement.Companion.serializer();
        } else if (object instanceof List) {
            kSerializer = BuiltinSerializersKt.ListSerializer(SerializerLookupKt.elementSerializer((Collection)value, module));
        } else if (object instanceof Set) {
            kSerializer = BuiltinSerializersKt.SetSerializer(SerializerLookupKt.elementSerializer((Collection)value, module));
        } else if (object instanceof Map) {
            kSerializer = BuiltinSerializersKt.MapSerializer(SerializerLookupKt.elementSerializer(((Map)value).keySet(), module), SerializerLookupKt.elementSerializer(((Map)value).values(), module));
        } else if (object instanceof Map.Entry) {
            Object object2 = ((Map.Entry)value).getKey();
            if (object2 == null) {
                String string = "Map.Entry(null, ...) is not supported";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KSerializer<?> kSerializer2 = SerializerLookupKt.guessSerializer(object2, module);
            object2 = ((Map.Entry)value).getValue();
            if (object2 == null) {
                String string = "Map.Entry(..., null) is not supported)";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            kSerializer = BuiltinSerializersKt.MapEntrySerializer(kSerializer2, SerializerLookupKt.guessSerializer(object2, module));
        } else if (object instanceof Object[]) {
            KClass kClass;
            Class<?> clazz = value.getClass().getComponentType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"value.javaClass.componentType");
            KType componentType = KClassifiers.getStarProjectedType((KClassifier)((KClassifier)JvmClassMappingKt.getKotlinClass(clazz)));
            Object object3 = componentType.getClassifier();
            KClass kClass2 = kClass = object3 instanceof KClass ? (KClass)object3 : null;
            if (kClass == null) {
                object3 = Intrinsics.stringPlus((String)"Unsupported component type ", (Object)componentType);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(object3.toString());
            }
            KClass componentClass = kClass;
            kSerializer = BuiltinSerializersKt.ArraySerializer((KClass)componentClass, SerializerLookupKt.serializerByTypeInfo(componentType));
        } else {
            KSerializer kSerializer3 = SerializersModule.getContextual$default((SerializersModule)module, (KClass)Reflection.getOrCreateKotlinClass(value.getClass()), null, (int)2, null);
            kSerializer = kSerializer3 == null ? SerializersKt.serializer((KClass)Reflection.getOrCreateKotlinClass(value.getClass())) : kSerializer3;
        }
        return kSerializer;
    }

    /*
     * WARNING - void declaration
     */
    private static final KSerializer<?> elementSerializer(Collection<?> $this$elementSerializer, SerializersModule module) {
        boolean bl;
        KSerializer selected;
        block11: {
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $this$elementSerializer;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KSerializer<?> kSerializer;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object value = element$iv$iv;
                boolean bl3 = false;
                Object t = value;
                if (t == null) {
                    kSerializer = null;
                } else {
                    Object t2 = t;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object it = t2;
                    boolean bl6 = false;
                    kSerializer = SerializerLookupKt.guessSerializer(it, module);
                }
                if (kSerializer == null) continue;
                KSerializer<?> kSerializer2 = kSerializer;
                boolean bl7 = false;
                boolean bl8 = false;
                KSerializer<?> it$iv$iv = kSerializer2;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$distinctBy$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy2 = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                KSerializer it = (KSerializer)e$iv;
                boolean bl10 = false;
                String key$iv = it.getDescriptor().getSerialName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List serializers = list$iv;
            if (serializers.size() > 1) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv22;
                Iterable $i$f$distinctBy2 = serializers;
                String string = "Serializing collections of different element types is not yet supported. Selected serializers: ";
                boolean $i$f$map = false;
                list$iv = $this$map$iv22;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    element$iv$iv$iv = (KSerializer)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl11 = false;
                    String string2 = it.getDescriptor().getSerialName();
                    collection.add(string2);
                }
                collection = (List)destination$iv$iv2;
                String message = Intrinsics.stringPlus((String)string, (Object)collection);
                boolean $this$map$iv22 = false;
                throw (Throwable)new IllegalStateException(message.toString());
            }
            KSerializer $this$map$iv22 = (KSerializer)CollectionsKt.singleOrNull((List)serializers);
            KSerializer kSerializer = selected = $this$map$iv22 == null ? BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE) : $this$map$iv22;
            if (selected.getDescriptor().isNullable()) {
                return selected;
            }
            Iterable $this$any$iv = $this$elementSerializer;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl12 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            return BuiltinSerializersKt.getNullable((KSerializer)selected);
        }
        return selected;
    }
}

