/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.serialization;

import io.ktor.features.ContentConverter;
import io.ktor.features.ContentNegotiation;
import io.ktor.http.ContentType;
import io.ktor.serialization.SerializationConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.jvm.KTypesJvm;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PlatformUtilsKt;
import kotlinx.serialization.SerializerResolvingKt;
import kotlinx.serialization.ShorthandsKt;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.HashMapSerializer;
import kotlinx.serialization.internal.HashSetSerializer;
import kotlinx.serialization.internal.MapEntrySerializer;
import kotlinx.serialization.internal.NullableSerializerKt;
import kotlinx.serialization.internal.ReferenceArraySerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0014\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005*\u0006\u0012\u0002\b\u00030\rH\u0002\u001a\u001e\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0015"}, d2={"DefaultJsonConfiguration", "Lkotlinx/serialization/json/JsonConfiguration;", "getDefaultJsonConfiguration", "()Lkotlinx/serialization/json/JsonConfiguration;", "arraySerializer", "Lkotlinx/serialization/KSerializer;", "type", "Lkotlin/reflect/KType;", "serializerByTypeInfo", "serializerForSending", "value", "", "elementSerializer", "", "serialization", "", "Lio/ktor/features/ContentNegotiation$Configuration;", "contentType", "Lio/ktor/http/ContentType;", "json", "Lkotlinx/serialization/json/Json;", "ktor-serialization"})
public final class SerializationConverterKt {
    @NotNull
    private static final JsonConfiguration DefaultJsonConfiguration = JsonConfiguration.copy$default((JsonConfiguration)JsonConfiguration.Companion.getStable(), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)true, null, null, (int)424, null);

    public static final void serialization(@NotNull ContentNegotiation.Configuration $this$serialization, @NotNull ContentType contentType, @NotNull Json json) {
        Intrinsics.checkParameterIsNotNull((Object)$this$serialization, (String)"$this$serialization");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        SerializationConverter converter = new SerializationConverter(json);
        ContentNegotiation.Configuration.register$default((ContentNegotiation.Configuration)$this$serialization, (ContentType)contentType, (ContentConverter)converter, null, (int)4, null);
    }

    public static /* synthetic */ void serialization$default(ContentNegotiation.Configuration configuration, ContentType contentType, Json json, int n, Object object) {
        if ((n & 1) != 0) {
            contentType = ContentType.Application.INSTANCE.getJson();
        }
        if ((n & 2) != 0) {
            json = new Json(DefaultJsonConfiguration, null, 2, null);
        }
        SerializationConverterKt.serialization(configuration, contentType, json);
    }

    @NotNull
    public static final JsonConfiguration getDefaultJsonConfiguration() {
        return DefaultJsonConfiguration;
    }

    private static final KSerializer<?> serializerByTypeInfo(KType type) {
        KClass classifierClass;
        KClassifier kClassifier = type.getClassifier();
        if (!(kClassifier instanceof KClass)) {
            kClassifier = null;
        }
        if ((classifierClass = (KClass)kClassifier) != null && JvmClassMappingKt.getJavaClass((KClass)classifierClass).isArray()) {
            return SerializationConverterKt.arraySerializer(type);
        }
        return SerializerResolvingKt.serializer((KType)type);
    }

    private static final KSerializer<?> arraySerializer(KType type) {
        KType kType = ((KTypeProjection)type.getArguments().get(0)).getType();
        if (kType == null) {
            String string = "Array<*> is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KType elementType = kType;
        KSerializer<?> elementSerializer = SerializationConverterKt.serializerByTypeInfo(elementType);
        KClass kClass = KTypesJvm.getJvmErasure((KType)elementType);
        if (kClass == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
        }
        KSerializer<?> kSerializer = elementSerializer;
        if (kSerializer == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
        }
        return (KSerializer)new ReferenceArraySerializer(kClass, kSerializer);
    }

    private static final KSerializer<?> serializerForSending(Object value) {
        if (value instanceof JsonElement) {
            return (KSerializer)JsonElementSerializer.INSTANCE;
        }
        if (value instanceof List) {
            return (KSerializer)new ArrayListSerializer(SerializationConverterKt.elementSerializer((Collection)value));
        }
        if (value instanceof Set) {
            return (KSerializer)new HashSetSerializer(SerializationConverterKt.elementSerializer((Collection)value));
        }
        if (value instanceof Map) {
            return (KSerializer)new HashMapSerializer(SerializationConverterKt.elementSerializer(((Map)value).keySet()), SerializationConverterKt.elementSerializer(((Map)value).values()));
        }
        if (value instanceof Map.Entry) {
            Object k = ((Map.Entry)value).getKey();
            if (k == null) {
                String string = "Map.Entry(null, ...) is not supported";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KSerializer<?> kSerializer = SerializationConverterKt.serializerForSending(k);
            Object v = ((Map.Entry)value).getValue();
            if (v == null) {
                String string = "Map.Entry(..., null) is not supported)";
                KSerializer<?> kSerializer2 = kSerializer;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KSerializer<?> kSerializer3 = SerializationConverterKt.serializerForSending(v);
            KSerializer<?> kSerializer4 = kSerializer;
            return (KSerializer)new MapEntrySerializer(kSerializer4, kSerializer3);
        }
        if (value instanceof Object[]) {
            KClass componentClass;
            Class<?> clazz = ((Object[])value).getClass().getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"value.javaClass.componentType");
            KType componentType = KClassifiers.getStarProjectedType((KClassifier)((KClassifier)JvmClassMappingKt.getKotlinClass(clazz)));
            KClassifier kClassifier = componentType.getClassifier();
            if (!(kClassifier instanceof KClass)) {
                kClassifier = null;
            }
            KClass kClass = (KClass)kClassifier;
            if (kClass == null) {
                String string = "Unsupported component type " + componentType;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KClass kClass2 = componentClass = kClass;
            if (kClass2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
            }
            KSerializer<?> kSerializer = SerializationConverterKt.serializerByTypeInfo(componentType);
            if (kSerializer == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
            }
            return (KSerializer)new ReferenceArraySerializer(kClass2, kSerializer);
        }
        return PlatformUtilsKt.serializer((KClass)Reflection.getOrCreateKotlinClass(value.getClass()));
    }

    /*
     * WARNING - void declaration
     */
    private static final KSerializer<?> elementSerializer(@NotNull Collection<?> $this$elementSerializer) {
        boolean bl;
        KSerializer selected;
        block13: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $this$elementSerializer;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                KSerializer<?> kSerializer;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object value = element$iv$iv;
                boolean bl3 = false;
                if (value != null) {
                    Object t;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    Object it = t;
                    boolean bl6 = false;
                    kSerializer = SerializationConverterKt.serializerForSending(it);
                } else {
                    kSerializer = null;
                }
                if (kSerializer == null) continue;
                KSerializer<?> kSerializer2 = kSerializer;
                boolean bl7 = false;
                boolean bl8 = false;
                KSerializer<?> it$iv$iv = kSerializer2;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$distinctBy$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                KSerializer it = (KSerializer)e$iv;
                boolean bl10 = false;
                String key$iv = it.getDescriptor().getName();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            List serializers = list$iv;
            if (serializers.size() > 1) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                String $this$map$iv;
                $this$distinctBy$iv = serializers;
                StringBuilder stringBuilder = new StringBuilder().append("Serializing collections of different element types is not yet supported. ").append("Selected serializers: ");
                boolean $i$f$map = false;
                set$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KSerializer bl10 = (KSerializer)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl11 = false;
                    String string = it.getDescriptor().getName();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                $this$map$iv = stringBuilder.append(collection).toString();
                $i$f$map = false;
                throw (Throwable)new IllegalStateException($this$map$iv.toString());
            }
            KSerializer kSerializer = (KSerializer)CollectionsKt.singleOrNull((List)serializers);
            if (kSerializer == null) {
                kSerializer = selected = ShorthandsKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE);
            }
            if (selected.getDescriptor().isNullable()) {
                return selected;
            }
            if (selected == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
            }
            Iterable $this$any$iv = $this$elementSerializer;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator2.next();
                    boolean bl12 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            return NullableSerializerKt.getNullable((KSerializer)selected);
        }
        return selected;
    }

    public static final /* synthetic */ KSerializer access$serializerForSending(Object value) {
        return SerializationConverterKt.serializerForSending(value);
    }

    public static final /* synthetic */ KSerializer access$serializerByTypeInfo(KType type) {
        return SerializationConverterKt.serializerByTypeInfo(type);
    }
}

