/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.serialization.kotlinx;

import io.ktor.serialization.WebsocketContentConverter;
import io.ktor.serialization.WebsocketConverterNotFoundException;
import io.ktor.serialization.WebsocketDeserializeException;
import io.ktor.serialization.kotlinx.SerializerLookupKt;
import io.ktor.util.reflect.TypeInfo;
import io.ktor.websocket.Frame;
import io.ktor.websocket.FrameCommonKt;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0016J,\u0010\u0012\u001a\u00020\r2\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0014J&\u0010\u0015\u001a\u00020\r2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/ktor/serialization/kotlinx/KotlinxWebsocketSerializationConverter;", "Lio/ktor/serialization/WebsocketContentConverter;", "format", "Lkotlinx/serialization/SerialFormat;", "(Lkotlinx/serialization/SerialFormat;)V", "deserialize", "", "charset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "typeInfo", "Lio/ktor/util/reflect/TypeInfo;", "content", "Lio/ktor/websocket/Frame;", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Lio/ktor/websocket/Frame;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isApplicable", "", "frame", "serialize", "value", "(Ljava/nio/charset/Charset;Lio/ktor/util/reflect/TypeInfo;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "serializeContent", "serializer", "Lkotlinx/serialization/KSerializer;", "ktor-serialization-kotlinx"})
public final class KotlinxWebsocketSerializationConverter
implements WebsocketContentConverter {
    @NotNull
    private final SerialFormat format;

    public KotlinxWebsocketSerializationConverter(@NotNull SerialFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.format = format;
        if (!(this.format instanceof BinaryFormat || this.format instanceof StringFormat)) {
            boolean bl = false;
            String string = "Only binary and string formats are supported, " + this.format + " is not supported.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public Object serialize(@NotNull Charset charset, @NotNull TypeInfo typeInfo, @Nullable Object value, @NotNull Continuation<? super Frame> $completion) {
        Object object;
        try {
            object = SerializerLookupKt.serializerForTypeInfo(this.format.getSerializersModule(), typeInfo);
        }
        catch (SerializationException cause) {
            object = SerializerLookupKt.guessSerializer(value, this.format.getSerializersModule());
        }
        Object serializer = object;
        return this.serializeContent((KSerializer<?>)serializer, this.format, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Object deserialize(@NotNull Charset charset, @NotNull TypeInfo typeInfo, @NotNull Frame content, @NotNull Continuation<Object> $completion) {
        Object object;
        if (!this.isApplicable(content)) {
            throw new WebsocketConverterNotFoundException("Unsupported frame " + content.getFrameType().name(), null, 2, null);
        }
        KSerializer<?> serializer = SerializerLookupKt.serializerForTypeInfo(this.format.getSerializersModule(), typeInfo);
        SerialFormat serialFormat = this.format;
        if (serialFormat instanceof StringFormat) {
            if (!(content instanceof Frame.Text)) throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + content.getFrameType().name(), null, content, 2, null);
            object = ((StringFormat)this.format).decodeFromString((DeserializationStrategy)serializer, FrameCommonKt.readText((Frame.Text)((Frame.Text)content)));
            return object;
        } else {
            if (!(serialFormat instanceof BinaryFormat)) throw new IllegalStateException(("Unsupported format " + this.format).toString());
            if (!(content instanceof Frame.Binary)) throw new WebsocketDeserializeException("Unsupported format " + this.format + " for " + content.getFrameType().name(), null, content, 2, null);
            object = ((BinaryFormat)this.format).decodeFromByteArray((DeserializationStrategy)serializer, FrameCommonKt.readBytes((Frame)content));
        }
        return object;
    }

    public boolean isApplicable(@NotNull Frame frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return frame instanceof Frame.Text || frame instanceof Frame.Binary;
    }

    private final Frame serializeContent(KSerializer<?> serializer, SerialFormat format, Object value) {
        Frame frame;
        SerialFormat serialFormat = format;
        if (serialFormat instanceof StringFormat) {
            StringFormat stringFormat = (StringFormat)format;
            Intrinsics.checkNotNull(serializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any?>");
            String content = stringFormat.encodeToString((SerializationStrategy)serializer, value);
            frame = (Frame)new Frame.Text(content);
        } else if (serialFormat instanceof BinaryFormat) {
            BinaryFormat binaryFormat = (BinaryFormat)format;
            Intrinsics.checkNotNull(serializer, (String)"null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any?>");
            byte[] content = binaryFormat.encodeToByteArray((SerializationStrategy)serializer, value);
            frame = (Frame)new Frame.Binary(true, content);
        } else {
            throw new IllegalStateException(("Unsupported format " + format).toString());
        }
        return frame;
    }
}

