/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.sockets;

import io.ktor.network.selector.SelectableBase;
import io.ktor.network.selector.SelectorManager;
import io.ktor.network.sockets.CIOReaderKt;
import io.ktor.network.sockets.CIOWriterKt;
import io.ktor.network.sockets.ReadWriteSocket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.io.ByteChannel;
import kotlinx.coroutines.io.ByteWriteChannel;
import kotlinx.coroutines.io.ByteWriteChannelKt;
import kotlinx.coroutines.io.ReaderJob;
import kotlinx.coroutines.io.WriterJob;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b \u0018\u0000*\u000e\b\u0000\u0010\u0001 \u0001*\u00020\u0002*\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006B%\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\n\u00100\u001a\u0004\u0018\u00010+H\u0002JE\u00101\u001a\u0002H2\"\b\b\u0001\u00102*\u00020'2\u0006\u00103\u001a\u0002042\u0006\u0010\u0007\u001a\u0002052\u000e\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H20\u001a2\f\u00107\u001a\b\u0012\u0004\u0012\u0002H208H\u0002\u00a2\u0006\u0002\u00109J\u000e\u0010:\u001a\u00020$2\u0006\u0010\u0007\u001a\u000205J\u000e\u0010;\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u000205J\b\u0010<\u001a\u00020 H\u0002J\b\u0010=\u001a\u00020 H\u0016J\u001e\u0010>\u001a\u0004\u0018\u00010+2\b\u0010?\u001a\u0004\u0018\u00010+2\b\u0010@\u001a\u0004\u0018\u00010+H\u0002J\b\u0010A\u001a\u00020 H\u0016R\u0016\u0010\u0007\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010$0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010%\u001a\u00020&*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010'0\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R*\u0010*\u001a\u0004\u0018\u00010+*\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010'0\u001a8BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b,\u0010-\u001a\u0004\b.\u0010/\u00a8\u0006B"}, d2={"Lio/ktor/network/sockets/NIOSocketImpl;", "S", "Ljava/nio/channels/ByteChannel;", "Ljava/nio/channels/SelectableChannel;", "Lio/ktor/network/sockets/ReadWriteSocket;", "Lio/ktor/network/selector/SelectableBase;", "Lkotlinx/coroutines/CoroutineScope;", "channel", "selector", "Lio/ktor/network/selector/SelectorManager;", "pool", "Lkotlinx/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "(Ljava/nio/channels/SelectableChannel;Lio/ktor/network/selector/SelectorManager;Lkotlinx/io/pool/ObjectPool;)V", "getChannel", "()Ljava/nio/channels/SelectableChannel;", "Ljava/nio/channels/SelectableChannel;", "closeFlag", "Ljava/util/concurrent/atomic/AtomicBoolean;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "getPool", "()Lkotlinx/io/pool/ObjectPool;", "readerJob", "Ljava/util/concurrent/atomic/AtomicReference;", "Lkotlinx/coroutines/io/ReaderJob;", "getSelector", "()Lio/ktor/network/selector/SelectorManager;", "socketContext", "Lkotlinx/coroutines/CompletableDeferred;", "", "getSocketContext", "()Lkotlinx/coroutines/CompletableDeferred;", "writerJob", "Lkotlinx/coroutines/io/WriterJob;", "completedOrNotStarted", "", "Lkotlinx/coroutines/Job;", "getCompletedOrNotStarted", "(Ljava/util/concurrent/atomic/AtomicReference;)Z", "exception", "", "exception$annotations", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "getException", "(Ljava/util/concurrent/atomic/AtomicReference;)Ljava/lang/Throwable;", "actualClose", "attachFor", "J", "name", "", "Lkotlinx/coroutines/io/ByteChannel;", "ref", "producer", "Lkotlin/Function0;", "(Ljava/lang/String;Lkotlinx/coroutines/io/ByteChannel;Ljava/util/concurrent/atomic/AtomicReference;Lkotlin/jvm/functions/Function0;)Lkotlinx/coroutines/Job;", "attachForReading", "attachForWriting", "checkChannels", "close", "combine", "e1", "e2", "dispose", "ktor-network"})
public abstract class NIOSocketImpl<S extends SelectableChannel>
extends SelectableBase
implements ReadWriteSocket,
CoroutineScope {
    private final AtomicBoolean closeFlag;
    private final AtomicReference<ReaderJob> readerJob;
    private final AtomicReference<WriterJob> writerJob;
    @NotNull
    private final CompletableDeferred<Unit> socketContext;
    @NotNull
    private final S channel;
    @NotNull
    private final SelectorManager selector;
    @Nullable
    private final ObjectPool<ByteBuffer> pool;

    @NotNull
    public CompletableDeferred<Unit> getSocketContext() {
        return this.socketContext;
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return (CoroutineContext)this.getSocketContext();
    }

    @Override
    @NotNull
    public final WriterJob attachForReading(@NotNull ByteChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        return this.attachFor("reading", channel, this.writerJob, (Function0)new Function0<WriterJob>(this, channel){
            final /* synthetic */ NIOSocketImpl this$0;
            final /* synthetic */ ByteChannel $channel;

            @NotNull
            public final WriterJob invoke() {
                return this.this$0.getPool() != null ? CIOReaderKt.attachForReadingImpl(this.this$0, this.$channel, (ReadableByteChannel)this.this$0.getChannel(), this.this$0, this.this$0.getSelector(), this.this$0.getPool()) : CIOReaderKt.attachForReadingDirectImpl(this.this$0, this.$channel, (ReadableByteChannel)this.this$0.getChannel(), this.this$0, this.this$0.getSelector());
            }
            {
                this.this$0 = nIOSocketImpl;
                this.$channel = byteChannel;
                super(0);
            }
        });
    }

    @Override
    @NotNull
    public final ReaderJob attachForWriting(@NotNull ByteChannel channel) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        return this.attachFor("writing", channel, this.readerJob, (Function0)new Function0<ReaderJob>(this, channel){
            final /* synthetic */ NIOSocketImpl this$0;
            final /* synthetic */ ByteChannel $channel;

            @NotNull
            public final ReaderJob invoke() {
                return CIOWriterKt.attachForWritingDirectImpl(this.this$0, this.$channel, (WritableByteChannel)this.this$0.getChannel(), this.this$0, this.this$0.getSelector());
            }
            {
                this.this$0 = nIOSocketImpl;
                this.$channel = byteChannel;
                super(0);
            }
        });
    }

    @Override
    public void dispose() {
        this.close();
    }

    @Override
    public void close() {
        if (this.closeFlag.compareAndSet(false, true)) {
            ReaderJob readerJob = this.readerJob.get();
            if (readerJob != null && (readerJob = readerJob.getChannel()) != null) {
                ByteWriteChannelKt.close((ByteWriteChannel)readerJob);
            }
            WriterJob writerJob = this.writerJob.get();
            if (writerJob != null) {
                writerJob.cancel();
            }
            this.checkChannels();
        }
    }

    private final <J extends Job> J attachFor(String name, ByteChannel channel, AtomicReference<J> ref, Function0<? extends J> producer) {
        if (this.closeFlag.get()) {
            ClosedChannelException e = new ClosedChannelException();
            channel.close((Throwable)e);
            throw (Throwable)e;
        }
        Job j = (Job)producer.invoke();
        if (!ref.compareAndSet(null, j)) {
            IllegalStateException e = new IllegalStateException(name + " channel has been already set");
            j.cancel();
            throw (Throwable)e;
        }
        if (this.closeFlag.get()) {
            ClosedChannelException e = new ClosedChannelException();
            j.cancel();
            channel.close((Throwable)e);
            throw (Throwable)e;
        }
        channel.attachJob(j);
        j.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(this){
            final /* synthetic */ NIOSocketImpl this$0;

            public final void invoke(@Nullable Throwable it) {
                NIOSocketImpl.access$checkChannels(this.this$0);
            }
            {
                this.this$0 = nIOSocketImpl;
                super(1);
            }
        });
        return (J)j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Throwable actualClose() {
        Throwable throwable;
        try {
            ((java.nio.channels.ByteChannel)this.getChannel()).close();
            super.close();
            this.getSocketContext().complete((Object)Unit.INSTANCE);
            throwable = null;
        }
        catch (Throwable t) {
            throwable = t;
        }
        finally {
            this.selector.notifyClosed(this);
        }
        return throwable;
    }

    private final void checkChannels() {
        if (this.closeFlag.get() && this.getCompletedOrNotStarted(this.readerJob) && this.getCompletedOrNotStarted(this.writerJob)) {
            Throwable e1 = this.getException(this.readerJob);
            Throwable e2 = this.getException(this.writerJob);
            Throwable e3 = this.actualClose();
            Throwable combined = this.combine(this.combine(e1, e2), e3);
            if (combined == null) {
                this.getSocketContext().complete((Object)Unit.INSTANCE);
            } else {
                this.getSocketContext().completeExceptionally(combined);
            }
        }
    }

    private final Throwable combine(Throwable e1, Throwable e2) {
        Throwable throwable;
        if (e1 == null) {
            throwable = e2;
        } else if (e2 == null) {
            throwable = e1;
        } else if (e1 == e2) {
            throwable = e1;
        } else {
            ExceptionsKt.addSuppressed((Throwable)e1, (Throwable)e2);
            throwable = e1;
        }
        return throwable;
    }

    private final boolean getCompletedOrNotStarted(@NotNull AtomicReference<? extends Job> $receiver) {
        Job job;
        Job it = job = $receiver.get();
        boolean bl = false;
        return it == null || it.isCompleted();
    }

    private static /* synthetic */ void exception$annotations(AtomicReference atomicReference) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Throwable getException(@NotNull AtomicReference<? extends Job> $receiver) {
        Job job;
        Job job2 = $receiver.get();
        Object object = job2;
        if (job2 == null) return null;
        Job it = job = object;
        boolean bl = false;
        if (it.isActive()) return null;
        if (it.isCancelled()) {
            return null;
        }
        boolean bl2 = false;
        if (bl2) return null;
        Job job3 = job;
        object = job3;
        if (job3 == null) return null;
        CancellationException cancellationException = object.getCancellationException();
        object = cancellationException;
        if (cancellationException == null) return null;
        it = job = object;
        boolean bl3 = false;
        Job job4 = it;
        if (!(job4 instanceof CancellationException)) {
            return null;
        }
        if (job4 == null) return null;
        Throwable throwable = job4.getCause();
        return throwable;
    }

    @NotNull
    public S getChannel() {
        return this.channel;
    }

    @NotNull
    public final SelectorManager getSelector() {
        return this.selector;
    }

    @Nullable
    public final ObjectPool<ByteBuffer> getPool() {
        return this.pool;
    }

    public NIOSocketImpl(@NotNull S channel, @NotNull SelectorManager selector, @Nullable ObjectPool<ByteBuffer> pool) {
        Intrinsics.checkParameterIsNotNull(channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        super((SelectableChannel)channel);
        this.channel = channel;
        this.selector = selector;
        this.pool = pool;
        this.closeFlag = new AtomicBoolean();
        this.readerJob = new AtomicReference();
        this.writerJob = new AtomicReference();
        this.socketContext = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
    }

    public static final /* synthetic */ void access$checkChannels(NIOSocketImpl $this) {
        $this.checkChannels();
    }
}

